/*
 * PROJECT C Library, X68000 PROGRAMMING INTERFACE DEFINITION
 * --------------------------------------------------------------------
 * This file is written by the Project C Library Group,  and completely
 * in public domain. You can freely use, copy, modify, and redistribute
 * the whole contents, without this notice.
 * --------------------------------------------------------------------
 * $Id: fconvert.c,v 1.1.1.2 1999/01/20 04:59:39 matz Exp $
 */
/* changed 1997.2.3 by K.Okabe */

/* System headers */
#include <stdlib.h>
#include <sys/xstdlib.h>

/* Functions */
char *fconvert (double x, int ndigit, int *decpt, int *sign, char *buffer)
{
    int pos, n;
    char *src, *dst;
    char string[24];
    int figup;

    /* 18ʸѴ */
    _dtos18 (x, decpt, sign, string);

    /* ԡɥ쥹 */
    src = string;

    /* ԡ襢ɥ쥹 */
    dst = buffer;

    /* ֤ */
    pos = *decpt;

    /* ֤ʤ */
    if (pos < 0) {

	/* ׻ */
	n = min (-pos, ndigit);

	/* Ƭ0 */
	while (n-- > 0)
	    *dst++ = '0';

	/* ֤0ˤʤ */
	*decpt = 0;

    }

    /* ĤΥԡ */
    n = ndigit + pos;

    /* Ǽ˥ԡ */
    while (n-- > 0) {

	/* ­ʤʬ0 */
	if (*src == '\0') {
	    while (n-- >= 0)
		*dst++ = '0';
	    break;
	}

	/* Ѵʸ󤫤饳ԡ */
	*dst++ = *src++;

    }

    /* ݤ */
    *decpt += (figup = _round (buffer, dst, *src));

    /* 夬꤬0ɲä */
    if (figup)
	*dst++ = '0';

    /* ü NUL Ǥ */
    *dst = '\0';

    /* ɥ쥹֤ */
    return buffer;
}
