#!/usr/local/bin/perl
# create_hint.cgi
# Create a new root zone

require './bind8-lib.pl';
&ReadParse();
&error_setup($text{'hcreate_err'});
%access = &get_module_acl();
$access{'master'} || &error($text{'hcreate_ecannot'});
$access{'ro'} && &error($text{'master_ero'});

# Validate inputs
&allowed_zone_file(\%access, $in{'file'}) || &error($text{'hcreate_efile'});
open(FILE, ">>$config{'chroot'}$in{'file'}") || &error($text{'hcreate_efile2'});
close(FILE);

# Get the root server information
if ($in{'real'} == 1) {
	# Download from internic
	&ftp_download("rs.internic.net", "/domain/named.root", 
		      "$config{'chroot'}$in{'file'}");
	}
elsif ($in{'real'} == 2) {
	# Use webmin's copy
	system("cp ./db.cache $config{'chroot'}$in{'file'} 2>/dev/null");
	}
else {
	# Just check the existing file
	@recs = &read_zone_file($config{'chroot'}.$in{'file'}, ".");
	&error($text{'mcreate_erecs'}) if (@recs < 2);
	}

# Add a new hint zone
$dir = { 'name' => 'zone',
	 'values' => [ '.' ],
	 'type' => 1,
	 'members' => [ { 'name' => 'type',
			  'values' => [ 'hint' ] },
			{ 'name' => 'file',
			  'values' => [ $in{'file'} ] }
		      ]
	};
if ($in{'view'} ne '') {
	$conf = &get_config();
	$view = $conf->[$in{'view'}];
	&lock_file($config{'chroot'}.$view->{'file'});
	&save_directive($view, undef, [ $dir ], 1);
	&flush_file_lines();
	&unlock_file($config{'chroot'}.$view->{'file'});
	}
else {
	$pconf = &get_config_parent();
	&lock_file($config{'chroot'}.$pconf->{'file'});
	&save_directive($pconf, undef, [ $dir ], 0);
	&flush_file_lines();
	&unlock_file($config{'chroot'}.$pconf->{'file'});
	}
&webmin_log("create", "hint", ".", \%in);
&redirect("");

