#!/usr/local/bin/perl
# list_groups.cgi
# Display all groups in the database

require './postgresql-lib.pl';
$access{'users'} || &error($text{'group_ecannot'});
&header($text{'group_title'}, "", "list_groups");
print "<hr>\n";

$s = &execute_sql($config{'basedb'}, "select * from pg_user");
foreach $u (@{$s->{'data'}}) {
	$uid{$u->[1]} = $u->[0];
	}

$s = &execute_sql($config{'basedb'}, "select * from pg_group");
if (@{$s->{'data'}}) {
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'group_name'}</b></td> ",
	      "<td><b>$text{'group_id'}</b></td> ",
	      "<td><b>$text{'group_mems'}</b></td> </tr>\n";
	foreach $g (@{$s->{'data'}}) {
		print "<tr $cb>\n";
		print "<td><a href='edit_group.cgi?gid=$g->[1]'>",
		      &html_escape($g->[0]),"</a></td>\n";
		print "<td>$g->[1]</td>\n";
		print "<td>",join("&nbsp;|&nbsp;",
		     map { &html_escape($uid{$_}) } &split_array($g->[2])),
		      "&nbsp;</td>\n";
		print "</tr>\n";
		}
	print "</table>\n";
	}
else {
	print "<b>$text{'group_none'}</b><p>\n";
	}
print "<a href='edit_group.cgi?new=1'>$text{'group_add'}</a><p>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

