/***************************************************************************
                          agconfig.cpp  -  description
                             -------------------
    begin                : Fri Mar 30 2001
    copyright            : (C) 2001 by Joe Theriault
    email                : uallloveme@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qtextstream.h>

#include "agconfig.h"

AGConfig::AGConfig(QString ag_directory, bool readConfig = true)
{
  if(ag_directory)
  {
    ag_dir = ag_directory;

    QString path = ag_dir;
    path += "/account.txt";
    account_file.setName(path);
    
    path = ag_dir;
    path += "/shares.txt";
    shares_file.setName(path);
  }
    
  if(readConfig)
    read();
  
  changed = false;
}


bool AGConfig::hasChanged()
{
  return changed;
}


QString AGConfig::getAGDir()
{
  return ag_dir;
}


QString AGConfig::getName()
{
  return name;
}


QString AGConfig::getPass()
{
  return pass;
}


QString AGConfig::getDLDir()
{
  return dl_dir;
}


QStringList AGConfig::getShares()
{
  return shares;
}


bool AGConfig::read()
{
  if(account_file.open(IO_ReadOnly))
  {
    QTextStream in;

    name = "";
    pass = "";
    dl_dir = "";
    shares.clear();

    if(shares_file.open(IO_ReadOnly))
    {
      in.setDevice(&shares_file);
      if(!in.eof()) dl_dir = in.readLine();
      while(!in.eof())
        shares += in.readLine();

      shares_file.close();
    }
    else
      return false;
    
    in.setDevice(&account_file);
    if(!in.eof()) name = in.readLine();
    if(!in.eof()) pass = in.readLine();

    account_file.close();
  }

  changed = false;
  return true;
}


bool AGConfig::write()
{
  if(account_file.open(IO_WriteOnly))
  {
    QTextStream out;
    
    if(shares_file.open(IO_WriteOnly))
    {
      out.setDevice(&shares_file);
      out << dl_dir << "\n";
      for ( QStringList::Iterator it = shares.begin(); it != shares.end(); ++it )
        out << (*it) << "\n";

      out.device()->flush();
      shares_file.close();
    }
    else
      return false;

    out.setDevice(&account_file);
    out << name << "\n" << pass;

    out.device()->flush();
    account_file.close();
  }

  changed = false;
  return true;
}


void AGConfig::setAGDir(QString newAGDir)
{
  ag_dir = newAGDir;
}


void AGConfig::setName(QString newName)
{
  name = newName;
}


void AGConfig::setPass(QString newPass)
{
  pass = newPass;
}


void AGConfig::setDLDir(QString newDLDir)
{
  dl_dir = newDLDir;
}


void AGConfig::setShares(QStringList newShares)
{
  shares = newShares;
}
