/***************************************************************************
                          agtray.cpp  -  description
                             -------------------
    begin                : Sun Mar 4 2001
    copyright            : (C) 2001 by Joe Theriault
    email                : uallloveme@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <kaboutkde.h>
#include <kaboutapplication.h>
#include <kpopupmenu.h>

#include "agbrowser.h"
#include "agtray.h"

AGTray::AGTray(QWidget* parent = 0, const char* name = 0)
 : KSystemTray(parent, name)
{
  contextMenu()->insertItem(kapp->iconLoader()->loadIcon("go", KIcon::SizeSmall, 12), "About KDE", this, SLOT(aboutKDE()));
  contextMenu()->insertItem(kapp->iconLoader()->loadIcon("agbrowser", KIcon::SizeSmall, 12), "About AudioGalaxy Browser for KDE2", this, SLOT(aboutApp()));
  contextMenu()->insertSeparator();
  contextMenu()->insertItem(kapp->iconLoader()->loadIcon("mail_send", KIcon::SizeSmall, 12), "Report Bug...", this, SLOT(reportBug()));
  contextMenu()->insertSeparator();
  contextMenu()->insertItem(kapp->iconLoader()->loadIcon("kfm", KIcon::SizeSmall, 12), "Manage Downloads", this, SLOT(manage()));
  if(((AGBrowser*) parentWidget())->client->isRunning())
  {
    setPixmap(kapp->iconLoader()->loadIcon("sat-up", KIcon::Toolbar, KIcon::SizeSmall));
    connectItem = contextMenu()->insertItem(kapp->iconLoader()->loadIcon("connect_no", KIcon::SizeSmall, 12), "Disconnect", this, SLOT(stateChangeRequested()));
  }
  else
  {
    setPixmap(kapp->iconLoader()->loadIcon("sat-down", KIcon::Toolbar, KIcon::SizeSmall));
    connectItem = contextMenu()->insertItem(kapp->iconLoader()->loadIcon("connect_established", KIcon::SizeSmall, 12), "Connect", this, SLOT(stateChangeRequested()));
  }

  connect(parentWidget(), SIGNAL(AGdisconnected()), this, SLOT(disconnected()));
  connect(parentWidget(), SIGNAL(AGconnected()), this, SLOT(connected()));
}

void AGTray::aboutKDE()
{
  KAboutKDE about;
  about.show();
}

void AGTray::aboutApp()
{
  KAboutApplication about;
  about.show();
}

void AGTray::reportBug()
{
  kapp->invokeMailer("Joe Theriault <uallloveme@yahoo.com>", "AudioGalaxy Browser For KDE2 Bug Report");
}

void AGTray::manage()
{
  ((AGBrowser*) parentWidget())->manageMp3s();
}

void AGTray::stateChangeRequested()
{
  if(((AGBrowser*) parentWidget())->client->isRunning())
	 ((AGBrowser*) parentWidget())->disconnectAG();
  else
    ((AGBrowser*) parentWidget())->runSatellite();
}

void AGTray::connected()
{
    setPixmap(kapp->iconLoader()->loadIcon("sat-up", KIcon::Toolbar, KIcon::SizeSmall));
    contextMenu()->changeItem(connectItem, kapp->iconLoader()->loadIcon("connect_no", KIcon::SizeSmall, 12), "Disconnect");
}

void AGTray::disconnected()
{
    setPixmap(kapp->iconLoader()->loadIcon("sat-down", KIcon::Toolbar, KIcon::SizeSmall));
    contextMenu()->changeItem(connectItem, kapp->iconLoader()->loadIcon("connect_established", KIcon::SizeSmall, 12), "Connect");
}

