/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationFactory;
import gov.llnl.babel.symbols.BadRegexException;
import gov.llnl.babel.symbols.RegexMatch;
import gov.llnl.babel.symbols.RegexUnsupportedException;
import java.io.File;
import java.io.IOException;

public class UserOptions {
    private static final LongOpt[] d_long_opts = new LongOpt[]{new LongOpt("generate-assertions", 1, null, 97), new LongOpt("client", 1, null, 99), new LongOpt("exclude", 1, null, 101), new LongOpt("exclude-external", 0, null, 69), new LongOpt("generate-subdirs", 0, null, 103), new LongOpt("help", 0, null, 104), new LongOpt("generate-interceptors", 0, null, 105), new LongOpt("language-subdir", 0, null, 108), new LongOpt("make-prefix", 1, null, 109), new LongOpt("output-directory", 1, null, 111), new LongOpt("parse-check", 0, null, 112), new LongOpt("repository-path", 1, null, 82), new LongOpt("server", 1, null, 115), new LongOpt("text", 1, null, 116), new LongOpt("hide-glue", 0, null, 117), new LongOpt("version", 0, null, 118), new LongOpt("vpath", 1, null, 86), new LongOpt("cxx-ior-exception", 0, null, 120), new LongOpt("generate-sidl-stdlib", 0, null, 5), new LongOpt("no-default-repository", 0, null, 6), new LongOpt("suppress-timestamp", 0, null, 7), new LongOpt("comment-local-only", 0, null, 8), new LongOpt("short-file-names", 0, null, 9)};
    private boolean d_can_proceed = false;
    private static UserOptions s_my_instance = null;

    protected UserOptions() {
    }

    public static UserOptions getInstance() {
        if (s_my_instance == null) {
            s_my_instance = new UserOptions();
        }
        return s_my_instance;
    }

    public int parseCommandlineOptions(BabelConfiguration theConfig, String[] args) {
        int c;
        Getopt commandlineOptions = new Getopt("babel", args, "Eghilpuvxa:o:c:R:s:t:e:m:", d_long_opts);
        int numRequired = 0;
        boolean helpSet = false;
        boolean versionSet = false;
        block32: while ((c = commandlineOptions.getopt()) != -1) {
            switch (c) {
                case 5: {
                    theConfig.setGenerateStdlib(true);
                    ++numRequired;
                    continue block32;
                }
                case 6: {
                    System.err.println("Babel: Warning: no-default-repository is a babel driver script option only.");
                    continue block32;
                }
                case 7: {
                    theConfig.setSuppressTimestamps(true);
                    continue block32;
                }
                case 8: {
                    theConfig.setCommentLocalOnly(true);
                    continue block32;
                }
                case 9: {
                    theConfig.setShortFileNames(true);
                    continue block32;
                }
                case 112: {
                    theConfig.setParseCheckOnly(true);
                    ++numRequired;
                    continue block32;
                }
                case 109: {
                    theConfig.setMakePrefix(commandlineOptions.getOptarg());
                    continue block32;
                }
                case 99: {
                    String clang = commandlineOptions.getOptarg().toLowerCase();
                    if (this.validClientLanguage(clang)) {
                        theConfig.setGenerateClient(true);
                        theConfig.setTargetLanguage(clang);
                        ++numRequired;
                        continue block32;
                    }
                    System.err.println("Babel: Error: Unsupported language (" + clang + ") specified for client option.");
                    continue block32;
                }
                case 115: {
                    String slang = commandlineOptions.getOptarg().toLowerCase();
                    if (UserOptions.validServerLanguage(slang)) {
                        theConfig.setGenerateServer(true);
                        theConfig.setTargetLanguage(slang);
                        ++numRequired;
                        continue block32;
                    }
                    System.err.println("Babel: Error: Unsupported language (" + slang + ") specified for server option.");
                    continue block32;
                }
                case 116: {
                    String tlang = commandlineOptions.getOptarg().toLowerCase();
                    if (this.validTextRepresentation(tlang)) {
                        theConfig.setGenerateText(true);
                        theConfig.setTargetLanguage(tlang);
                        ++numRequired;
                        continue block32;
                    }
                    System.err.println("Babel: Error: Unsupported language representation (" + tlang + ") specified for text option.");
                    continue block32;
                }
                case 104: {
                    helpSet = true;
                    ++numRequired;
                    continue block32;
                }
                case 118: {
                    versionSet = true;
                    ++numRequired;
                    continue block32;
                }
                case 82: {
                    String shortname = commandlineOptions.getOptarg();
                    boolean absolutePath = false;
                    File[] roots = File.listRoots();
                    if (!shortname.endsWith("" + File.separatorChar)) {
                        shortname = shortname + File.separatorChar;
                    }
                    for (int i = 0; i < roots.length; ++i) {
                        if (roots[i].toString().compareTo(shortname.substring(0, roots[i].toString().length())) != 0) continue;
                        absolutePath = true;
                    }
                    if (absolutePath) {
                        theConfig.addToRepositoryPath(shortname);
                        continue block32;
                    }
                    File file = new File(".");
                    try {
                        theConfig.addToRepositoryPath(file.getCanonicalPath() + File.separatorChar + shortname);
                    }
                    catch (IOException e) {
                        System.err.println("Unable to get path to current directory! Any XML output may contain an incorrect path!");
                    }
                    continue block32;
                }
                case 111: {
                    theConfig.setOutputDirectory(commandlineOptions.getOptarg());
                    continue block32;
                }
                case 86: {
                    theConfig.setVPathDirectory(commandlineOptions.getOptarg());
                    continue block32;
                }
                case 103: {
                    theConfig.setMakePackageSubdirs(true);
                    continue block32;
                }
                case 101: {
                    try {
                        theConfig.addExcluded(new RegexMatch(commandlineOptions.getOptarg()));
                    }
                    catch (RegexUnsupportedException rue) {
                        System.err.println("Babel: The --exclude=<regex> | -e <regex> feature requires a Java runtime environment with the");
                        System.err.println("1.4 library or higher for regular expression support.");
                        System.err.println("You must use a more recent version of Java to use this feature.");
                    }
                    catch (BadRegexException bre) {
                        System.err.println("Babel: " + bre.getMessage());
                    }
                    continue block32;
                }
                case 108: {
                    theConfig.setMakeLanguageSubdir(true);
                    continue block32;
                }
                case 117: {
                    theConfig.setMakeGlueSubdirs(true);
                    continue block32;
                }
                case 69: {
                    theConfig.setExcludeExternal(true);
                    continue block32;
                }
                case 97: {
                    String alvl = commandlineOptions.getOptarg();
                    if (this.validAssertionLevel(alvl)) {
                        theConfig.setGenerateAssertions(alvl);
                        continue block32;
                    }
                    System.err.println("Babel: Error: Unsupported assertion checking level (" + alvl + ") specified for generate assertion option.");
                    continue block32;
                }
                case 105: {
                    theConfig.setGenerateInterceptors(true);
                    continue block32;
                }
                case 120: {
                    theConfig.setCxxCheckNullIOR(true);
                    continue block32;
                }
                case 58: {
                    continue block32;
                }
                case 63: {
                    continue block32;
                }
            }
            System.err.println("Babel: Error: Should never have reached default in gov.llnl.babel.UserOptions.");
        }
        int returnIndex = commandlineOptions.getOptind();
        if (returnIndex == 0 && returnIndex == args.length) {
            helpSet = true;
            numRequired = 1;
        }
        if (theConfig.generateClient() && theConfig.getTargetLanguage().equals("python") && theConfig.generateStdlib()) {
            System.err.println("Babel: Warning:  Allowing concurrent request for python client and SIDL standard library generation.");
            --numRequired;
        }
        if (numRequired > 1) {
            System.err.println("Babel: Error: Only one of the following options or its equivalent is allowed:");
            System.err.println("         --help, --version, --client, --server, --text,");
            System.err.println("         --parse-check, or --generate-sidl-stdlib.");
        } else if (numRequired < 1) {
            System.err.println("Babel: Error: You must enter one of the following options or its equivalent along with");
            System.err.println("       any associated argument:");
            System.err.println("         --help, --version, --client, --server, --text,");
            System.err.println("         --parse-check, or --generate-sidl-stdlib.");
        } else if (versionSet || helpSet) {
            if (versionSet) {
                System.out.println("Babel version 0.10.2");
            }
            if (helpSet) {
                System.out.println();
                this.printUsage();
            }
        } else {
            this.d_can_proceed = true;
            if (theConfig.generateStdlib()) {
                theConfig.setGenerateServer(true);
                if (!theConfig.generateClient() || !"python".equals(theConfig.getTargetLanguage())) {
                    theConfig.setTargetLanguage("c");
                }
            }
        }
        return returnIndex;
    }

    public void printUsage() {
        System.out.println("Usage:  babel [ -h | --help ]");
        System.out.println("   or   babel [ -v | --version ]");
        System.out.println("   or   babel option(s) sidlfilename1 ... sidlfilenameN");
        System.out.println();
        System.out.println("where help, version, and option(s) are:");
        System.out.println(" -h       | --help          Display usage information and exit.");
        System.out.println(" -v       | --version       Display version and exit.");
        System.out.println(" -p       | --parse-check   Parse the sidl file but do not generate code.");
        System.out.println(" -c<lang> | --client=<lang> Generate only client code in specified language");
        System.out.println("                            (C | C++ | UC++ | F77 | F90 | Java | Python).");
        System.out.println(" -r | --with-rmi            Generate remote client code in specified");
        System.out.println("                            language ().");
        System.out.println(" -s<lang> | --server=<lang> Generate server (and client) code in specified");
        System.out.println("                            language (C | C++ | F77 | F90 | Java | Python).");
        System.out.println(" -t<form> | --text=<form>   Generate text in specified form (XML | SIDL), where");
        System.out.println("                            XML updates the repository.");
        System.out.println(" -o<dir>  | --output-directory=<dir>");
        System.out.println("                            Set Babel output directory ('.' default).");
        System.out.println(" -R<path> | --repository-path=<path>");
        System.out.println("                            Set semicolon-separated URL list used to resolve");
        System.out.println("                            symbols.");
        System.out.println(" -e<regex> | --exclude=<regex>");
        System.out.println("                            Symbols matching the regular expression");
        System.out.println("                            are excluded from code generation.");
        System.out.println("                            Requires JRE 1.4 virtual machine or higher.");
        System.out.println("                            matching package hierarchy.");
        System.out.println(" -E        | --exclude-external");
        System.out.println("                            Code is generated only for the symbol hierarchies ");
        System.out.println("                            rooted at the symbols specified on the command line.");
        System.out.println(" -V<path>  | --vpath=<path> Prepend alternative search path for reading Impl");
        System.out.println("                            splicer blocks.  Does not affect where Impls are");
        System.out.println("                            generated.");
        System.out.println("                            NOTE: --vpath=. is a no-op for autoconf/automake");
        System.out.println("                            If you really want current directory, use");
        System.out.println("                            another argument like `pwd` or even ./.");
        System.out.println(" -a<lvl>  | --generate-assertions=<lvl>");
        System.out.println("                            Generate SIDL-specified assertion checking");
        System.out.println("                            code.");
        System.out.println("                            NOTE: 0=None, 1=Minimal stas, 2=Full stats.");
        System.out.println(" -i       | --generate-interceptors");
        System.out.println("                            Generate method interceptors in the form of pre-");
        System.out.println("                            and post-method hooks.");
        System.out.println(" -g       | --generate-subdirs");
        System.out.println("                            Postpend Java-style package subdirs");
        System.out.println("                            to paths specified by -o and -V.");
        System.out.println(" -l       | --language-subdir");
        System.out.println("                            Generate code in a language-specific");
        System.out.println("                            subdirectory.");
        System.out.println(" -u       | --hide-glue     Put \"glue\" (not modifiable by user) generated");
        System.out.println("                            code in a glue/ subdirectory.");
        System.out.println(" --no-default-repository    Prohibit use of default to resolve symbols.");
        System.out.println(" --suppress-timestamp       Suppress timestamps in generated files.");
        System.out.println(" --generate-sidl-stdlib     Regenerate only the SIDL standard library.");
        System.out.println(" --comment-local-only       Only comment locally defined methods in stub.");
        System.out.println(" --short-file-names         Use in conjunction with -g to generate file names");
        System.out.println("                            that don't include package names.");
        System.out.println(" --cxx-ior-exception        Include IOR pointer checking in C++ Stubs, throws");
        System.out.println("                            a NullIORException if IOR is Null.");
        System.out.println();
        System.out.println("Note:  One of the following options or its equivalent must be specified:");
        System.out.println("         --help, --version, --client, --server, --text, --parse-check, or");
        System.out.println("         --generate-sidl-stdlib.");
        System.out.println();
        System.out.println("If you have any suggestions or questions not answered by the documenation,");
        System.out.println("please send email to components@llnl.gov.");
    }

    private boolean validClientLanguage(String lang) {
        CodeGenerationFactory factory = CodeGenerationFactory.getInstance();
        return factory.getCodeGenerator(lang, "stub") != null;
    }

    private boolean validAssertionLevel(String alvl) {
        boolean is = alvl.equals("0") || alvl.equals("1") || alvl.equals("2");
        return is;
    }

    private static boolean validServerLanguage(String lang) {
        CodeGenerationFactory factory = CodeGenerationFactory.getInstance();
        return factory.getCodeGenerator(lang, "skel") != null;
    }

    private boolean validTextRepresentation(String lang) {
        CodeGenerationFactory factory;
        boolean isValid = false;
        isValid = lang.equals("xml") ? true : (factory = CodeGenerationFactory.getInstance()).getCodeGenerator(lang, "text") != null;
        return isValid;
    }

    public boolean canProceed() {
        return this.d_can_proceed;
    }

    public static void main(String[] args) {
        UserOptions opts = UserOptions.getInstance();
        BabelConfiguration config = new BabelConfiguration();
        System.out.println("\n...Processing the command line...");
        opts.parseCommandlineOptions(config, args);
        if (opts.canProceed()) {
            System.out.println("\n*** Able to proceed with compilation request ***");
        } else {
            System.out.println("\n*** CANNOT proceed with compilation ***");
        }
        System.out.println("\n\n...Printing resulting settings...");
        System.out.println("Generate Assertions  = " + config.getAssertionLevel());
        System.out.println("Generate Interceptors= " + config.generateInterceptors());
        System.out.println("Generate Client      = " + config.generateClient());
        System.out.println("Generate Server      = " + config.generateServer());
        System.out.println("Generate Text        = " + config.generateText());
        System.out.println("Generate SIDL Stdlib = " + config.generateStdlib());
        System.out.println("Parse Only           = " + config.parseCheckOnly());
        System.out.println("Target Language      = " + config.getTargetLanguage());
        System.out.println("Output Directory     = " + config.getOutputDirectory());
        System.out.println("VPATH Directory      = " + config.getVPathDirectory());
        System.out.println("Make Pkg Subdirs     = " + config.makePackageSubdirs());
        System.out.println("Repository Path      = " + config.getRepositoryPath());
        System.out.println("Suppress Timestamps  = " + config.suppressTimestamps());
        System.out.println("Make Language Subdir = " + config.makeLanguageSubdir());
        System.out.println("Make Glue Subdir     = " + config.makeGlueSubdirs());
        System.out.println("Exclude External Pkgs= " + config.excludeExternal());
        System.out.println("\n\n...Done.");
    }
}

