/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.rmi2;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.LevelComparator;
import gov.llnl.babel.backend.rmi2.Cxx;
import gov.llnl.babel.backend.writers.LanguageWriterForCxx;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.Comment;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class CxxStubSource {
    private Extendable d_ext = null;
    private LanguageWriterForCxx d_writer = null;
    private String d_self = null;

    public CxxStubSource(Extendable ext) {
        this.d_ext = ext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void generateCode() throws CodeGenerationException {
        String filename = Cxx.generateFilename(this.d_ext.getSymbolID(), 3, 2);
        this.d_self = this.d_ext.isInterface() ? "d_self->d_object" : "d_self";
        try {
            this.d_writer = Cxx.createSource(this.d_ext, 3, "STUBSRCS");
            this.d_writer.println();
            this.writeIncludes();
            this.writeUserDefinedMethods();
            this.writeConstructors();
            this.writeCastingOperators();
            if (!this.d_ext.isInterface()) {
                this.writeDynamicImplStuff();
            }
            Object var3_2 = null;
            if (this.d_writer == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.d_writer == null) throw throwable;
            this.d_writer.close();
            this.d_writer = null;
            throw throwable;
        }
        this.d_writer.close();
        this.d_writer = null;
    }

    private void writeIncludes() {
        SymbolID id = this.d_ext.getSymbolID();
        this.d_writer.generateInclude(Cxx.generateFilename(this.d_ext.getSymbolID(), 3, 1), true);
        this.d_writer.generateInclude(Cxx.generateFilename("sidl.BaseInterface", 3, 1), true);
        this.d_writer.generateInclude(Cxx.generateFilename("sidl.BaseClass", 3, 1), true);
        if (this.d_ext.hasExceptionThrowingMethod(true)) {
            this.d_writer.generateInclude(Cxx.generateFilename("sidl.BaseException", 3, 1), true);
        }
        this.d_writer.generateInclude("sidl_String.h", false);
        if (!BabelConfiguration.isSIDLBaseClass(id)) {
            this.d_writer.generateInclude("babel_config.h", false);
            this.d_writer.printlnUnformatted("#ifdef SIDL_DYNAMIC_LIBRARY");
            this.d_writer.printlnUnformatted("#include <stdio.h>");
            this.d_writer.printlnUnformatted("#include <stdlib.h>");
            this.d_writer.generateInclude("sidl_Loader.hh", false);
            this.d_writer.printlnUnformatted("#endif");
        }
        this.d_writer.println();
    }

    private void writeConstructors() {
        SymbolID id = this.d_ext.getSymbolID();
        String extName = IOR.getExternalName(id);
        String fullName = Cxx.getObjectName(id);
        String fullNameWithoutLeadingColons = Cxx.getSymbolNameWithoutLeadingColons(id, "");
        String name = id.getShortName();
        String ior_ptr = "ior_t*";
        if (!this.d_ext.isAbstract()) {
            this.d_writer.writeCommentLine("static constructor");
            this.d_writer.println(fullName);
            this.d_writer.println(fullNameWithoutLeadingColons + "::_create() {");
            this.d_writer.tab();
            this.d_writer.println(Cxx.getObjectName(id) + " self( (*_get_ext()->createObject)(), false );");
            this.d_writer.println("return self;");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println();
        }
        this.d_writer.writeCommentLine("default destructor");
        this.d_writer.println(fullNameWithoutLeadingColons + "::~" + name + " () {");
        this.d_writer.tab();
        this.d_writer.println("if ( d_self != 0 ) {");
        this.d_writer.tab();
        this.d_writer.println("deleteRef();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.writeCommentLine("copy constructor");
        this.d_writer.println(fullNameWithoutLeadingColons + "::" + name + " ( const " + fullName + "& original ) {");
        this.d_writer.tab();
        this.d_writer.println("d_self = " + Cxx.constCast("ior_t*", "original.d_self") + ";");
        this.d_writer.println("d_weak_reference = original.d_weak_reference;");
        this.d_writer.println("if (d_self != 0 ) {");
        this.d_writer.tab();
        this.d_writer.println("addRef();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.writeCommentLine("assignment operator");
        this.d_writer.println(fullName + "&");
        this.d_writer.println(fullNameWithoutLeadingColons + "::operator=( const " + fullName + "& rhs ) {");
        this.d_writer.tab();
        this.d_writer.println("if ( d_self != rhs.d_self ) {");
        this.d_writer.tab();
        this.d_writer.println("if ( d_self != 0 ) {");
        this.d_writer.tab();
        this.d_writer.println("deleteRef();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("d_self = " + Cxx.constCast("ior_t*", "rhs.d_self") + ";");
        this.d_writer.println("d_weak_reference = rhs.d_weak_reference;");
        this.d_writer.println("if ( d_self != 0 ) {");
        this.d_writer.tab();
        this.d_writer.println("addRef();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("return *this;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeCastingOperators() {
        SymbolID id = this.d_ext.getSymbolID();
        String extName = IOR.getExternalName(id);
        String fullName = Cxx.getObjectName(id);
        String fullNameWithoutLeadingColons = Cxx.getSymbolNameWithoutLeadingColons(id, "");
        String name = id.getShortName();
        this.d_writer.writeCommentLine("conversion from ior to C++ class");
        this.d_writer.println(fullNameWithoutLeadingColons + "::" + name + " ( " + fullName + "::ior_t* ior ) ");
        this.d_writer.println("    : d_self( ior ), d_weak_reference(false) {");
        this.d_writer.tab();
        this.d_writer.println("if ( d_self != 0 ) {");
        this.d_writer.tab();
        this.d_writer.println("addRef();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.writeCommentLine("Alternate constructor: does not call addRef()");
        this.d_writer.writeCommentLine("(sets d_weak_reference=isWeak)");
        this.d_writer.writeCommentLine("For internal use by Impls (fixes bug#275)");
        this.d_writer.println(fullNameWithoutLeadingColons + "::" + name + " ( " + fullName + "::ior_t* ior, bool isWeak ) ");
        this.d_writer.println("    : d_self( ior ), d_weak_reference(isWeak) { ");
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.writeCommentLine("conversion from a StubBase");
        this.d_writer.println(fullNameWithoutLeadingColons + "::" + name + " ( const ::sidl::StubBase& base )");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("d_self = " + Cxx.reinterpretCast("ior_t*", "base._cast(\"" + id.getFullName() + "\")") + ";");
        this.d_writer.println("d_weak_reference = false;");
        this.d_writer.println("if (d_self != 0) {");
        this.d_writer.tab();
        this.d_writer.println("addRef();");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.writeCommentLine("protected method that implements casting");
        this.d_writer.println("void* " + fullNameWithoutLeadingColons + "::_cast(const char* type) const");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("void* ptr = 0;");
        this.d_writer.println("if ( d_self != 0 ) {");
        this.d_writer.tab();
        this.d_writer.print("ptr = ");
        if (this.d_ext.isInterface()) {
            this.d_writer.print(Cxx.reinterpretCast("void*", "(*d_self->d_epv->f__cast)(d_self->d_object, type)"));
        } else {
            this.d_writer.print(Cxx.reinterpretCast("void*", "(*d_self->d_epv->f__cast)(d_self, type)"));
        }
        this.d_writer.println(";");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("return ptr;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeDynamicImplStuff() throws CodeGenerationException {
        SymbolID id = this.d_ext.getSymbolID();
        String extName = IOR.getExternalName(id);
        String fullName = Cxx.getObjectName(id);
        String fullNameWithoutLeadingColons = Cxx.getSymbolNameWithoutLeadingColons(id, "");
        this.d_writer.writeCommentLine("Static data type");
        this.d_writer.println("const " + fullName + "::ext_t * " + fullNameWithoutLeadingColons + "::s_ext = 0;");
        this.d_writer.println();
        this.d_writer.writeCommentLine("private static method to get static data type");
        this.d_writer.println("const " + fullName + "::ext_t *");
        this.d_writer.println(fullNameWithoutLeadingColons + "::_get_ext()");
        this.d_writer.println("  throw (::sidl::NullIORException)");
        this.d_writer.println("{");
        this.d_writer.tab();
        this.d_writer.println("if (! s_ext ) {");
        this.d_writer.tab();
        if (BabelConfiguration.isSIDLBaseClass(id)) {
            this.d_writer.println("s_ext = " + IOR.getExternalFunc(id) + "();");
        } else {
            this.d_writer.printlnUnformatted("#ifdef SIDL_STATIC_LIBRARY");
            this.d_writer.println("s_ext = " + IOR.getExternalFunc(id) + "();");
            this.d_writer.printlnUnformatted("#else");
            this.d_writer.println("::sidl::DLL dll = ::sidl::DLL::_create();");
            this.d_writer.println("const ext_t *(*dll_f)(void);");
            this.d_writer.writeCommentLine("check global namespace for symbol first");
            this.d_writer.println("if (dll._not_nil() && dll.loadLibrary(\"main:\", TRUE, FALSE)) {");
            this.d_writer.tab();
            this.d_writer.println("dll_f =");
            this.d_writer.tab();
            this.d_writer.print("(const ext_t *(*)(void)) ");
            this.d_writer.println("dll.lookupSymbol(");
            this.d_writer.tab();
            this.d_writer.println("\"" + IOR.getExternalFunc(id) + "\");");
            this.d_writer.backTab();
            this.d_writer.backTab();
            this.d_writer.println("s_ext = (dll_f ? (*dll_f)() : NULL);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println("if (!s_ext) {");
            this.d_writer.tab();
            this.d_writer.println("dll = ::sidl::Loader::findLibrary(\"" + id.getFullName() + "\",");
            this.d_writer.tab();
            this.d_writer.println("\"ior/impl\", ::sidl::Scope_SCLSCOPE,");
            this.d_writer.println("::sidl::Resolve_SCLRESOLVE);");
            this.d_writer.backTab();
            this.d_writer.println("if (dll._not_nil()) {");
            this.d_writer.tab();
            this.d_writer.println("dll_f =");
            this.d_writer.tab();
            this.d_writer.print("(const ext_t *(*)(void)) ");
            this.d_writer.println("dll.lookupSymbol(");
            this.d_writer.tab();
            this.d_writer.println("\"" + IOR.getExternalFunc(id) + "\");");
            this.d_writer.backTab();
            this.d_writer.backTab();
            this.d_writer.println("s_ext = (dll_f ? (*dll_f)() : NULL);");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.println("if (!s_ext) {");
            this.d_writer.tab();
            this.d_writer.disableLineBreak();
            this.d_writer.println("throw ::sidl::NullIORException( ::std::string (");
            this.d_writer.tab();
            this.d_writer.println("\"cannot find implementation for " + id.getFullName() + "; please set SIDL_DLL_PATH\"");
            this.d_writer.backTab();
            this.d_writer.println("));");
            this.d_writer.enableLineBreak();
            this.d_writer.backTab();
            this.d_writer.println("}");
            this.d_writer.printlnUnformatted("#endif");
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println("return s_ext;");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeUserDefinedMethods() throws CodeGenerationException {
        Method method;
        this.d_writer.beginBoldComment();
        this.d_writer.println("User Defined Methods");
        this.d_writer.endBoldComment();
        Iterator m = null;
        m = this.d_ext.getStaticMethods(true).iterator();
        while (m.hasNext()) {
            method = (Method)m.next();
            this.generateMethodDispatch(method, "user defined static method");
            this.d_writer.println();
        }
        m = this.d_ext.getNonstaticMethods(true).iterator();
        while (m.hasNext()) {
            method = (Method)m.next();
            this.generateMethodDispatch(method, "user defined non-static method.");
            this.d_writer.println();
        }
        this.d_writer.beginBoldComment();
        this.d_writer.println("End User Defined Methods");
        this.d_writer.println("(everything else in this file is specific to");
        this.d_writer.println(" Babel's C++ bindings)");
        this.d_writer.endBoldComment();
    }

    private void generateMethodDispatch(Method m, String altcomment) throws CodeGenerationException {
        if (m == null) {
            return;
        }
        ArrayList vArgs = m.getArgumentList();
        int nargs = vArgs.size();
        StringBuffer func_decl = new StringBuffer(nargs * 32);
        StringBuffer init_stuff = new StringBuffer(nargs * 128);
        StringBuffer pre_ior = new StringBuffer(nargs * 32);
        StringBuffer ior_call = new StringBuffer(nargs * 16);
        StringBuffer post_ior = new StringBuffer(nargs * 128);
        StringBuffer retn_err = new StringBuffer(128);
        String extra_close_paren = "";
        String shortMethodName = m.getShortMethodName();
        String longMethodName = m.getLongMethodName();
        String className = this.d_ext.getSymbolID().getShortName();
        Comment comment = m.getComment();
        this.d_writer.writeComment(comment, altcomment);
        if (shortMethodName.equals(className)) {
            System.out.println("WARNING: gov.llnl.babel.backend.rmi.CxxStubSource: sidl / C++ conflict!");
            System.out.println("         methodName == className is not allowed in C++");
            System.out.println("         (this is restricted to constructors in C++)");
            System.out.println("         changing to " + className + "::f_" + shortMethodName + "()");
            shortMethodName = "f_" + shortMethodName;
        }
        Type return_type = m.getReturnType();
        SymbolID id = return_type.getSymbolID();
        func_decl.append(Cxx.getReturnString(return_type));
        if (return_type.getType() != 0) {
            init_stuff.append(Cxx.getCxxString(return_type));
            init_stuff.append(" _result;\n");
        }
        func_decl.append("\n");
        switch (return_type.getDetailedType()) {
            case 0: {
                break;
            }
            case 9: {
                ior_call.append("_result = ");
                retn_err.append("_result = 0;\n");
                break;
            }
            case 1: {
                pre_ior.append("sidl_bool _local_result;\n");
                ior_call.append("_local_result = ");
                post_ior.append("_result = _local_result;\n");
                retn_err.append("_result = false;\n");
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                ior_call.append("_result = ");
                retn_err.append("_result = 0;\n");
                break;
            }
            case 11: {
                pre_ior.append(IOR.getEnumName(return_type.getSymbolID()) + " _local_result;\n");
                ior_call.append("_local_result = ");
                post_ior.append("_result = (" + Cxx.getEnumName(return_type.getSymbolID()) + ")_local_result;\n");
                retn_err.append("//_result = 0;\n");
                break;
            }
            case 5: {
                pre_ior.append("struct sidl_fcomplex _local_result;\n");
                ior_call.append("_local_result = ");
                post_ior.append("_result = ::std::complex<float>(_local_result.real,_local_result.imaginary);\n");
                retn_err.append("_result = 0;\n");
                break;
            }
            case 3: {
                pre_ior.append("struct sidl_dcomplex _local_result;\n");
                ior_call.append("_local_result = ");
                post_ior.append("_result = ::std::complex<double>(_local_result.real, _local_result.imaginary);\n");
                retn_err.append("_result = 0;\n");
                break;
            }
            case 10: {
                pre_ior.append("char * _local_result;\n");
                ior_call.append("_local_result = ");
                post_ior.append("if (_local_result) {\n  _result = _local_result;\n  free( _local_result );\n}\n");
                retn_err.append("_result = \"\";\n");
                break;
            }
            case 15: {
                throw new CodeGenerationException("Type.SYMBOL should have been resolved to\nType.ENUM, Type.CLASS, or Type.INTERFACE");
            }
            case 12: 
            case 13: {
                ior_call.append("_result = " + Cxx.getReturnString(return_type) + "( ");
                extra_close_paren = ", false)";
                retn_err.append("_result = " + Cxx.getReturnString(return_type) + "();\n");
                break;
            }
            case 16: {
                String iorArrayName = return_type.getArrayType().isSymbol() ? IOR.getArrayName(return_type.getArrayType().getSymbolID()) : "sidl_" + return_type.getArrayType().getTypeString() + "__array";
                pre_ior.append(iorArrayName + "* _local_result;\n");
                ior_call.append("_local_result = ");
                post_ior.append("_result._set_ior(_local_result);\n");
                break;
            }
            default: {
                throw new CodeGenerationException("Unexpected User Defined Return Type" + return_type.getType());
            }
        }
        func_decl.append(Cxx.getMethodStubName(this.d_ext.getSymbolID(), shortMethodName));
        func_decl.append("( ");
        if (m.isStatic()) {
            ior_call.append("( _get_sepv()->" + IOR.getVectorEntry(longMethodName) + ")( ");
        } else {
            ior_call.append("(*(d_self->d_epv->f_" + m.getLongMethodName() + "))(" + this.d_self);
            if (nargs > 0) {
                ior_call.append(", ");
            }
        }
        Iterator it = vArgs.iterator();
        while (it.hasNext()) {
            Argument arg = (Argument)it.next();
            Type type = arg.getType();
            int typeInt = type.getDetailedType();
            String argName = arg.getFormalName();
            String mode = "/* " + Cxx.argModeToString(arg) + " */ ";
            int modeInt = arg.getMode();
            func_decl.append(Cxx.getArgumentString(arg));
            if (it.hasNext()) {
                func_decl.append(", ");
            }
            ior_call.append(mode);
            switch (typeInt) {
                case 9: {
                    switch (modeInt) {
                        case 0: {
                            ior_call.append(argName);
                            break;
                        }
                        case 2: {
                            ior_call.append("&" + argName);
                            break;
                        }
                        case 1: {
                            ior_call.append("&" + argName);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (modeInt) {
                        case 0: {
                            pre_ior.append("sidl_bool _local_" + argName + " = " + argName + ";\n");
                            ior_call.append("_local_" + argName);
                            break;
                        }
                        case 2: {
                            pre_ior.append("sidl_bool _local_" + argName + ";\n");
                            ior_call.append("&_local_" + argName);
                            post_ior.append(argName + " = _local_" + argName + ";\n");
                            break;
                        }
                        case 1: {
                            pre_ior.append("sidl_bool _local_" + argName + " = " + argName + ";\n");
                            ior_call.append("&_local_" + argName);
                            post_ior.append(argName + " = _local_" + argName + ";\n");
                        }
                    }
                    break;
                }
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 8: {
                    switch (modeInt) {
                        case 0: {
                            ior_call.append(argName);
                            break;
                        }
                        case 2: {
                            ior_call.append("&" + argName);
                            break;
                        }
                        case 1: {
                            ior_call.append("&" + argName);
                        }
                    }
                    break;
                }
                case 11: {
                    String ior_name = IOR.getEnumName(type.getSymbolID());
                    switch (modeInt) {
                        case 0: {
                            ior_call.append("(" + ior_name + ")" + argName);
                            break;
                        }
                        case 2: {
                            ior_call.append("(" + ior_name + "*)&" + argName);
                            break;
                        }
                        case 1: {
                            ior_call.append("(" + ior_name + "*)&" + argName);
                        }
                    }
                    break;
                }
                case 5: {
                    switch (modeInt) {
                        case 0: {
                            pre_ior.append("struct sidl_fcomplex _local_" + argName + " = {");
                            pre_ior.append(argName + ".real(), ");
                            pre_ior.append(argName + ".imag() } ; \n");
                            ior_call.append("_local_" + argName);
                            break;
                        }
                        case 2: {
                            pre_ior.append("struct sidl_fcomplex _local_" + argName + "; \n");
                            ior_call.append("&_local_" + argName);
                            post_ior.append(argName + " = ::std::complex<float>(_local_" + argName + ".real, _local_" + argName + ".imaginary);\n");
                            break;
                        }
                        case 1: {
                            pre_ior.append("struct sidl_fcomplex _local_" + argName + " = {");
                            pre_ior.append(argName + ".real(), ");
                            pre_ior.append(argName + ".imag() } ; \n");
                            ior_call.append("&_local_" + argName);
                            post_ior.append(argName + " = ::std::complex<float>(_local_" + argName + ".real, _local_" + argName + ".imaginary);\n");
                        }
                    }
                    break;
                }
                case 3: {
                    switch (modeInt) {
                        case 0: {
                            pre_ior.append("struct sidl_dcomplex _local_" + argName + " = {");
                            pre_ior.append(argName + ".real(), ");
                            pre_ior.append(argName + ".imag() } ; \n");
                            ior_call.append("_local_" + argName);
                            break;
                        }
                        case 2: {
                            pre_ior.append("struct sidl_dcomplex _local_" + argName + "; \n");
                            ior_call.append("&_local_" + argName);
                            post_ior.append(argName + " = ::std::complex<double>(_local_" + argName + ".real, _local_" + argName + ".imaginary);\n");
                            break;
                        }
                        case 1: {
                            pre_ior.append("struct sidl_dcomplex _local_" + argName + " = {");
                            pre_ior.append(argName + ".real(), ");
                            pre_ior.append(argName + ".imag() } ; \n");
                            ior_call.append("&_local_" + argName);
                            post_ior.append(argName + " = ::std::complex<double>(_local_" + argName + ".real, _local_" + argName + ".imaginary);\n");
                        }
                    }
                    break;
                }
                case 10: {
                    switch (modeInt) {
                        case 0: {
                            ior_call.append(argName + ".c_str()");
                            break;
                        }
                        case 2: {
                            pre_ior.append("char * _local_" + argName + " = 0;\n");
                            ior_call.append("&_local_" + argName);
                            post_ior.append("if (_local_" + argName + ") {\n");
                            post_ior.append("  " + argName + " = _local_" + argName + ";\n");
                            post_ior.append("  sidl_String_free( _local_" + argName + ");\n");
                            post_ior.append("}\n");
                            post_ior.append("else {\n");
                            post_ior.append("  " + argName + " = \"\";\n");
                            post_ior.append("}\n");
                            break;
                        }
                        case 1: {
                            pre_ior.append("char * _local_" + argName + " = sidl_String_strdup( " + argName + ".c_str() );\n");
                            ior_call.append("&_local_" + argName);
                            post_ior.append("if (_local_" + argName + ") {\n");
                            post_ior.append("  " + argName + " = _local_" + argName + ";\n");
                            post_ior.append("  sidl_String_free( _local_" + argName + ");\n");
                            post_ior.append("}\n");
                            post_ior.append("else {\n");
                            post_ior.append("  " + argName + " = \"\";\n");
                            post_ior.append("}\n");
                        }
                    }
                    break;
                }
                case 15: {
                    throw new CodeGenerationException("Type.SYMBOL should have been resolved to\nType.ENUM, Type.CLASS, or Type.INTERFACE");
                }
                case 12: 
                case 13: {
                    id = type.getSymbolID();
                    switch (modeInt) {
                        case 0: {
                            ior_call.append(argName + "._get_ior()");
                            break;
                        }
                        case 2: {
                            pre_ior.append(IOR.getObjectName(id) + "* _local_" + argName + ";\n");
                            ior_call.append("&_local_" + argName);
                            post_ior.append("if ( " + argName + "._not_nil() ) {\n");
                            post_ior.append("  " + argName + ".deleteRef();\n");
                            post_ior.append("}\n");
                            post_ior.append(argName + "._set_ior( _local_" + argName + ");\n");
                            break;
                        }
                        case 1: {
                            pre_ior.append(IOR.getObjectName(id) + "* _local_" + argName + " = " + argName + "._get_ior();\n");
                            pre_ior.append(argName + "._set_ior( 0 );\n");
                            ior_call.append("&_local_" + argName);
                            post_ior.append(argName + "._set_ior( _local_" + argName + ");\n");
                        }
                    }
                    break;
                }
                case 16: {
                    String iorArrayName = type.getArrayType().isSymbol() ? IOR.getArrayName(type.getArrayType().getSymbolID()) : "sidl_" + type.getArrayType().getTypeString() + "__array";
                    switch (modeInt) {
                        case 0: {
                            ior_call.append(argName + "._get_ior()");
                            break;
                        }
                        case 2: {
                            pre_ior.append(iorArrayName + " *_local_" + argName + ";\n");
                            ior_call.append("&_local_" + argName);
                            post_ior.append(argName + "._set_ior(_local_" + argName + ");\n");
                            break;
                        }
                        case 1: {
                            pre_ior.append("if (" + argName + ") {\n");
                            pre_ior.append("  " + argName + ".addRef();\n");
                            pre_ior.append("}\n");
                            pre_ior.append(iorArrayName + " *_local_" + argName + " = " + argName + "._get_ior();\n");
                            ior_call.append("&_local_" + argName);
                            post_ior.append(argName + "._set_ior(_local_" + argName + ");\n");
                        }
                    }
                    break;
                }
                default: {
                    throw new CodeGenerationException("Unexpected User Defined Return Type" + return_type.getType());
                }
            }
            if (!it.hasNext()) continue;
            ior_call.append(", ");
        }
        if (m.getThrows().size() > 0) {
            pre_ior.append("sidl_BaseInterface__object * _exception = 0;\n");
            if (nargs > 0 || !m.isStatic()) {
                ior_call.append(", ");
            }
            ior_call.append("&_exception");
        }
        func_decl.append(" )\n");
        ior_call.append(" )" + extra_close_paren + ";\n");
        this.d_writer.println(func_decl.toString().trim());
        Cxx.generateThrowsList(this.d_writer, m, true);
        this.d_writer.println();
        this.d_writer.println("{");
        this.d_writer.tab();
        if (!m.isStatic()) {
            this.d_writer.println("if ( d_self == 0 ) {");
            this.d_writer.tab();
            this.d_writer.println("throw ::sidl::NullIORException( ::std::string (");
            this.d_writer.tab();
            this.d_writer.disableLineBreak();
            this.d_writer.println("\"Null IOR Pointer in \\\"" + Cxx.getMethodStubName(this.d_ext.getSymbolID(), shortMethodName) + "()\\\"\"");
            this.d_writer.enableLineBreak();
            this.d_writer.backTab();
            this.d_writer.println("));");
            this.d_writer.backTab();
            this.d_writer.println("}");
        }
        this.d_writer.println(init_stuff.toString().trim());
        if (!m.isStatic() && (shortMethodName.equals("addRef") || shortMethodName.equals("deleteRef"))) {
            this.d_writer.println("if ( !d_weak_reference ) {");
            this.d_writer.tab();
        }
        this.d_writer.writeCommentLine("pack args to dispatch to ior");
        this.d_writer.println(pre_ior.toString().trim());
        this.d_writer.writeCommentLine("dispatch to ior");
        this.d_writer.println(ior_call.toString().trim());
        this.d_writer.writeCommentLine("unpack results and cleanup");
        if (m.getThrows().size() > 0) {
            this.d_writer.println("if (_exception != 0 ) {");
            this.d_writer.tab();
            this.d_writer.println("void * _p = 0;");
            Object[] exceptions = m.getThrows().toArray();
            Arrays.sort(exceptions, new LevelComparator(SymbolTable.getInstance()));
            for (int i = 0; i < exceptions.length; ++i) {
                SymbolID exid = (SymbolID)exceptions[i];
                this.d_writer.println("if ( (_p=(*(_exception->d_epv->f__cast))(_exception, \"" + exid.getFullName() + "\")) != 0 ) {");
                this.d_writer.tab();
                this.d_writer.println(IOR.getObjectName(exid) + " * _realtype = " + Cxx.reinterpretCast(IOR.getObjectName(exid) + "*", "_p") + ";");
                this.d_writer.writeCommentLine("Note: alternate constructor does not increment refcount.");
                this.d_writer.println("throw " + Cxx.getObjectName(exid) + "( _realtype, false );");
                this.d_writer.backTab();
                this.d_writer.println("}");
            }
            this.d_writer.backTab();
            this.d_writer.println("}");
        }
        this.d_writer.println(post_ior.toString().trim());
        if (!m.isStatic() && (shortMethodName.equals("addRef") || shortMethodName.equals("deleteRef"))) {
            if (shortMethodName.equals("deleteRef")) {
                this.d_writer.println("d_self = 0;");
            }
            this.d_writer.backTab();
            this.d_writer.println("}");
        }
        if (return_type.getType() != 0) {
            this.d_writer.println("return _result;");
        }
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }
}

