/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.rmi2;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeGenerator;
import gov.llnl.babel.backend.rmi2.CxxSkelSource;
import gov.llnl.babel.backend.rmi2.CxxStubHeader;
import gov.llnl.babel.backend.rmi2.CxxStubSource;
import gov.llnl.babel.backend.rmi2.RmiStubHeader;
import gov.llnl.babel.backend.rmi2.RmiStubSource;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class GenerateRmiClient
implements CodeGenerator {
    public void generateCode(Set symbols) throws CodeGenerationException {
        SymbolTable table = SymbolTable.getInstance();
        Iterator s = symbols.iterator();
        while (s.hasNext()) {
            SymbolID id = (SymbolID)s.next();
            Symbol symbol = table.lookupSymbol(id);
            if (symbol == null) continue;
            switch (symbol.getSymbolType()) {
                case 12: {
                    this.generateExtendable((Extendable)symbol);
                    break;
                }
            }
        }
    }

    private void generateExtendable(Extendable extendable) throws CodeGenerationException {
        CxxStubHeader stubH = new CxxStubHeader(extendable);
        CxxStubSource stubS = new CxxStubSource(extendable);
        stubH.generateCode();
        stubS.generateCode();
        CxxSkelSource skel = new CxxSkelSource(extendable);
        skel.generateCode();
        RmiStubHeader rStubH = new RmiStubHeader(extendable);
        RmiStubSource rStubS = new RmiStubSource(extendable);
        rStubH.generateCode();
        rStubS.generateCode();
    }

    public String getType() {
        return "stub";
    }

    public boolean getUserSymbolsOnly() {
        return true;
    }

    public Set getLanguages() {
        TreeSet<String> result = new TreeSet<String>();
        result.add("rmi");
        return result;
    }
}

