/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.rmi2;

import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.CodeSplicer;
import gov.llnl.babel.backend.FileManager;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.rmi2.Cxx;
import gov.llnl.babel.backend.writers.LanguageWriterForCxx;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.SymbolID;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class RmiStubSource {
    private Extendable d_ext = null;
    private LanguageWriterForCxx d_writer = null;
    private CodeSplicer d_splicer = null;

    public RmiStubSource(Extendable ext) {
        this.d_ext = ext;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void generateCode() throws CodeGenerationException {
        SymbolID id = this.d_ext.getSymbolID();
        int type = this.d_ext.getSymbolType();
        String filename = Cxx.generateFilename(id, 1, 2);
        try {
            block4: {
                try {
                    this.d_splicer = FileManager.getInstance().getCodeSplicer(id, type, filename);
                    this.d_writer = Cxx.createSource(this.d_ext, 1, "IMPLSRCS");
                    this.d_splicer.setLineRedirector(this.d_writer);
                    this.writeIncludes();
                    this.writeCtorDtor();
                    this.writeSIDLDefinedMethods();
                    this.d_splicer.splice(this.d_ext.getSymbolID().getFullName() + "._misc", this.d_writer, "miscellaneous code");
                    this.d_writer.println();
                    if (!this.d_splicer.hasUnusedSymbolEdits()) break block4;
                    this.d_writer.printlnUnformatted("#error File has unused splicer blocks.");
                    this.d_writer.beginBlockComment(true);
                    this.d_writer.println("================= BEGIN UNREFERENCED METHOD(S) ================");
                    this.d_writer.println("The following code segment(s) belong to unreferenced method(s).");
                    this.d_writer.println("This can result from a method rename/removal in the sidl file.");
                    this.d_writer.println("Move or remove the code in order to compile cleanly.");
                    this.d_writer.endBlockComment(true);
                    this.d_splicer.outputUnusedSymbolEdits(this.d_writer.getPrintWriter());
                    this.d_writer.writeCommentLine("================== END UNREFERENCED METHOD(S) =================");
                }
                catch (IOException ex) {
                    throw new CodeGenerationException("IOException : " + ex.getMessage());
                }
            }
            Object var6_4 = null;
            if (this.d_writer == null) return;
            this.d_writer.close();
            this.d_writer = null;
            return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (this.d_writer == null) throw throwable;
            this.d_writer.close();
            this.d_writer = null;
            throw throwable;
        }
    }

    private void writeIncludes() {
        this.d_writer.generateInclude(Cxx.generateFilename(this.d_ext.getSymbolID(), 1, 1), false);
        this.d_writer.println();
        this.writeRmiIncludes();
        this.d_writer.println();
        this.d_splicer.splice(this.d_ext.getSymbolID().getFullName() + "._includes", this.d_writer, "additional includes or code");
        this.d_writer.println();
    }

    private void writeCtorDtor() {
        this.d_writer.writeCommentLine("user defined constructor");
        this.d_writer.print("void " + Utilities.replace(this.d_ext.getSymbolID().getFullName(), ".", "::"));
        this.d_writer.println("_impl::_ctor() {");
        this.d_writer.tab();
        this.d_splicer.splice(this.d_ext.getSymbolID().getFullName() + "._ctor", this.d_writer, "construction details");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
        this.d_writer.writeCommentLine("user defined destructor");
        this.d_writer.print("void " + Utilities.replace(this.d_ext.getSymbolID().getFullName(), ".", "::"));
        this.d_writer.println("_impl::_dtor() {");
        this.d_writer.tab();
        this.d_splicer.splice(this.d_ext.getSymbolID().getFullName() + "._dtor", this.d_writer, "destruction details");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeSIDLDefinedMethods() throws CodeGenerationException {
        List static_methods = (List)this.d_ext.getStaticMethods(false);
        if (static_methods.size() > 0) {
            this.d_writer.writeCommentLine("user defined static methods:");
            Iterator m = static_methods.iterator();
            while (m.hasNext()) {
                Method method = (Method)m.next();
                this.generateMethod(method);
            }
        } else {
            this.d_writer.writeCommentLine("user defined static methods: (none)");
        }
        this.d_writer.println();
        List nonstatic_methods = (List)this.d_ext.getNonstaticMethods(false);
        if (nonstatic_methods.size() > 0) {
            this.d_writer.writeCommentLine("user defined non-static methods:");
            Iterator m = nonstatic_methods.iterator();
            while (m.hasNext()) {
                Method method = (Method)m.next();
                if (method.isAbstract()) continue;
                this.generateMethod(method);
            }
        } else {
            this.d_writer.writeCommentLine("user defined non-static methods: (none)");
        }
        this.d_writer.println();
    }

    private void generateMethod(Method method) throws CodeGenerationException {
        if (method == null) {
            return;
        }
        this.d_writer.writeComment(method, true);
        this.d_writer.println(Cxx.getReturnString(method.getReturnType()));
        this.d_writer.print(Utilities.replace(this.d_ext.getSymbolID().getFullName(), ".", "::"));
        this.d_writer.print("_impl::");
        this.d_writer.print(method.getShortMethodName());
        if (method.getArgumentList().size() > 0) {
            this.d_writer.println(" (");
            this.d_writer.tab();
            Cxx.generateArgumentList(this.d_writer, method);
            this.d_writer.println(" ) ");
            this.d_writer.backTab();
            Cxx.generateThrowsList(this.d_writer, method, false);
            this.d_writer.println("{");
        } else {
            this.d_writer.println(" () ");
            Cxx.generateThrowsList(this.d_writer, method, false);
            this.d_writer.println();
            this.d_writer.println("{");
        }
        this.d_writer.tab();
        this.generateRmiStub();
        this.d_splicer.splice(this.d_ext.getSymbolID().getFullName() + "." + method.getLongMethodName(), this.d_writer, "implementation");
        this.d_writer.backTab();
        this.d_writer.println("}");
        this.d_writer.println();
    }

    private void writeRmiIncludes() {
        this.d_writer.println("#include <msl/debug.h>");
        this.d_writer.println("#include <msl/Format.h>");
        this.d_writer.println("#include <msl/Time.h>");
        this.d_writer.println("#include <msl/Condvar.h>");
        this.d_writer.println("#include <msl/Mutex.h>");
        this.d_writer.println("#include <msl/Opt.h>");
        this.d_writer.println("#include <msl/Def.h>");
        this.d_writer.println("#include <wsit/ArgList.h>");
        this.d_writer.println("#include <wsit/PrimitiveArg_tmpl.h>");
        this.d_writer.println("#include <proteus/Core.h>");
        this.d_writer.println("#include <wsit/Invocation.h>");
        this.d_writer.println("#include <wsit/InvocationHandler.h>");
        this.d_writer.println("#include <proteus/Node.h>");
        this.d_writer.println("#include <proteus/NodeId.h>");
        this.d_writer.println("#include <proteus/RAddress.h>");
        this.d_writer.println("#include <proteus/RNodepoint.h>");
        this.d_writer.println("#include <proteus/RRepertoireMap.h>");
        this.d_writer.println("#include <proteus/RScheme.h>");
        this.d_writer.println("#include <proteus/RSecurityContext.h>");
        this.d_writer.println("#include <proteus/SAddress.h>");
        this.d_writer.println("#include <wsit/Semiinvocation.h>");
        this.d_writer.println("#include <proteus/SNodepoint.h>");
        this.d_writer.println("#include <proteus/SRepertoireMap.h>");
        this.d_writer.println("#include <proteus/SScheme.h>");
        this.d_writer.println("#include <proteus/SSecurityContext.h>");
        this.d_writer.println("#include <proteus/Selector.h>");
        this.d_writer.println("#include <wsit/StringArg.h>");
        this.d_writer.println("#include <wsit/ValueResult.h>");
        this.d_writer.println("#include <wsit/VobjectArg.h>");
        this.d_writer.println("#include <wsit/types.h>");
        this.d_writer.println("#include <BabelVobject.h>");
        this.d_writer.println("using namespace msl;");
        this.d_writer.println("using namespace proteus;");
        this.d_writer.println("using namespace wsit;");
        this.d_writer.println("extern const char *DestAddr; ");
        this.d_writer.println("namespace {");
        this.d_writer.println("  const char *xyzzy_modname = \"helloWorld-client-impl\";");
        this.d_writer.println("  const char *xyzzy_funcname = \"\";");
        this.d_writer.println("}");
    }

    private void generateRmiStub() {
        this.d_writer.println();
        this.d_writer.println("Def<Node> n; ");
        this.d_writer.println();
        this.d_writer.println("assert(DestAddr != NULL); ");
        this.d_writer.println("Sptr<SScheme> ss(NewTag, Sptr<SNodepoint>(NewTag, DestAddr)); ");
        this.d_writer.println();
        this.d_writer.println("PrimitiveArg_tmpl<int>::def a1(QName(\"{}<NONE>\"), 1); ");
        this.d_writer.println("PrimitiveArg_tmpl<double>::def a2(QName(\"{}<NONE>\"), 3.14159); ");
        this.d_writer.println();
        this.d_writer.println("Def<BabelVobject> bvo(obj); ");
        this.d_writer.println("VobjectArg_def a3(QName(\"{}<NONE>\"), bvo); ");
        this.d_writer.println();
        this.d_writer.println("PrimitiveArg_tmpl<int64_t>::def a4(QName(\"{}<NONE>\"), 9000000000LL); ");
        this.d_writer.println("PrimitiveArg_tmpl<float>::def a5(QName(\"{}<NONE>\"), 3.12); ");
        this.d_writer.println("PrimitiveArg_tmpl<char>::def a6(QName(\"{}<NONE>\"), 'c'); ");
        this.d_writer.println("Def<ArgList> al(a1, a2, a3, a4, a5, a6); // argument list ");
        this.d_writer.println("Semiinvocation si(QName(\"{}getMsg\"), al);");
        this.d_writer.println("Invocation inv(QName(\"{}Interface\"), si); ");
        this.d_writer.println();
        this.d_writer.writeCommentLine("Invoke.");
        this.d_writer.println("Result_sptr res(n->invoke(ss, inv)); ");
        this.d_writer.println();
        this.d_writer.writeCommentLine("Assume it's not an exception for now.");
        this.d_writer.println("ValueResult_sptr vr(sptr_dynamic_cast<const ValueResult>(res)); ");
        this.d_writer.println();
        this.d_writer.println("msl_dpf(\"Result: \" << sptr_dynamic_cast<const StringArg >(( *vr->argList())[0])->value()); ");
        this.d_writer.println();
        this.d_writer.println(" return sptr_dynamic_cast<const StringArg >((*vr->argList())[0])->value();\n");
    }
}

