/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.symbols.Argument;
import gov.llnl.babel.symbols.AssertionException;
import gov.llnl.babel.symbols.AssertionExpression;
import gov.llnl.babel.symbols.BinaryExpression;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.IdentifierLiteral;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;
import java.util.ListIterator;

public class MethodCall
extends AssertionExpression {
    private String d_name = null;
    private boolean d_is_static = true;
    private boolean d_throws_exceptions = false;
    private ArrayList d_arguments = null;
    private int d_reserved_method = 0;
    private int d_reserved_relation = 0;
    private String d_reserved_relation_rel = null;
    private Type d_reserved_array_type = null;
    public static final String ARRAY_BOOLEAN_RESULT_VAR = "bres";
    public static final String ARRAY_COUNT_VAR = "cnt";
    public static final String ARRAY_DOUBLE_RESULT_VAR = "dres";
    public static final String ARRAY_INTEGER_RESULT_VAR = "ires";
    public static final String ARRAY_ITER_VAR = "i";
    public static final String ARRAY_SIZE_VAR = "max";
    public static final char[] MACRO_RETURN_TYPE = new char[]{'0', '1', '2'};
    public static final int MACRO_RETURNS_BOOLEAN_IND = 0;
    public static final int MACRO_RETURNS_DOUBLE_IND = 1;
    public static final int MACRO_RETURNS_INTEGER_IND = 2;
    public static final int MAX_VALID_MACRO_RETURNS = 3;
    public static final int METHOD_ANY_ARRAY = -3;
    public static final int METHOD_NUMERIC_ARRAY = -2;
    public static final int METHOD_ANY_BUILTIN = -1;
    public static final int METHOD_NOT_RESERVED = 0;
    public static final int METHOD_ARRAY_ALL = 1;
    public static final int METHOD_ARRAY_ANY = 2;
    public static final int METHOD_ARRAY_COUNT = 3;
    public static final int METHOD_ARRAY_DIMEN = 4;
    public static final int METHOD_ARRAY_DOWN = 5;
    public static final int METHOD_ARRAY_IRANGE = 6;
    public static final int METHOD_ARRAY_LOWER = 7;
    public static final int METHOD_ARRAY_MAX = 8;
    public static final int METHOD_ARRAY_MIN = 9;
    public static final int METHOD_ARRAY_NEAR_EQUAL = 10;
    public static final int METHOD_ARRAY_NONE = 11;
    public static final int METHOD_ARRAY_RANGE = 12;
    public static final int METHOD_ARRAY_SIZE = 13;
    public static final int METHOD_ARRAY_STRIDE = 14;
    public static final int METHOD_ARRAY_SUM = 15;
    public static final int METHOD_ARRAY_UP = 16;
    public static final int METHOD_ARRAY_UPPER = 17;
    public static final int METHOD_IRANGE = 18;
    public static final int METHOD_NEAR_EQUAL = 19;
    public static final int METHOD_RANGE = 20;
    public static final int MINIMUM_METHOD = 1;
    public static final int MAXIMUM_ARRAY_METHOD = 17;
    public static final int MAXIMUM_METHOD = 20;
    private static final String[] s_reserved_name = new String[]{"", "all", "any", "count", "dimen", "down", "irange", "lower", "max", "min", "nearequal", "none", "range", "size", "stride", "sum", "up", "upper", "irange", "nearequal", "range"};
    private static final String[] s_builtin_macro = new String[]{"", "SIDL_ARRAY_ALL", "SIDL_ARRAY_ANY", "SIDL_ARRAY_COUNT", "SIDL_ARRAY_DIMEN", "SIDL_ARRAY_DOWN", "SIDL_ARRAY_IRANGE", "SIDL_ARRAY_LOWER", "SIDL_ARRAY_MAX", "SIDL_ARRAY_MIN", "SIDL_ARRAY_NEAR_EQUAL", "SIDL_ARRAY_NONE", "SIDL_ARRAY_RANGE", "SIDL_ARRAY_SIZE", "SIDL_ARRAY_STRIDE", "SIDL_ARRAY_SUM", "SIDL_ARRAY_UP", "SIDL_ARRAY_UPPER", "SIDL_IRANGE", "SIDL_NEAR_EQUAL", "SIDL_RANGE"};
    private static final int MAX_ARRAY_ARGS = 2;
    public static final int METHOD_RELATION_NONE = 0;
    public static final int METHOD_RELATION_LEFT = 1;
    public static final int METHOD_RELATION_RIGHT = 2;
    public static final int METHOD_RELATION_BOTH = 3;
    private static final String[] s_builtin_relation = new String[]{"", "_LR", "_RR", "_BOTH"};
    private static final String IDENTIFIER_LITERAL = "gov.llnl.babel.symbols.IdentifierLiteral";
    private static final String BINARY_EXPRESSION = "gov.llnl.babel.symbols.BinaryExpression";
    public static final int RELATION_OP_EQUAL = 0;
    public static final int RELATION_OP_NOT_EQUAL = 1;
    public static final int RELATION_OP_LESS_THAN = 2;
    public static final int RELATION_OP_LESS_EQUAL = 3;
    public static final int RELATION_OP_GREATER_THAN = 4;
    public static final int RELATION_OP_GREATER_EQUAL = 5;

    public MethodCall(String name) throws AssertionException {
        super(false);
        if (name == null || name.equals("")) {
            throw new AssertionException("Cannot instantiate a method call without the name of the method to be called.");
        }
        for (int i = 1; i <= 20 && this.d_reserved_method == 0; ++i) {
            if (!name.toLowerCase().equals(s_reserved_name[i])) continue;
            this.d_reserved_method = i;
        }
        this.d_name = name;
        this.d_arguments = new ArrayList();
    }

    public String getMethodName() {
        return this.d_name;
    }

    public boolean isStatic() {
        return this.d_is_static;
    }

    public boolean throwsExceptions() {
        return this.d_throws_exceptions;
    }

    public void addArgument(AssertionExpression arg) {
        this.d_arguments.add(arg);
    }

    public ArrayList getArguments() {
        return this.d_arguments;
    }

    public boolean isArrayMethod() {
        boolean is = false;
        if (1 <= this.d_reserved_method && this.d_reserved_method <= 17) {
            is = true;
        }
        return is;
    }

    public boolean isArrayMacroMethod() {
        boolean is = false;
        if (this.d_reserved_method == 4 || this.d_reserved_method == 7 || this.d_reserved_method == 13 || this.d_reserved_method == 14 || this.d_reserved_method == 17) {
            is = true;
        }
        return is;
    }

    public boolean isBuiltinNumericArrayMethod() {
        boolean is = false;
        if (this.isArrayMethod() && !this.isArrayMacroMethod()) {
            is = true;
        }
        return is;
    }

    public boolean isBuiltinRelationMethod() {
        boolean is = false;
        if (this.d_reserved_method == 1 || this.d_reserved_method == 2 || this.d_reserved_method == 3 || this.d_reserved_method == 11) {
            is = true;
        }
        return is;
    }

    public boolean hasPure() {
        return false;
    }

    public boolean hasResult() {
        return false;
    }

    public boolean hasMethodCall() {
        return true;
    }

    public boolean hasReservedMethod(int type) {
        boolean hasIt = false;
        switch (type) {
            case -1: {
                if (1 > type || type > 20) break;
                hasIt = true;
                break;
            }
            case -2: {
                if (!this.isBuiltinNumericArrayMethod()) break;
                hasIt = true;
                break;
            }
            case -3: {
                if (!this.isArrayMethod()) break;
                hasIt = true;
                break;
            }
            default: {
                if (1 > type || type > 20 || type != this.d_reserved_method) break;
                hasIt = true;
            }
        }
        return hasIt;
    }

    public boolean hasUnreservedMethod(boolean any) {
        boolean hasIt = false;
        if (this.d_reserved_method == 0 && (any || this.d_throws_exceptions)) {
            hasIt = true;
        }
        return hasIt;
    }

    public boolean requiresExtendableContext() {
        return true;
    }

    public boolean requiresMethodContext() {
        boolean rqr = false;
        ArrayList args = this.d_arguments;
        if (args != null && !args.isEmpty()) {
            ListIterator iter = args.listIterator();
            while (iter.hasNext()) {
                AssertionExpression arg = (AssertionExpression)iter.next();
                if (!arg.requiresMethodContext()) continue;
                rqr = true;
            }
        }
        return rqr;
    }

    private ArrayList getArgumentReturnTypes() throws AssertionException {
        ArrayList<Integer> list = null;
        ArrayList args = this.d_arguments;
        if (args != null && !args.isEmpty()) {
            list = new ArrayList<Integer>();
            ListIterator iter = args.listIterator();
            while (iter.hasNext()) {
                AssertionExpression arg = (AssertionExpression)iter.next();
                int type = arg.getReturnTypeValue();
                if (type != -1) {
                    list.add(new Integer(type));
                    continue;
                }
                throw new AssertionException("Unable to obtain the return type for argument " + arg + " when attempting to build a list of " + "argument return types for method " + this.d_name + ".");
            }
        }
        return list;
    }

    public ArrayList getArgumentReturnTypes(Method meth) {
        ArrayList args;
        ArrayList<Integer> list = null;
        if (meth != null && (args = meth.getArgumentList()) != null && !args.isEmpty()) {
            list = new ArrayList<Integer>();
            ListIterator iter = args.listIterator();
            while (iter.hasNext()) {
                Argument arg = (Argument)iter.next();
                int type = arg.getType().getBasicType();
                list.add(new Integer(type));
            }
        }
        return list;
    }

    public boolean hasCompatibleArgumentTypes(ArrayList list) throws AssertionException {
        int listsize;
        boolean compatible = false;
        ArrayList myargs = this.getArgumentReturnTypes();
        int mysize = myargs == null ? 0 : myargs.size();
        int n = listsize = list == null ? 0 : list.size();
        if (mysize != listsize) {
            throw new AssertionException("Semantic Validation Failure: Number of  arguments in call to " + this.d_name + " is " + mysize + " while definition's size is " + listsize + ".");
        }
        if (mysize > 0) {
            int a = 0;
            ListIterator iter = list.listIterator();
            while (iter.hasNext()) {
                int itemvalue = (Integer)iter.next();
                int argvalue = (Integer)myargs.get(a);
                if (argvalue == itemvalue) {
                    compatible = true;
                } else if (argvalue == 8 && itemvalue == 7 || argvalue == 6 && itemvalue == 7 || argvalue == 4 && itemvalue == 7 || argvalue == 7 && itemvalue == 8 || argvalue == 6 && itemvalue == 8 || argvalue == 4 && itemvalue == 8) {
                    compatible = true;
                } else if (argvalue == 4 && itemvalue == 6 || argvalue == 6 && itemvalue == 4) {
                    compatible = true;
                } else if (argvalue == 3 && itemvalue == 5 || argvalue == 5 && itemvalue == 3) {
                    compatible = true;
                } else {
                    throw new AssertionException("Semantic Validation Failure: Incompatible argument type " + Type.getTypeName(argvalue) + " in call to " + this.d_name + ", expecting " + Type.getTypeName(itemvalue) + ".");
                }
                ++a;
            }
        } else {
            compatible = true;
        }
        return compatible;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Method getMethod(Extendable ext) throws AssertionException {
        Method meth = null;
        if (this.d_reserved_method != 0) throw new AssertionException("Will not attempt to look up method " + this.d_name + " in " + this.getExceptionPrefix(ext) + " since the method has been " + "marked as one of the reserved assertion methods.");
        Method m = ext.lookupMethodByLongName(this.d_name, true);
        if (m == null) throw new AssertionException("Cannot locate method associated with  the assertion invocation of " + this.d_name + " since the method" + " was not found in " + this.getExceptionPrefix(ext) + ".");
        if (!this.hasCompatibleArgumentTypes(this.getArgumentReturnTypes(m))) throw new AssertionException("Method " + this.d_name + " was located in " + this.getExceptionPrefix(ext) + " but the arguments were determined to be incompatible.");
        return m;
    }

    private String getInvalidBuiltinMsg(Extendable ext) {
        return "Semantic Validation Failure: Invalid call to " + this.d_name + "() in " + this.getExceptionPrefix(ext) + " since signature is incompatible with " + "that of the built-in " + s_reserved_name[this.d_reserved_method] + " method.";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateSemantics(Extendable ext, Method m) throws AssertionException {
        if (ext == null) {
            throw new AssertionException("Cannot validate the semantics of the method call " + this.d_name + " without the context of the " + "extendable to which it belongs.");
        }
        BinaryExpression beArg = null;
        IdentifierLiteral idArg = null;
        int numArrays = 0;
        boolean hasArray = false;
        if (this.d_arguments != null && !this.d_arguments.isEmpty()) {
            ListIterator iter = this.d_arguments.listIterator();
            while (iter.hasNext()) {
                AssertionExpression arg = (AssertionExpression)iter.next();
                if (arg.getClass().getName().equals(IDENTIFIER_LITERAL)) {
                    idArg = (IdentifierLiteral)arg;
                    if (idArg.isNull()) {
                        throw new AssertionException("Semantic Validation Failure: Do NOT support passing NULL as an argument to an assertion method call since no mechanism in place to resolve such a reference.  See call to method " + this.d_name + " in " + this.getExceptionPrefix(ext) + ".");
                    }
                    arg.validateExpression(ext, m);
                    if (this.isBuiltinNumericArrayMethod() && idArg.returnIsArray()) {
                        if (!idArg.returnIsNumericArray()) throw new AssertionException("Semantic Validation Failure: Arrays passed to built-in method " + this.d_name + " must contain numeric data.  See call in " + this.getExceptionPrefix(ext) + ".");
                        this.d_reserved_array_type = this.getReturnType();
                        if (++numArrays > 2) {
                            throw new AssertionException("Semantic Validation Failure: Do not currently support more than 2 array arguments at a time in built-in assertion methods.  Attempt to exceed this limit was detected in a call to " + this.d_name + " in " + this.getExceptionPrefix(ext) + ".");
                        }
                    }
                } else if (this.isBuiltinRelationMethod() && arg.getClass().getName().equals(BINARY_EXPRESSION)) {
                    beArg = (BinaryExpression)arg;
                    beArg.setArrayRelationRequired(true);
                    beArg.validateExpression(ext, m);
                    this.d_reserved_relation = beArg.arrayOnLeft() && beArg.arrayOnRight() ? 3 : (beArg.arrayOnLeft() ? 1 : 2);
                    this.d_reserved_relation_rel = beArg.getArrayRelation();
                } else {
                    arg.validateExpression(ext, m);
                }
                if (!arg.returnIsArray()) continue;
                hasArray = true;
            }
            if (!hasArray) {
                if (this.d_reserved_method == 6) {
                    this.d_reserved_method = 18;
                } else if (this.d_reserved_method == 10) {
                    this.d_reserved_method = 19;
                } else if (this.d_reserved_method == 12) {
                    this.d_reserved_method = 20;
                }
            }
        }
        if (m != null && m.getLongMethodName().equals(this.d_name) && this.hasCompatibleArgumentTypes(this.getArgumentReturnTypes(m))) {
            throw new AssertionException("Semantic Validation Failure: Method " + this.d_name + " cannot call itself in an assertion clause.  " + "Did you mean to use the return keyword in " + this.getExceptionPrefix(ext) + " instead?");
        }
        ArrayList<Integer> rList = null;
        switch (this.d_reserved_method) {
            case 1: 
            case 2: 
            case 11: {
                rList = new ArrayList<Integer>();
                rList.add(new Integer(1));
                if (!this.hasCompatibleArgumentTypes(rList)) {
                    throw new AssertionException(this.getInvalidBuiltinMsg(ext));
                }
                this.setReturnType(1);
                return;
            }
            case 3: {
                rList = new ArrayList();
                rList.add(new Integer(1));
                if (!this.hasCompatibleArgumentTypes(rList)) {
                    throw new AssertionException(this.getInvalidBuiltinMsg(ext));
                }
                this.setReturnType(7);
                return;
            }
            case 6: {
                rList = new ArrayList();
                rList.add(new Integer(16));
                rList.add(new Integer(8));
                rList.add(new Integer(8));
                if (!this.hasCompatibleArgumentTypes(rList)) {
                    throw new AssertionException(this.getInvalidBuiltinMsg(ext));
                }
                this.setReturnType(1);
                return;
            }
            case 8: 
            case 9: 
            case 15: {
                rList = new ArrayList();
                rList.add(new Integer(16));
                if (!this.hasCompatibleArgumentTypes(rList)) {
                    throw new AssertionException(this.getInvalidBuiltinMsg(ext));
                }
                this.setReturnType(4);
                return;
            }
            case 10: {
                rList = new ArrayList();
                rList.add(new Integer(16));
                rList.add(new Integer(16));
                rList.add(new Integer(4));
                if (!this.hasCompatibleArgumentTypes(rList)) {
                    throw new AssertionException(this.getInvalidBuiltinMsg(ext));
                }
                this.setReturnType(1);
                return;
            }
            case 12: {
                rList = new ArrayList();
                rList.add(new Integer(16));
                rList.add(new Integer(4));
                rList.add(new Integer(4));
                rList.add(new Integer(4));
                if (!this.hasCompatibleArgumentTypes(rList)) {
                    throw new AssertionException(this.getInvalidBuiltinMsg(ext));
                }
                this.setReturnType(1);
                return;
            }
            case 4: 
            case 13: {
                rList = new ArrayList();
                rList.add(new Integer(16));
                if (!this.hasCompatibleArgumentTypes(rList)) {
                    throw new AssertionException(this.getInvalidBuiltinMsg(ext));
                }
                this.setReturnType(7);
                return;
            }
            case 5: 
            case 16: {
                rList = new ArrayList();
                rList.add(new Integer(16));
                if (!this.hasCompatibleArgumentTypes(rList)) {
                    throw new AssertionException(this.getInvalidBuiltinMsg(ext));
                }
                this.setReturnType(1);
                return;
            }
            case 7: 
            case 14: 
            case 17: {
                rList = new ArrayList();
                rList.add(new Integer(16));
                rList.add(new Integer(7));
                if (!this.hasCompatibleArgumentTypes(rList)) {
                    throw new AssertionException(this.getInvalidBuiltinMsg(ext));
                }
                this.setReturnType(7);
                return;
            }
            case 18: {
                rList = new ArrayList();
                rList.add(new Integer(8));
                rList.add(new Integer(8));
                rList.add(new Integer(8));
                if (!this.hasCompatibleArgumentTypes(rList)) {
                    throw new AssertionException(this.getInvalidBuiltinMsg(ext));
                }
                this.setReturnType(1);
                return;
            }
            case 19: {
                rList = new ArrayList();
                rList.add(new Integer(4));
                rList.add(new Integer(4));
                rList.add(new Integer(4));
                if (!this.hasCompatibleArgumentTypes(rList)) {
                    throw new AssertionException(this.getInvalidBuiltinMsg(ext));
                }
                this.setReturnType(1);
                return;
            }
            case 20: {
                rList = new ArrayList();
                rList.add(new Integer(4));
                rList.add(new Integer(4));
                rList.add(new Integer(4));
                rList.add(new Integer(4));
                if (!this.hasCompatibleArgumentTypes(rList)) {
                    throw new AssertionException(this.getInvalidBuiltinMsg(ext));
                }
                this.setReturnType(1);
                return;
            }
            default: {
                Method meth = this.getMethod(ext);
                if (meth == null) {
                    throw new AssertionException("Semantic Validation Failure: Invalid method call to " + this.d_name + ".  Cannot locate compatible method in " + this.getExceptionPrefix(ext));
                }
                if (!meth.hasPureAssertion()) {
                    throw new AssertionException("Semantic Validation Failure: Invalid method call to " + this.d_name + " in " + this.getExceptionPrefix(ext) + ".  The method must have a PURE clause to be callable in " + "an assertion clause.");
                }
                if (!meth.isStatic() && m.isStatic()) {
                    throw new AssertionException("Semantic Validation Failure: Invalid method call to " + this.d_name + " in " + this.getExceptionPrefix(ext) + ".  Cannot invoke non-static method, " + meth.getLongMethodName() + " from within static method " + m.getLongMethodName() + ".");
                }
                this.setReturnType(meth.getReturnType());
                this.d_throws_exceptions = meth.getThrows().size() > 0;
                this.d_is_static = meth.isStatic();
            }
        }
    }

    public String toString() {
        StringBuffer call = new StringBuffer();
        call.append(this.d_name + "(");
        ListIterator iter = this.d_arguments.listIterator();
        while (iter.hasNext()) {
            AssertionExpression arg = (AssertionExpression)iter.next();
            call.append(arg);
            if (!iter.hasNext()) continue;
            call.append(", ");
        }
        call.append(")");
        return this.hasParens() ? "(" + call.toString() + ")" : call.toString();
    }

    private String getArrayTypeStr(Type type) {
        String typeBase = type.getArrayTypeName();
        if (typeBase.equalsIgnoreCase(Type.s_names[11])) {
            typeBase = Type.s_names[7];
        }
        return "sidl_" + typeBase + "__array";
    }

    private String getCArgList(String epvVar, int[] startInd, boolean addArrayType, boolean addRelation, boolean addArrayIterVars) {
        StringBuffer argList = new StringBuffer();
        if (!this.d_is_static) {
            argList.append("self");
            if (this.d_arguments.size() > 0 || this.d_throws_exceptions) {
                argList.append(", ");
            }
        }
        ListIterator iter = this.d_arguments.listIterator();
        while (iter.hasNext()) {
            AssertionExpression arg = (AssertionExpression)iter.next();
            if (arg.returnIsArray()) {
                if (addArrayType) {
                    argList.append(this.getArrayTypeStr(arg.getReturnType()) + ", ");
                }
                argList.append(arg.cExpression(epvVar, startInd));
            } else {
                argList.append(arg.cExpression(epvVar, startInd));
            }
            if (!iter.hasNext()) continue;
            argList.append(", ");
        }
        if (this.d_throws_exceptions) {
            if (this.d_arguments.size() > 0) {
                argList.append(", ");
            }
            argList.append("_ex");
        }
        if (addRelation) {
            argList.append(", " + this.d_reserved_relation_rel);
        }
        if (addArrayIterVars) {
            argList.append(", i, max");
        }
        return argList.toString();
    }

    public ArrayList getArrayIterMacros(String epvVar, int[] startInd) {
        ArrayList<String> list = null;
        StringBuffer call = new StringBuffer();
        switch (this.d_reserved_method) {
            case 1: 
            case 11: {
                call.append(s_builtin_macro[this.d_reserved_method]);
                call.append(s_builtin_relation[this.d_reserved_relation] + "(");
                call.append(this.getCArgList(epvVar, null, true, true, true));
                call.append(", cnt");
                call.append(", bres[" + startInd[0] + "])");
                break;
            }
            case 2: {
                call.append(s_builtin_macro[this.d_reserved_method]);
                call.append(s_builtin_relation[this.d_reserved_relation] + "(");
                call.append(this.getCArgList(epvVar, null, true, true, true));
                call.append(", bres[" + startInd[0] + "])");
                break;
            }
            case 3: {
                call.append(s_builtin_macro[this.d_reserved_method]);
                call.append(s_builtin_relation[this.d_reserved_relation] + "(");
                call.append(this.getCArgList(epvVar, null, true, true, true));
                call.append(", ires[" + startInd[2] + "])");
                break;
            }
            case 5: 
            case 16: {
                call.append(s_builtin_macro[this.d_reserved_method] + "(");
                call.append(this.getCArgList(epvVar, null, true, false, true));
                call.append(", dres");
                call.append(", bres[" + startInd[0] + "])");
                break;
            }
            case 8: 
            case 9: {
                call.append(s_builtin_macro[this.d_reserved_method] + "(");
                call.append(this.getCArgList(epvVar, null, true, false, true));
                call.append(", " + this.d_reserved_array_type.getArrayTypeName());
                call.append(", dres[" + startInd[1] + "])");
                break;
            }
            case 6: 
            case 10: 
            case 12: {
                call.append(s_builtin_macro[this.d_reserved_method] + "(");
                call.append(this.getCArgList(epvVar, null, true, false, true));
                call.append(", cnt");
                call.append(", bres[" + startInd[0] + "])");
                break;
            }
            case 15: {
                call.append(s_builtin_macro[this.d_reserved_method] + "(");
                call.append(this.getCArgList(epvVar, null, true, false, true));
                call.append(", dres[" + startInd[1] + "])");
                break;
            }
        }
        if (call.length() > 0) {
            list = new ArrayList<String>();
            list.add(call.toString());
        }
        return list;
    }

    public int getNumArrayIterMacrosByType(char type) {
        int num = 0;
        if (type == MACRO_RETURN_TYPE[0]) {
            if (this.d_reserved_method == 1 || this.d_reserved_method == 2 || this.d_reserved_method == 5 || this.d_reserved_method == 6 || this.d_reserved_method == 10 || this.d_reserved_method == 11 || this.d_reserved_method == 12 || this.d_reserved_method == 16) {
                num = 1;
            }
        } else if (type == MACRO_RETURN_TYPE[1]) {
            if (this.d_reserved_method == 8 || this.d_reserved_method == 9 || this.d_reserved_method == 15) {
                num = 1;
            }
        } else if (type == MACRO_RETURN_TYPE[2]) {
            if (this.d_reserved_method == 3) {
                num = 1;
            }
        } else {
            num = 0;
        }
        return num;
    }

    public String cExpression(String epvVar, int[] startInd) {
        StringBuffer call = new StringBuffer();
        switch (this.d_reserved_method) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                call.append("bres[" + startInd[0] + "]");
                break;
            }
            case 3: {
                call.append("ires[" + startInd[2] + "]");
                break;
            }
            case 4: 
            case 7: 
            case 13: 
            case 14: 
            case 17: {
                call.append(s_builtin_macro[this.d_reserved_method] + "(");
                call.append(this.getCArgList(epvVar, startInd, true, false, false));
                call.append(")");
                break;
            }
            case 8: 
            case 9: 
            case 15: {
                call.append("dres[" + startInd[1] + "]");
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                call.append(s_builtin_macro[this.d_reserved_method] + "(");
                call.append(this.getCArgList(epvVar, startInd, true, false, false));
                call.append(")");
                break;
            }
            default: {
                call.append("(" + epvVar + "->" + IOR.getVectorEntry(this.d_name) + ")(");
                call.append(this.getCArgList(epvVar, startInd, false, false, false));
                call.append(")");
            }
        }
        return call.toString();
    }
}

