/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.symbols;

import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.SymbolTable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class Type {
    public static final int VOID = 0;
    public static final int BOOLEAN = 1;
    public static final int CHAR = 2;
    public static final int DCOMPLEX = 3;
    public static final int DOUBLE = 4;
    public static final int FCOMPLEX = 5;
    public static final int FLOAT = 6;
    public static final int INT = 7;
    public static final int LONG = 8;
    public static final int OPAQUE = 9;
    public static final int STRING = 10;
    public static final int ENUM = 11;
    public static final int CLASS = 12;
    public static final int INTERFACE = 13;
    public static final int PACKAGE = 14;
    public static final int SYMBOL = 15;
    public static final int ARRAY = 16;
    public static final int MIN_TYPE_IND = 0;
    public static final int MAX_TYPE_IND = 13;
    public static final String[] s_names = new String[]{"void", "bool", "char", "dcomplex", "double", "fcomplex", "float", "int", "long", "opaque", "string", "enum", "interface", "class"};
    public static final int UNSPECIFIED = 0;
    public static final int COLUMN_MAJOR = 1;
    public static final int ROW_MAJOR = 2;
    private static final String[] s_order = new String[]{"unspecified", "column-major", "row-major"};
    private int d_type;
    private SymbolID d_symbol_id;
    private Type d_array_type;
    private int d_array_dim;
    private int d_array_order;
    private Vector d_rarray_indices;

    public Type(int type) {
        this.d_type = type;
        this.d_symbol_id = null;
        this.d_array_type = null;
        this.d_array_dim = 0;
        this.d_array_order = 0;
        this.d_rarray_indices = null;
    }

    public Type(SymbolID id) {
        this.d_type = 15;
        this.d_symbol_id = id;
        this.d_array_type = null;
        this.d_array_dim = 0;
        this.d_array_order = 0;
        this.d_rarray_indices = null;
    }

    public Type(Type type, int dim, int order) {
        this.d_type = 16;
        this.d_symbol_id = null;
        this.d_array_type = type;
        this.d_array_dim = dim;
        this.d_array_order = order;
        this.d_rarray_indices = null;
    }

    public Type(Type type, int dim, Vector indices) {
        this.d_type = 16;
        this.d_symbol_id = null;
        this.d_array_type = type;
        this.d_array_dim = dim;
        this.d_array_order = 1;
        this.d_rarray_indices = indices;
    }

    public Type(SymbolID id, int type, Type arr_type, int dim, int order) {
        this.d_type = type;
        this.d_symbol_id = id;
        this.d_array_type = arr_type;
        this.d_array_dim = dim;
        this.d_array_order = order;
        this.d_rarray_indices = null;
    }

    public int getType() {
        int type = this.getDetailedType();
        if (type == 11 || type == 13 || type == 12 || type == 14) {
            type = 15;
        }
        return type;
    }

    public int getBasicType() {
        return this.d_type;
    }

    public String getTypeName() {
        String name = null;
        int type = this.getType();
        if (0 <= type && type <= 13) {
            name = s_names[type];
        } else if (type == 16) {
            name = "array";
        }
        return name;
    }

    public static String getTypeName(int type) {
        String name = null;
        if (0 <= type && type <= 13) {
            name = s_names[type];
        } else if (type == 16) {
            name = "array";
        }
        return name;
    }

    public int getDetailedType() {
        if (this.d_type == 15) {
            try {
                Symbol s = SymbolTable.getInstance().lookupSymbol(this.d_symbol_id);
                if (s != null) {
                    int symbolType = s.getSymbolType();
                    switch (symbolType) {
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: {
                            this.d_type = symbolType;
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.d_type;
    }

    public boolean isPrimitive() {
        return this.d_type <= 10;
    }

    public boolean isString() {
        return this.d_type == 10;
    }

    public boolean isSymbol() {
        return this.getType() == 15;
    }

    public boolean isArray() {
        return this.d_type == 16;
    }

    public int getArrayDimension() {
        return this.d_array_dim;
    }

    public int getArrayOrder() {
        return this.d_array_order;
    }

    public boolean isGenericArray() {
        return 16 == this.d_type && null == this.d_array_type;
    }

    public Type getArrayType() {
        return this.d_array_type;
    }

    public boolean isNumericArray() {
        int type = this.d_array_type != null ? this.d_array_type.getBasicType() : -1;
        return this.d_type == 16 && (type == 7 || type == 8 || type == 6 || type == 4 || type == 5 || type == 3);
    }

    public String getArrayTypeName() {
        int at;
        String name = this.d_type == 16 ? (1 <= (at = this.d_array_type.getBasicType()) && at <= 9 || at == 11 ? s_names[at] : "") : "";
        return name;
    }

    public void addArrayIndex(String s) {
        if (this.d_rarray_indices == null) {
            this.d_rarray_indices = new Vector();
        }
        this.d_rarray_indices.add(s);
    }

    public List getArrayIndices() {
        return this.d_rarray_indices;
    }

    public boolean isRarray() {
        return this.d_rarray_indices != null;
    }

    public boolean hasArrayOrderSpec() {
        return this.d_type == 16 && this.d_array_order != 0;
    }

    public int hashCode() {
        switch (this.d_type) {
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return this.d_symbol_id.hashCode();
            }
            case 16: {
                return this.d_array_dim * (this.d_array_type != null ? this.d_array_type.hashCode() : 1) + this.d_array_order;
            }
        }
        return this.d_type;
    }

    public SymbolID getSymbolID() {
        return this.d_symbol_id;
    }

    public String getTypeString() {
        StringBuffer s = new StringBuffer();
        int type = this.getType();
        if (type == 15) {
            s.append(this.d_symbol_id.getFullName());
        } else if (type == 16) {
            if (this.d_array_type == null) {
                s.append("array<>");
            } else {
                if (this.isRarray()) {
                    s.append("rarray<" + this.d_array_type.getTypeString());
                } else {
                    s.append("array<" + this.d_array_type.getTypeString());
                }
                if (this.d_array_dim > 1) {
                    s.append("," + this.d_array_dim);
                }
                if (0 < this.d_array_order && this.d_array_order <= 2 && !this.isRarray()) {
                    s.append("," + s_order[this.d_array_order]);
                }
                s.append(">");
            }
        } else if (type >= 0 && type <= 10) {
            s.append(s_names[this.d_type]);
        }
        return s.toString();
    }

    public String getIndexString() {
        StringBuffer index_list = new StringBuffer();
        if (this.d_rarray_indices.size() < 1) {
            System.err.println("ERROR: rarray has 0 index variables");
        }
        Iterator i = this.d_rarray_indices.iterator();
        while (i.hasNext()) {
            index_list.append((String)i.next());
            if (!i.hasNext()) continue;
            index_list.append(",");
        }
        return index_list.toString();
    }

    public boolean equals(Object object) {
        boolean eq = false;
        if (object != null && object instanceof Type) {
            int your_type;
            Type t = (Type)object;
            int my_type = this.getType();
            if (my_type == (your_type = t.getType())) {
                eq = my_type == 15 || my_type == 12 || my_type == 11 || my_type == 14 ? this.d_symbol_id.equals(t.d_symbol_id) : (my_type == 16 ? this.d_array_type.equals(t.d_array_type) && this.d_array_dim == t.d_array_dim && this.d_array_order == t.d_array_order : true);
            }
        }
        return eq;
    }
}

