//
// File:        RMI.java
// Package:     gov.llnl.babel.backend.rmi
// Copyright:   (c) 2004 The Regents of the University California
// Revision:     @(#) $Id: RMI.java 4434 2005-03-17 17:05:29Z epperly $
// Description: 
// Copyright (c) 2000-2001, The Regents of the University of Calfornia.
// Produced at the Lawrence Livermore National Laboratory.
// Written by the Components Team <components@llnl.gov>
// UCRL-CODE-2002-054
// All rights reserved.
// 
// This file is part of Babel. For more information, see
// http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
// for Our Notice and the LICENSE file for the GNU Lesser General Public
// License.
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License (as published by
// the Free Software Foundation) version 2.1 dated February 1999.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
// conditions of the GNU Lesser General Public License for more details.
// 
// You should have recieved a copy of the GNU Lesser General Public License
// along with this program; if not, write to the Free Software Foundation,
// Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

package gov.llnl.babel.backend.rmi;

import gov.llnl.babel.symbols.Type;
import gov.llnl.babel.symbols.Argument;

public class RMI { 

    /** generate the method call to pack an argument */
    public static String packArg( String packer_typename, String packer_varname,
                                  Argument arg)
    { 
        switch ( arg.getMode() ) { 
        case Argument.IN:
            return packType( packer_typename, packer_varname, arg.getType(), 
                             arg.getFormalName(), arg.getFormalName() );
        case Argument.INOUT:
            return packType( packer_typename, packer_varname, arg.getType(), 
                             arg.getFormalName(), "*" + arg.getFormalName() );
        default:
            return "ERROR";
        }
    }

    /**  generate the method call to pack a type
     * @param packer_typename The string name of the type that implements from 
     *                        sidl.io.Serializer
     * @param packer_varname  The variable (instance) name of the type that 
     *                        implements sidl.io.Serializer
     * @param type The type to be packed
     * @param varname The name of the variable to be packed
     * @param var Same as varname with possible derefencing based on mode
     * @return A string containing the proper 
     */
    public static String packType( String packer_typename, 
                                   String packer_varname,  Type type, 
                                   String varname, String var)
    { 
        String ext = RMI.getMethodExtension( type );
        return packer_typename + "_pack" + ext + "( " + packer_varname + ", \"" 
          + varname + "\", " + var + ", _ex2);";
    }

    /** generate the method call to unpack an argument
     * @param packer_typename
     * @param packer_varname
     * @param arg
     * @return
     */
    public static String unpackArg( String packer_typename, 
                                    String packer_varname, Argument arg ) 
    { 
        return unpackType( packer_typename, packer_varname, arg.getType(), 
                           arg.getFormalName(), arg.getFormalName() );
    }

    /** generate the method call to unpack a type */
    /**
     * @param packer_typename
     * @param packer_varname
     * @param type
     * @param varname
     * @param var
     * @return
     */
    public static String unpackType( String packer_typename, 
                                     String packer_varname, Type type, 
                                     String varname, String var)
    { 
        String ext = RMI.getMethodExtension( type );
        return packer_typename + "_unpack" + ext + "( " + packer_varname 
          + ", \"" + varname + "\", " + var + ", _ex2);";
    }

    /** generate the proper method extension for packing or unpacking
     * @param t
     * @return
     */
    public static String getMethodExtension( Type t ) { 
        if ( t.isPrimitive() ) { /* fixed size & string */
            String buff = t.getTypeString();  
            /* capitalize first letter */
            return buff.substring(0,1).toUpperCase() + buff.substring(1); 
        } else if ( t.isArray() ) { 
            //FIXME
            return "FIXME";
        } else if ( t.isSymbol() ) { 
            //FIXME
            return "FIXME";
        } else { 
            return "ERROR";
        }
    }
}
