// 
// File:          decaf_Framework_Impl.hh
// Symbol:        decaf.Framework-v0.6.3
// Symbol Type:   class
// Babel Version: 0.10.2
// Description:   Server-side implementation for decaf.Framework
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.10.2
// 

#ifndef included_decaf_Framework_Impl_hh
#define included_decaf_Framework_Impl_hh

#ifndef included_sidl_cxx_hh
#include "sidl_cxx.hh"
#endif
#ifndef included_decaf_Framework_IOR_h
#include "decaf_Framework_IOR.h"
#endif
// 
// Includes for all method dependencies.
// 
#ifndef included_decaf_Framework_hh
#include "decaf_Framework.hh"
#endif
#ifndef included_gov_cca_AbstractFramework_hh
#include "gov_cca_AbstractFramework.hh"
#endif
#ifndef included_gov_cca_CCAException_hh
#include "gov_cca_CCAException.hh"
#endif
#ifndef included_gov_cca_ComponentID_hh
#include "gov_cca_ComponentID.hh"
#endif
#ifndef included_gov_cca_ComponentRelease_hh
#include "gov_cca_ComponentRelease.hh"
#endif
#ifndef included_gov_cca_ConnectionID_hh
#include "gov_cca_ConnectionID.hh"
#endif
#ifndef included_gov_cca_Port_hh
#include "gov_cca_Port.hh"
#endif
#ifndef included_gov_cca_Services_hh
#include "gov_cca_Services.hh"
#endif
#ifndef included_gov_cca_TypeMap_hh
#include "gov_cca_TypeMap.hh"
#endif
#ifndef included_sidl_BaseInterface_hh
#include "sidl_BaseInterface.hh"
#endif
#ifndef included_sidl_ClassInfo_hh
#include "sidl_ClassInfo.hh"
#endif


#line 60 "../../../../babel/examples/cca/libdecaf/decaf_Framework_Impl.hh"
// DO-NOT-DELETE splicer.begin(decaf.Framework._includes)
#include <map>
#include <set>
#include <iostream>
//#include <utility> // for pair<,> and make_pair
#include "gov_cca_Component.hh"
#include "decaf_Services.hh"
#include "decaf_ConnectionID.hh"

namespace decaf {
  class Framework_impl; // forward declaration

  std::ostream& operator<<( std::ostream& os, Framework_impl& fwk );
}
// DO-NOT-DELETE splicer.end(decaf.Framework._includes)
#line 76 "decaf_Framework_Impl.hh"

namespace decaf { 

  /**
   * Symbol "decaf.Framework" (version 0.6.3)
   */
  class Framework_impl
#line 82 "../../../../babel/examples/cca/libdecaf/decaf_Framework_Impl.hh"
  // DO-NOT-DELETE splicer.begin(decaf.Framework._inherits)
  // Put additional inheritance here...
  // DO-NOT-DELETE splicer.end(decaf.Framework._inherits)
#line 88 "decaf_Framework_Impl.hh"
  {

  private:
    // Pointer back to IOR.
    // Use this to dispatch back through IOR vtable.
    Framework self;

#line 92 "../../../../babel/examples/cca/libdecaf/decaf_Framework_Impl.hh"
    // DO-NOT-DELETE splicer.begin(decaf.Framework._implementation)
  public:
    struct cid_compare { 
      bool operator () ( const gov::cca::ConnectionID& A, const gov::cca::ConnectionID& B ) const { 
	gov::cca::ConnectionID& a = const_cast<gov::cca::ConnectionID&>( A );
	gov::cca::ConnectionID& b = const_cast<gov::cca::ConnectionID&>( B );
	if (a.isSame(b) ) { return 0;}
	std::string s1 = a.getUser().getInstanceName();
	std::string s2 = b.getUser().getInstanceName();
	if (s1<s2) { return -1; }
	if (s1>s2) { return 1; }
	s1 = a.getUserPortName();
	s2 = b.getUserPortName();
	if (s1<s2) { return -1; }
	if (s1>s2) { return 1; }
	s1 = a.getProvider().getInstanceName();
	s2 = b.getProvider().getInstanceName();
	if (s1<s2) { return -1; }
	if (s1>s2) { return 1; }
	s1 = a.getProviderPortName();
	s2 = b.getProviderPortName();
	if (s1<s2) { return -1; }
	if (s1>s2) { return 1; }
	return 0;
      }
    };
    typedef std::map< std::string, gov::cca::ConnectionID > cidmap_t;
    typedef std::set< gov::cca::ConnectionID, cid_compare >  cidset_t;
    typedef std::map< std::string, cidset_t > cidmapset_t;

    typedef struct { 
      gov::cca::Component component;
      gov::cca::ComponentRelease release;
      gov::cca::Services svcs;
      cidmap_t usesConnection;
      cidmapset_t providesConnection;      
    } instance_t; 
    
    typedef std::map< std::string, instance_t > instancemap_t;
    instancemap_t d_instance;

    typedef std::map< std::string, std::string > aliasMap_t;
    aliasMap_t d_aliases;
    // the aliases that the framework uses to masquerade as a component
    // give the unique name, it returns the "type" (having nothing to do with
    // a component, per se) 

  protected:
    std::string p_getUniqueName( const std::string& requestedName ) ;

    int p_removeInstance( const std::string& instanceName );

    // debugging aid
    friend std::ostream& operator<<( std::ostream& os, Framework_impl& fwk );

    // DO-NOT-DELETE splicer.end(decaf.Framework._implementation)
#line 153 "decaf_Framework_Impl.hh"

  private:
    // private default constructor (required)
    Framework_impl() 
    {} 

  public:
    // sidl constructor (required)
    // Note: alternate Skel constructor doesn't call addref()
    // (fixes bug #275)
    Framework_impl( struct decaf_Framework__object * s ) : self(s,
      true) { _ctor(); }

    // user defined construction
    void _ctor();

    // virtual destructor (required)
    virtual ~Framework_impl() { _dtor(); }

    // user defined destruction
    void _dtor();

    // static class initializer
    static void _load();

  public:


    /**
     * Return the named port from the specified component id.
     */
    ::gov::cca::Port
    lookupPort (
      /* in */ ::gov::cca::ComponentID componentID,
      /* in */ const ::std::string& portName
    )
    throw () 
    ;


    /**
     * Framework creates providing component, registers provides port and connects to
     * using port for special cases (e.g. BuilderService)
     * @param type the string name of the port type 
     * (currently accepts only "gov.cca.ports.BuilderServices" and 
     * gov.cca.ports.ConnectionEventServices)
     * @param componentID the ID of the user component
     * @param portName the userPortName on the user component
     */
    void
    provideRequestedServices (
      /* in */ ::gov::cca::ComponentID componentID,
      /* in */ const ::std::string& portName,
      /* in */ const ::std::string& type
    )
    throw () 
    ;

    /**
     * user defined non-static method.
     */
    void
    setInstanceRelease (
      /* in */ ::gov::cca::ComponentID cid,
      /* in */ ::gov::cca::ComponentRelease callback
    )
    throw () 
    ;


    /**
     * 	Creates an instance of a CCA component of the type defined by the 
     * 	string className.  The string classname uniquely defines the
     * 	"type" of the component, e.g.
     * 	    doe.cca.Library.GaussianElmination. 
     * 	It has an instance name given by the string instanceName.
     * 	The instanceName may be empty (zero length) in which case
     * 	the instanceName will be assigned to the component automatically.
     * 	@throws CCAException If the Component className is unknown, or if the
     * 		instanceName has already been used, a CCAException is thrown.
     * 	@return A ComponentID corresponding to the created component. Destroying
     * 		the returned ID does not destroy the component; 
     * 		see destroyInstance instead.
     */
    ::gov::cca::ComponentID
    createInstance (
      /* in */ const ::std::string& instanceName,
      /* in */ const ::std::string& className,
      /* in */ ::gov::cca::TypeMap properties
    )
    throw ( 
      ::gov::cca::CCAException
    );


    /**
     *  Get component list.
     *  @return a ComponentID for each component currently created.
     */
    ::sidl::array< ::gov::cca::ComponentID>
    getComponentIDs() throw ( 
      ::gov::cca::CCAException
    );

    /**
     *  Get property map for component.
     *  @return the public properties associated with the component referred to by
     *  ComponentID. 
     *  @throws a CCAException if the ComponentID is invalid.
     */
    ::gov::cca::TypeMap
    getComponentProperties (
      /* in */ ::gov::cca::ComponentID cid
    )
    throw ( 
      ::gov::cca::CCAException
    );


    /**
     * 	Causes the framework implementation to associate the given properties 
     * 	with the component designated by cid. 
     * 	@throws CCAException if cid is invalid or if there is an attempted
     * 	change to a property locked by the framework implementation.
     */
    void
    setComponentProperties (
      /* in */ ::gov::cca::ComponentID cid,
      /* in */ ::gov::cca::TypeMap map
    )
    throw ( 
      ::gov::cca::CCAException
    );


    /**
     * Get component id from stringified reference.
     *    @return a ComponentID from the string produced by 
     * 	ComponentID.getSerialization(). 
     *    @throws CCAException if the string does not represent the appropriate 
     * 	 serialization of a ComponentID for the underlying framework.
     */
    ::gov::cca::ComponentID
    getDeserialization (
      /* in */ const ::std::string& s
    )
    throw ( 
      ::gov::cca::CCAException
    );


    /**
     * Get id from name by which it was created.
     *  @return a ComponentID from the instance name of the component
     *  produced by ComponentID.getInstanceName().
     *  @throws CCAException if there is no component matching the 
     *  given componentInstanceName.
     */
    ::gov::cca::ComponentID
    getComponentID (
      /* in */ const ::std::string& componentInstanceName
    )
    throw ( 
      ::gov::cca::CCAException
    );


    /**
     *  Eliminate the Component instance, from the scope of the framework.
     *  @param toDie the component to be removed.
     *  @param timeout the allowable wait; 0 means up to the framework.
     *  @throws CCAException if toDie refers to an invalid component, or
     *  if the operation takes longer than timeout seconds.
     */
    void
    destroyInstance (
      /* in */ ::gov::cca::ComponentID toDie,
      /* in */ float timeout
    )
    throw ( 
      ::gov::cca::CCAException
    );


    /**
     *  Get the names of Port instances provided by the identified component.
     *  @param cid the component.
     *  @throws CCAException if cid refers to an invalid component.
     */
    ::sidl::array< ::std::string>
    getProvidedPortNames (
      /* in */ ::gov::cca::ComponentID cid
    )
    throw ( 
      ::gov::cca::CCAException
    );


    /**
     *  Get the names of Port instances used by the identified component.
     *  @param cid the component.
     *  @throws CCAException if cid refers to an invalid component. 
     */
    ::sidl::array< ::std::string>
    getUsedPortNames (
      /* in */ ::gov::cca::ComponentID cid
    )
    throw ( 
      ::gov::cca::CCAException
    );


    /**
     *  Fetch map of Port properties exposed by the framework.
     *  @return the public properties pertaining to the Port instance 
     *    portname on the component referred to by cid. 
     *  @throws CCAException when any one of the following conditions occur:<ul>
     *    <li>portname is not a registered Port on the component indicated by cid,
     *    <li>cid refers to an invalid component. </ul>
     */
    ::gov::cca::TypeMap
    getPortProperties (
      /* in */ ::gov::cca::ComponentID cid,
      /* in */ const ::std::string& portName
    )
    throw ( 
      ::gov::cca::CCAException
    );


    /**
     *  Associates the properties given in map with the Port indicated by 
     *  portname. The component must have a Port known by portname.
     *  @throws CCAException if either cid or portname are
     * 	invalid, or if this a changed property is locked by 
     * 	 the underlying framework or component.
     */
    void
    setPortProperties (
      /* in */ ::gov::cca::ComponentID cid,
      /* in */ const ::std::string& portName,
      /* in */ ::gov::cca::TypeMap map
    )
    throw ( 
      ::gov::cca::CCAException
    );


    /**
     *   Creates a connection between ports on component user and 
     *   component provider. Destroying the ConnectionID does not
     *   cause a disconnection; for that, see disconnect().
     *   @throws CCAException when any one of the following conditions occur:<ul>
     *   <li>If either user or provider refer to an invalid component,
     *   <li>If either usingPortName or providingPortName refer to a 
     * 	 nonexistent Port on their respective component,
     *   <li>If other-- In reality there are a lot of things that can go wrong 
     * 	 with this operation, especially if the underlying connections 
     * 	 involve networking.</ul>
     */
    ::gov::cca::ConnectionID
    connect (
      /* in */ ::gov::cca::ComponentID user,
      /* in */ const ::std::string& usingPortName,
      /* in */ ::gov::cca::ComponentID provider,
      /* in */ const ::std::string& providingPortName
    )
    throw ( 
      ::gov::cca::CCAException
    );


    /**
     * Returns a list of connections as an array of 
     * 	handles. This will return all connections involving components 
     * 	in the given componentList of ComponentIDs. This
     * 	means that ConnectionID's will be returned even if only one 
     * 	of the participants in the connection appears in componentList.
     * 
     * 	@throws CCAException if any component in componentList is invalid.
     */
    ::sidl::array< ::gov::cca::ConnectionID>
    getConnectionIDs (
      /* in */ ::sidl::array< ::gov::cca::ComponentID> componentList
    )
    throw ( 
      ::gov::cca::CCAException
    );


    /**
     *   Fetch property map of a connection.
     *   @returns the properties for the given connection.
     *   @throws CCAException if connID is invalid.
     */
    ::gov::cca::TypeMap
    getConnectionProperties (
      /* in */ ::gov::cca::ConnectionID connID
    )
    throw ( 
      ::gov::cca::CCAException
    );


    /**
     * Associates the properties with the connection.
     *   @param map the source of the properties.
     *   @param connID connection to receive property values.
     *   @throws CCAException if connID is invalid, or if this changes 
     * 	 a property locked by the underlying framework.
     */
    void
    setConnectionProperties (
      /* in */ ::gov::cca::ConnectionID connID,
      /* in */ ::gov::cca::TypeMap map
    )
    throw ( 
      ::gov::cca::CCAException
    );


    /**
     * Disconnect the connection indicated by connID before the indicated
     *     timeout in secs. Upon successful completion, connID and the connection
     *     it represents become invalid. 
     *     @param timeout the time in seconds to wait for a connection to close; 0
     *     means to use the framework implementation default.
     *     @throws CCAException when any one of the following conditions occur: <ul>
     *     <li>id refers to an invalid ConnectionID,
     *     <li>timeout is exceeded, after which, if id was valid before 
     * disconnect() was invoked, it remains valid
     * </ul>
     * 
     */
    void
    disconnect (
      /* in */ ::gov::cca::ConnectionID connID,
      /* in */ float timeout
    )
    throw ( 
      ::gov::cca::CCAException
    );


    /**
     * Remove all connections between components id1 and id2 within 
     *   the period of timeout secs. If id2 is null, then all connections 
     *   to id1 are removed (within the period of timeout secs).
     *   @throws CCAException when any one of the following conditions occur:<ul>
     * 	  <li>id1 or id2 refer to an invalid ComponentID (other than id2 == null),
     * 	  <li>The timeout period is exceeded before the disconnections can be made. 
     * 	  </ul>
     */
    void
    disconnectAll (
      /* in */ ::gov::cca::ComponentID id1,
      /* in */ ::gov::cca::ComponentID id2,
      /* in */ float timeout
    )
    throw ( 
      ::gov::cca::CCAException
    );


    /**
     *  Create an empty TypeMap. Presumably this would be used in 
     *  an ensuing call to <code>getServices()</code>. The "normal" method of
     *  creating typemaps is found in the <code>Services</code> interface. It
     *  is duplicated here to break the "chicken and egg" problem.
     */
    ::gov::cca::TypeMap
    createTypeMap() throw ( 
      ::gov::cca::CCAException
    );

    /**
     * Retrieve a Services handle to the underlying framework. 
     * This interface effectively causes the calling program to 
     * appear as the image of a component inside the framework.
     * This method may be called any number of times
     * with different arguments, creating a new component image 
     * each time. 
     * The only proper method to destroy a Services obtained 
     * from this interface is to pass it to releaseServices.
     * 
     * @param selfInstanceName the Component instance name,
     * as it will appear in the framework.
     * 
     * @param selfClassName the Component type of the 
     * calling program, as it will appear in the framework. 
     * 
     * @param selfProperties (which can be null) the properties 
     * of the component image to appear. 
     * 
     * @throws CCAException in the event that selfInstanceName 
     * is already in use by another component.
     * 
     * @return  A Services object that pertains to the
     * 	    image of the this component. This is identical
     * 	    to the object passed into Component.setServices() 
     * 	    when a component is created.
     */
    ::gov::cca::Services
    getServices (
      /* in */ const ::std::string& selfInstanceName,
      /* in */ const ::std::string& selfClassName,
      /* in */ ::gov::cca::TypeMap selfProperties
    )
    throw ( 
      ::gov::cca::CCAException
    );


    /**
     * Inform framework that the <code>Services</code> handle is no longer needed by the 
     * caller and that the reference to its component image is to be
     * deleted from the context of the underlying framework. This invalidates
     * any <code>ComponentID</code>'s or <code>ConnectionID</code>'s associated 
     * with the given <code>Services</code>' component image. 
     * 
     * @param svc The result of getServices earlier obtained.
     * 
     * @throws CCAException if the <code>Services</code>
     *         handle has already been released or is otherwise rendered invalid 
     *         or was not obtained from <code>getServices()</code>.
     */
    void
    releaseServices (
      /* in */ ::gov::cca::Services svc
    )
    throw ( 
      ::gov::cca::CCAException
    );


    /**
     * Tell the framework it is no longer needed and to clean up after itself. 
     *  @throws CCAException if the framework has already been shutdown.
     */
    void
    shutdownFramework() throw ( 
      ::gov::cca::CCAException
    );

    /**
     * Creates a new framework instance based on the same underlying 
     * framework implementation. This does not copy the existing 
     * framework, nor are any of the user-instantiated components in
     * the original framework available in the newly created 
     * <code>AbstractFramework</code>. 
     * 
     * @throws CCAException when one of the following conditions occur:
     * 
     * (1)the AbstractFramework previously had shutdownFramework() called on it, or 
     * (2)the underlying framework implementation does not permit creation 
     * of another instance.	 
     */
    ::gov::cca::AbstractFramework
    createEmptyFramework() throw ( 
      ::gov::cca::CCAException
    );
  };  // end class Framework_impl

} // end namespace decaf

#line 613 "../../../../babel/examples/cca/libdecaf/decaf_Framework_Impl.hh"
// DO-NOT-DELETE splicer.begin(decaf.Framework._misc)
// DO-NOT-DELETE splicer.end(decaf.Framework._misc)
#line 622 "decaf_Framework_Impl.hh"

#endif
