/*
 * File:          sidl_io_Serializer_jniStub.c
 * Symbol:        sidl.io.Serializer-v0.9.1
 * Symbol Type:   interface
 * Babel Version: 0.10.2
 * Release:       $Name:  $
 * Revision:      @(#) $Id: $
 * Description:   Client-side JNI glue code for sidl.io.Serializer
 * 
 * Copyright (c) 2000-2002, The Regents of the University of California.
 * Produced at the Lawrence Livermore National Laboratory.
 * Written by the Components Team <components@llnl.gov>
 * All rights reserved.
 * 
 * This file is part of Babel. For more information, see
 * http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
 * for Our Notice and the LICENSE file for the GNU Lesser General Public
 * License.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License (as published by
 * the Free Software Foundation) version 2.1 dated February 1999.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
 * conditions of the GNU Lesser General Public License for more details.
 * 
 * You should have recieved a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * WARNING: Automatically generated; changes will be lost
 * 
 * babel-version = 0.10.2
 */

#include "sidl_Java.h"
#include "sidl_Loader.h"
#include "sidl_String.h"
#include "sidl_io_Serializer_IOR.h"
#include "babel_config.h"

/*
 * Convert between jlong and void* pointers.
 */

#if (SIZEOF_VOID_P == 8)
#define JLONG_TO_POINTER(x) ((void*)(x))
#define POINTER_TO_JLONG(x) ((jlong)(x))
#else
#define JLONG_TO_POINTER(x) ((void*)(int32_t)(x))
#define POINTER_TO_JLONG(x) ((jlong)(int32_t)(x))
#endif

#ifndef NULL
#define NULL 0
#endif

/*
 * Function to extract IOR reference from the Java object.
 */

static struct sidl_io_Serializer__object* _get_ior(
  JNIEnv* env,
  jobject obj)
{
  void* ptr = NULL;
  static jmethodID mid = (jmethodID) NULL;

  if (mid == (jmethodID) NULL) {
    jclass cls = (*env)->GetObjectClass(env, obj);
    mid = (*env)->GetMethodID(env, cls, "_get_ior", "()J");
    (*env)->DeleteLocalRef(env, cls);
  }

  ptr = JLONG_TO_POINTER((*env)->CallLongMethod(env, obj, mid));
  return (struct sidl_io_Serializer__object*) ptr;
}

/*
 * <p>
 * Add one to the intrinsic reference count in the underlying object.
 * Object in <code>sidl</code> have an intrinsic reference count.
 * Objects continue to exist as long as the reference count is
 * positive. Clients should call this method whenever they
 * create another ongoing reference to an object or interface.
 * </p>
 * <p>
 * This does not have a return value because there is no language
 * independent type that can refer to an interface or a
 * class.
 * </p>
 */

static void
jni_addRef(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_io_Serializer__object* _ior = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_addRef))(
    _ior->d_object);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Decrease by one the intrinsic reference count in the underlying
 * object, and delete the object if the reference is non-positive.
 * Objects in <code>sidl</code> have an intrinsic reference count.
 * Clients should call this method whenever they remove a
 * reference to an object or interface.
 */

static void
jni_deleteRef(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_io_Serializer__object* _ior = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_deleteRef))(
    _ior->d_object);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

}

/*
 * Return true if and only if <code>obj</code> refers to the same
 * object as this object.
 */

static jboolean
jni_isSame(
  JNIEnv* env,
  jobject obj,
  jobject _arg_iobj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_io_Serializer__object* _ior = NULL;
  struct sidl_BaseInterface__object* _tmp_iobj = (struct 
    sidl_BaseInterface__object*) NULL;
  sidl_bool _ior_res = FALSE;
  jboolean _res = JNI_FALSE;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_iobj = (struct sidl_BaseInterface__object*) sidl_Java_J2I_ifc(env,
    _arg_iobj, "sidl.BaseInterface");

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_isSame))(
    _ior->d_object,
    _tmp_iobj);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = (jboolean) _ior_res;

  return _res;
}

/*
 * Check whether the object can support the specified interface or
 * class.  If the <code>sidl</code> type name in <code>name</code>
 * is supported, then a reference to that object is returned with the
 * reference count incremented.  The callee will be responsible for
 * calling <code>deleteRef</code> on the returned object.  If
 * the specified type is not supported, then a null reference is
 * returned.
 */

static jobject
jni_queryInt(
  JNIEnv* env,
  jobject obj,
  jstring _arg_name)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_io_Serializer__object* _ior = NULL;
  char* _tmp_name = (char*) NULL;
  struct sidl_BaseInterface__object* _ior_res = (struct 
    sidl_BaseInterface__object*) NULL;
  jobject _res = (jobject) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_name = sidl_Java_J2I_string(env, _arg_name);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_queryInt))(
    _ior->d_object,
    _tmp_name);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_name);
  _res = sidl_Java_I2J_ifc(env, _ior_res, "sidl.BaseInterface");

  return _res;
}

/*
 * Return whether this object is an instance of the specified type.
 * The string name must be the <code>sidl</code> type name.  This
 * routine will return <code>true</code> if and only if a cast to
 * the string type name would succeed.
 */

static jboolean
jni_isType(
  JNIEnv* env,
  jobject obj,
  jstring _arg_name)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_io_Serializer__object* _ior = NULL;
  char* _tmp_name = (char*) NULL;
  sidl_bool _ior_res = FALSE;
  jboolean _res = JNI_FALSE;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_name = sidl_Java_J2I_string(env, _arg_name);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_isType))(
    _ior->d_object,
    _tmp_name);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_name);
  _res = (jboolean) _ior_res;

  return _res;
}

/*
 * Return the meta-data about the class implementing this interface.
 */

static jobject
jni_getClassInfo(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_io_Serializer__object* _ior = NULL;
  struct sidl_ClassInfo__object* _ior_res = (struct sidl_ClassInfo__object*) 
    NULL;
  jobject _res = (jobject) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getClassInfo))(
    _ior->d_object);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = sidl_Java_I2J_ifc(env, _ior_res, "sidl.ClassInfo");

  return _res;
}

/*
 * Method:  packBool[]
 */

static void
jni_packBool(
  JNIEnv* env,
  jobject obj,
  jstring _arg_key,
  jboolean _arg_value)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_io_Serializer__object* _ior = NULL;
  char* _tmp_key = (char*) NULL;
  sidl_bool _tmp_value = FALSE;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_key = sidl_Java_J2I_string(env, _arg_key);
  _tmp_value = (sidl_bool) _arg_value;

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_packBool))(
    _ior->d_object,
    _tmp_key,
    _tmp_value,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_key);
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.io.IOException",
    NULL);
}

/*
 * Method:  packChar[]
 */

static void
jni_packChar(
  JNIEnv* env,
  jobject obj,
  jstring _arg_key,
  jchar _arg_value)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_io_Serializer__object* _ior = NULL;
  char* _tmp_key = (char*) NULL;
  char _tmp_value = (char) 0;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_key = sidl_Java_J2I_string(env, _arg_key);
  _tmp_value = (char) _arg_value;

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_packChar))(
    _ior->d_object,
    _tmp_key,
    _tmp_value,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_key);
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.io.IOException",
    NULL);
}

/*
 * Method:  packInt[]
 */

static void
jni_packInt(
  JNIEnv* env,
  jobject obj,
  jstring _arg_key,
  jint _arg_value)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_io_Serializer__object* _ior = NULL;
  char* _tmp_key = (char*) NULL;
  int32_t _tmp_value = 0;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_key = sidl_Java_J2I_string(env, _arg_key);
  _tmp_value = (int32_t) _arg_value;

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_packInt))(
    _ior->d_object,
    _tmp_key,
    _tmp_value,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_key);
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.io.IOException",
    NULL);
}

/*
 * Method:  packLong[]
 */

static void
jni_packLong(
  JNIEnv* env,
  jobject obj,
  jstring _arg_key,
  jlong _arg_value)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_io_Serializer__object* _ior = NULL;
  char* _tmp_key = (char*) NULL;
  int64_t _tmp_value = 0;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_key = sidl_Java_J2I_string(env, _arg_key);
  _tmp_value = (int64_t) _arg_value;

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_packLong))(
    _ior->d_object,
    _tmp_key,
    _tmp_value,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_key);
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.io.IOException",
    NULL);
}

/*
 * Method:  packFloat[]
 */

static void
jni_packFloat(
  JNIEnv* env,
  jobject obj,
  jstring _arg_key,
  jfloat _arg_value)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_io_Serializer__object* _ior = NULL;
  char* _tmp_key = (char*) NULL;
  float _tmp_value = 0.0;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_key = sidl_Java_J2I_string(env, _arg_key);
  _tmp_value = (float) _arg_value;

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_packFloat))(
    _ior->d_object,
    _tmp_key,
    _tmp_value,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_key);
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.io.IOException",
    NULL);
}

/*
 * Method:  packDouble[]
 */

static void
jni_packDouble(
  JNIEnv* env,
  jobject obj,
  jstring _arg_key,
  jdouble _arg_value)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_io_Serializer__object* _ior = NULL;
  char* _tmp_key = (char*) NULL;
  double _tmp_value = 0.0;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_key = sidl_Java_J2I_string(env, _arg_key);
  _tmp_value = (double) _arg_value;

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_packDouble))(
    _ior->d_object,
    _tmp_key,
    _tmp_value,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_key);
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.io.IOException",
    NULL);
}

/*
 * Method:  packFcomplex[]
 */

static void
jni_packFcomplex(
  JNIEnv* env,
  jobject obj,
  jstring _arg_key,
  jobject _arg_value)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_io_Serializer__object* _ior = NULL;
  char* _tmp_key = (char*) NULL;
  struct sidl_fcomplex _tmp_value = { 0.0, 0.0 };
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_key = sidl_Java_J2I_string(env, _arg_key);
  _tmp_value = sidl_Java_J2I_fcomplex(env, _arg_value);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_packFcomplex))(
    _ior->d_object,
    _tmp_key,
    _tmp_value,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_key);
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.io.IOException",
    NULL);
}

/*
 * Method:  packDcomplex[]
 */

static void
jni_packDcomplex(
  JNIEnv* env,
  jobject obj,
  jstring _arg_key,
  jobject _arg_value)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_io_Serializer__object* _ior = NULL;
  char* _tmp_key = (char*) NULL;
  struct sidl_dcomplex _tmp_value = { 0.0, 0.0 };
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_key = sidl_Java_J2I_string(env, _arg_key);
  _tmp_value = sidl_Java_J2I_dcomplex(env, _arg_value);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_packDcomplex))(
    _ior->d_object,
    _tmp_key,
    _tmp_value,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_key);
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.io.IOException",
    NULL);
}

/*
 * Method:  packString[]
 */

static void
jni_packString(
  JNIEnv* env,
  jobject obj,
  jstring _arg_key,
  jstring _arg_value)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_io_Serializer__object* _ior = NULL;
  char* _tmp_key = (char*) NULL;
  char* _tmp_value = (char*) NULL;
  struct sidl_BaseInterface__object* _ex = NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_key = sidl_Java_J2I_string(env, _arg_key);
  _tmp_value = sidl_Java_J2I_string(env, _arg_value);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_packString))(
    _ior->d_object,
    _tmp_key,
    _tmp_value,
    &_ex);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_key);
  sidl_String_free(_tmp_value);
  sidl_Java_CheckException(
    env,
    _ex,
    "sidl.io.IOException",
    NULL);
}

/*
 * Register JNI methods with the Java JVM.
 */

void sidl_io_Serializer__register(JNIEnv* env)
{
  JNINativeMethod methods[15];
  jclass cls;

  methods[0].name      = "addRef";
  methods[0].signature = "()V";
  methods[0].fnPtr     = (void *)jni_addRef;
  methods[1].name      = "deleteRef";
  methods[1].signature = "()V";
  methods[1].fnPtr     = (void *)jni_deleteRef;
  methods[2].name      = "isSame";
  methods[2].signature = "(Lsidl/BaseInterface;)Z";
  methods[2].fnPtr     = (void *)jni_isSame;
  methods[3].name      = "queryInt";
  methods[3].signature = "(Ljava/lang/String;)Lsidl/BaseInterface;";
  methods[3].fnPtr     = (void *)jni_queryInt;
  methods[4].name      = "isType";
  methods[4].signature = "(Ljava/lang/String;)Z";
  methods[4].fnPtr     = (void *)jni_isType;
  methods[5].name      = "getClassInfo";
  methods[5].signature = "()Lsidl/ClassInfo;";
  methods[5].fnPtr     = (void *)jni_getClassInfo;
  methods[6].name      = "packBool";
  methods[6].signature = "(Ljava/lang/String;Z)V";
  methods[6].fnPtr     = (void *)jni_packBool;
  methods[7].name      = "packChar";
  methods[7].signature = "(Ljava/lang/String;C)V";
  methods[7].fnPtr     = (void *)jni_packChar;
  methods[8].name      = "packInt";
  methods[8].signature = "(Ljava/lang/String;I)V";
  methods[8].fnPtr     = (void *)jni_packInt;
  methods[9].name      = "packLong";
  methods[9].signature = "(Ljava/lang/String;J)V";
  methods[9].fnPtr     = (void *)jni_packLong;
  methods[10].name      = "packFloat";
  methods[10].signature = "(Ljava/lang/String;F)V";
  methods[10].fnPtr     = (void *)jni_packFloat;
  methods[11].name      = "packDouble";
  methods[11].signature = "(Ljava/lang/String;D)V";
  methods[11].fnPtr     = (void *)jni_packDouble;
  methods[12].name      = "packFcomplex";
  methods[12].signature = "(Ljava/lang/String;Lsidl/FloatComplex;)V";
  methods[12].fnPtr     = (void *)jni_packFcomplex;
  methods[13].name      = "packDcomplex";
  methods[13].signature = "(Ljava/lang/String;Lsidl/DoubleComplex;)V";
  methods[13].fnPtr     = (void *)jni_packDcomplex;
  methods[14].name      = "packString";
  methods[14].signature = "(Ljava/lang/String;Ljava/lang/String;)V";
  methods[14].fnPtr     = (void *)jni_packString;


  cls = (*env)->FindClass(env, "sidl/io/Serializer$Wrapper");
  if (cls) {
    (*env)->RegisterNatives(env, cls, methods, 15);
    (*env)->DeleteLocalRef(env, cls);
  }
}
