##
## File:        make.runSIDL
## Package:     Generic Makefile.am support for running sidl drivers
## Revision:    $Revision: 4434 $
## Modified:    $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
## Description: automake makefile for sidl driver regression tests
##
## Copyright (c) 2003, The Regents of the University of Calfornia.
## Produced at the Lawrence Livermore National Laboratory.
## Written by the Components Team <components@llnl.gov>
## UCRL-CODE-2002-054
## All rights reserved.
##
## This file is part of Babel. For more information, see
## http:##www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
## for Our Notice and the LICENSE file for the GNU Lesser General Public
## License.
##
## This program is free software; you can redistribute it and/or modify it
## under the terms of the GNU Lesser General Public License (as published by
## the Free Software Foundation) version 2.1 dated February 1999.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
## conditions of the GNU Lesser General Public License for more details.
##
## You should have recieved a copy of the GNU Lesser General Public License
## along with this program; if not, write to the Free Software Foundation,
## Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA





check_SCRIPTS = runSIDL.sh

BABELDIR=$(top_builddir)/bin

REPODIR=./xml
REPO2DIR=./xml2
SIDLDIR=./sidl

babel-stamp: $(check_SCRIPTS) $(SIDLFILE) 
	mkdir -p $(SIDLDIR)
	$(SHELL) $(BABELDIR)/babel --text=sidl                      \
		--output-directory=$(SIDLDIR) $(SIDLFILE)
	mkdir -p $(REPODIR)
	$(SHELL) $(BABELDIR)/babel --text=xml                       \
		--output-directory=$(REPODIR) $(SIDLFILE)
	$(SHELL) $(BABELDIR)/babel --text=sidl                      \
		--repository-path=$(REPODIR)                            \
		--output-directory=$(REPODIR) $(TESTPKG)
	mkdir -p $(REPO2DIR)
	$(SHELL) $(BABELDIR)/babel --text=xml                       \
		--output-directory=$(REPO2DIR)                          \
		$(REPODIR)/$(GENFILENAME)
	$(MAKE) $(AM_MAKEFLAGS)
	chmod a+x $(check_SCRIPTS)
	touch babel-stamp

clean-local:
	rm -f babel-stamp stamp-installcheck
	rm -rf $(REPODIR) $(REPO2DIR) $(SIDLDIR)
	test "X$(srcdir)" = "X." || rm -f $(check_SCRIPTS)

check-local:
	@if test -f stamp-installcheck; then		\
	  echo $(MAKE) $(AM_MAKEFLAGS) clean;		\
	  $(MAKE) $(AM_MAKEFLAGS) clean;		\
	fi
	$(MAKE) $(AM_MAKEFLAGS) babel-stamp 


installcheck-local:
	@if test ! -f stamp-installcheck; then		\
	  echo $(MAKE) $(AM_MAKEFLAGS) clean;		\
	  $(MAKE) $(AM_MAKEFLAGS) clean;		\
	fi
	$(MAKE) $(AM_MAKEFLAGS)				\
	  BABELDIR=$(bindir) babel-stamp 
	touch stamp-installcheck


