##
## File:        make.runCxx
## Package:     Babel regression checks
## Revision:    $Revision: 4466 $
## Modified:    $Date: 2005-03-23 15:02:45 -0800 (Wed, 23 Mar 2005) $
## Description: automake makefile for run regression tests
##
## Copyright (c) 2000-2002, The Regents of the University of Calfornia.
## Produced at the Lawrence Livermore National Laboratory.
## Written by the Components Team <components@llnl.gov>
## UCRL-CODE-2002-054
## All rights reserved.
##
## This file is part of Babel. For more information, see
## http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
## for Our Notice and the LICENSE file for the GNU Lesser General Public
## License.
##
## This program is free software; you can redistribute it and/or modify it
## under the terms of the GNU Lesser General Public License (as published by
## the Free Software Foundation) version 2.1 dated February 1999.
##
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
## conditions of the GNU Lesser General Public License for more details.
##
## You should have recieved a copy of the GNU Lesser General Public License
## along with this program; if not, write to the Free Software Foundation,
## Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA





OUTPUTSIDL=$(srcdir)/../../output/output.sidl

check_PROGRAMS    = $(STATIC_PROGS) $(SHARED_PROGS)
check_SCRIPTS     = runAll.sh
check_LTLIBRARIES = libClient.la

BABELDIR    = $(top_builddir)/bin
INCLUDEDIR  = $(top_builddir)/lib/sidlstubs/UCxx
INCLUDEDIR2 = .
LIBSIDL     = $(top_builddir)/runtime/sidl/libsidl.la
LIBSIDLSTUB = $(top_builddir)/lib/sidlstubs/UCxx/libsidlstub_ucxx.la
LIBSYNC     = ../../output/libC/libOutput.la
PUREBABELGEN=$(STUBSRCS) $(STUBHDRS) $(IORHDRS)
CLEANFILES=$(PUREBABELGEN) babel-temp babel-stamp \
	stamp-installcheck core

if SUPPORT_STATIC
if SUPPORT_FORTRAN77
  BABEL_STATIC_F77  = runUCxx2F77 
else
  BABEL_STATIC_F77  = 
endif
if SUPPORT_FORTRAN90
  BABEL_STATIC_F90  = runUCxx2F90
else
  BABEL_STATIC_F90  = 
endif
STATIC_PROGS       = runUCxx2C runUCxx2UCxx runUCxx2Cxx $(BABEL_STATIC_F77) $(BABEL_STATIC_F90)

runUCxx2C_SOURCES        = $(TESTFILE)
runUCxx2C_LDFLAGS        = -static
runUCxx2C_LDADD          = libClient.la ../libC/libImpl.la \
			  $(LIBSYNC) $(LIBSIDL)

runUCxx2UCxx_SOURCES      = $(TESTFILE)
runUCxx2UCxx_LDFLAGS      = -static
runUCxx2UCxx_LDADD        = libClient.la ../libUCxx/libImpl.la \
			  $(LIBSYNC) $(LIBSIDL)

runUCxx2Cxx_SOURCES      = $(TESTFILE)
runUCxx2Cxx_LDFLAGS      = -static
runUCxx2Cxx_LDADD        = libClient.la ../libCxx/libImpl.la \
			  $(LIBSYNC) $(LIBSIDL)

if SUPPORT_FORTRAN77
runUCxx2F77_SOURCES      = $(TESTFILE)
runUCxx2F77_LDFLAGS      = -static
runUCxx2F77_LDADD        = libClient.la ../libF77/libImpl.la \
			  $(LIBSYNC) $(LIBSIDL) $(FLIBS)
endif

if SUPPORT_FORTRAN90
runUCxx2F90_SOURCES      = $(TESTFILE)
runUCxx2F90_LDFLAGS      = -static
runUCxx2F90_LDADD        = libClient.la ../libF90/libImpl.la \
			  $(LIBSYNC) $(LIBSIDL) $(FCLIBS)
endif
endif
if SUPPORT_SHARED
SHARED_PROGS            = runAll
runAll_SOURCES          = $(TESTFILE)
runAll_LDFLAGS		= -dynamic
runAll_LDADD            = libClient.la $(LIBSYNC) $(LIBSIDL)
endif

nodist_libClient_la_SOURCES      = $(PUREBABELGEN)
libClient_la_LIBADD       = $(LIBSIDLSTUB) $(LIBSIDL)
libClient_la_LDFLAGS      = -no-undefined -rpath `pwd`/.libs \
			    -release @VERSION@
EXTRA_DIST = babel.make
AM_CPPFLAGS   = -I. -I$(INCLUDEDIR) -I$(INCLUDEDIR2)

$(PUREBABELGEN) : babel-stamp
	@if test -f $@; then \
	  touch $@; \
	else \
	  rm -f babel-stamp; \
	  $(MAKE) $(AM_MAKEFLAGS) ; \
	fi

babel-stamp: $(SIDLFILE) $(OUTPUTSIDL)
	@rm -f babel-temp
	@touch babel-temp
	$(SHELL) $(BABELDIR)/babel --client=UCxx \
		--suppress-timestamp --exclude-external $(SIDLFILE) \
		$(OUTPUTSIDL)
	@mv -f babel-temp $@

clean-local:
	rm -f *.a *.so
	rm -rf ti_files
	test "X$(srcdir)" = "X." || rm -f babel.make

update-babel-make: babel-stamp
	if test "X$(srcdir)" != "X."; then \
	   cp babel.make $(srcdir); \
	fi

check-local:
	@if test -f stamp-installcheck; then		\
	  echo $(MAKE) $(AM_MAKEFLAGS) clean;		\
	  $(MAKE) $(AM_MAKEFLAGS) clean;		\
	fi
	$(MAKE) $(AM_MAKEFLAGS) $(check_LTLIBRARIES) $(check_PROGRAMS) $(check_SCRIPTS) 

installcheck-local:
	@if test ! -f stamp-installcheck; then		\
	  echo $(MAKE) $(AM_MAKEFLAGS) clean;		\
	  $(MAKE) $(AM_MAKEFLAGS) clean;		\
	fi
	$(MAKE) $(AM_MAKEFLAGS)				\
	  BABELDIR=$(bindir)				\
	  LIBSIDL=$(libdir)/libsidl.la			\
	  INCLUDEDIR=$(includedir)/UCxx			\
	  LIBSIDLSTUB=$(libdir)/libsidlstub_ucxx.la	\
	$(check_LTLIBRARIES) $(check_PROGRAMS) $(check_SCRIPTS) 
	touch stamp-installcheck

# Make sure Makefile.in is newer than babel.make
dist-hook:
	touch -c $(distdir)/Makefile.in
