/*
 * File:          objarg_Employee_Impl.c
 * Symbol:        objarg.Employee-v0.5
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Description:   Server-side implementation for objarg.Employee
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 * babel-version = 0.10.2
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "objarg.Employee" (version 0.5)
 * 
 * This object type holds the basic information about an employee:
 * name, age, salary and marital status.  This object exists purely
 * to serve as a test case for sidl.  It is not intended for serious
 * use.
 */

#include "objarg_Employee_Impl.h"

#line 29 "../../../../babel/regression/objarg/libC/objarg_Employee_Impl.c"
/* DO-NOT-DELETE splicer.begin(objarg.Employee._includes) */
#include <stdlib.h>
#include "sidl_String.h"
/* DO-NOT-DELETE splicer.end(objarg.Employee._includes) */
#line 34 "objarg_Employee_Impl.c"

/*
 * Static class initializer called exactly once before any user-defined method is dispatched
 */

#undef __FUNC__
#define __FUNC__ "impl_objarg_Employee__load"

void
impl_objarg_Employee__load(
  void)
{
#line 45 "../../../../babel/regression/objarg/libC/objarg_Employee_Impl.c"
  /* DO-NOT-DELETE splicer.begin(objarg.Employee._load) */
  /* Insert the implementation of the static class initializer method here... */
  /* DO-NOT-DELETE splicer.end(objarg.Employee._load) */
#line 51 "objarg_Employee_Impl.c"
}
/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_objarg_Employee__ctor"

void
impl_objarg_Employee__ctor(
  /* in */ objarg_Employee self)
{
#line 60 "../../../../babel/regression/objarg/libC/objarg_Employee_Impl.c"
  /* DO-NOT-DELETE splicer.begin(objarg.Employee._ctor) */
  struct objarg_Employee__data *dptr = 
    malloc(sizeof(struct objarg_Employee__data));
  if (dptr) {
    dptr->d_name = NULL;
    dptr->d_salary = 0;
    dptr->d_status = '\0';
    dptr->d_age = 0;
  }
  objarg_Employee__set_data(self, dptr);
  /* DO-NOT-DELETE splicer.end(objarg.Employee._ctor) */
#line 76 "objarg_Employee_Impl.c"
}

/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_objarg_Employee__dtor"

void
impl_objarg_Employee__dtor(
  /* in */ objarg_Employee self)
{
#line 84 "../../../../babel/regression/objarg/libC/objarg_Employee_Impl.c"
  /* DO-NOT-DELETE splicer.begin(objarg.Employee._dtor) */
  struct objarg_Employee__data *dptr = 
    objarg_Employee__get_data(self);
  if (dptr) {
    sidl_String_free((char *)dptr->d_name);
    dptr->d_name = NULL;
    free((void*)dptr);
    objarg_Employee__set_data(self, NULL);
  }
  /* DO-NOT-DELETE splicer.end(objarg.Employee._dtor) */
#line 101 "objarg_Employee_Impl.c"
}

/*
 * Provide the data for the employee object to hold.
 * <code>false</code> is returned when the data was unacceptable.
 * <code>true</code> means the employee object was successfully
 * initialized.
 */

#undef __FUNC__
#define __FUNC__ "impl_objarg_Employee_init"

sidl_bool
impl_objarg_Employee_init(
  /* in */ objarg_Employee self,
  /* in */ const char* name,
  /* in */ int32_t age,
  /* in */ float salary,
  /* in */ char status)
{
#line 114 "../../../../babel/regression/objarg/libC/objarg_Employee_Impl.c"
  /* DO-NOT-DELETE splicer.begin(objarg.Employee.init) */
  objarg_Employee_setName(self, name);
  objarg_Employee_setAge(self, age);
  objarg_Employee_setSalary(self, salary);
  objarg_Employee_setStatus(self, status);
  return TRUE;
  /* DO-NOT-DELETE splicer.end(objarg.Employee.init) */
#line 130 "objarg_Employee_Impl.c"
}

/*
 * Change the name of an employee.
 */

#undef __FUNC__
#define __FUNC__ "impl_objarg_Employee_setName"

void
impl_objarg_Employee_setName(
  /* in */ objarg_Employee self,
  /* in */ const char* name)
{
#line 135 "../../../../babel/regression/objarg/libC/objarg_Employee_Impl.c"
  /* DO-NOT-DELETE splicer.begin(objarg.Employee.setName) */
  struct objarg_Employee__data *dptr = 
    objarg_Employee__get_data(self);
  if (dptr) {
    dptr->d_name = sidl_String_strdup(name);
  }
  /* DO-NOT-DELETE splicer.end(objarg.Employee.setName) */
#line 153 "objarg_Employee_Impl.c"
}

/*
 * Return the name of an employee.
 */

#undef __FUNC__
#define __FUNC__ "impl_objarg_Employee_getName"

char*
impl_objarg_Employee_getName(
  /* in */ objarg_Employee self)
{
#line 155 "../../../../babel/regression/objarg/libC/objarg_Employee_Impl.c"
  /* DO-NOT-DELETE splicer.begin(objarg.Employee.getName) */
  struct objarg_Employee__data *dptr = 
    objarg_Employee__get_data(self);
  return dptr ? sidl_String_strdup(dptr->d_name) : 0;
  /* DO-NOT-DELETE splicer.end(objarg.Employee.getName) */
#line 173 "objarg_Employee_Impl.c"
}

/*
 * Change the age of an employee.
 */

#undef __FUNC__
#define __FUNC__ "impl_objarg_Employee_setAge"

void
impl_objarg_Employee_setAge(
  /* in */ objarg_Employee self,
  /* in */ int32_t age)
{
#line 174 "../../../../babel/regression/objarg/libC/objarg_Employee_Impl.c"
  /* DO-NOT-DELETE splicer.begin(objarg.Employee.setAge) */
  struct objarg_Employee__data *dptr = 
    objarg_Employee__get_data(self);
  if (dptr) {
    dptr->d_age = age;
  }
  /* DO-NOT-DELETE splicer.end(objarg.Employee.setAge) */
#line 196 "objarg_Employee_Impl.c"
}

/*
 * Return the age of an employee.
 */

#undef __FUNC__
#define __FUNC__ "impl_objarg_Employee_getAge"

int32_t
impl_objarg_Employee_getAge(
  /* in */ objarg_Employee self)
{
#line 194 "../../../../babel/regression/objarg/libC/objarg_Employee_Impl.c"
  /* DO-NOT-DELETE splicer.begin(objarg.Employee.getAge) */
  struct objarg_Employee__data *dptr = 
    objarg_Employee__get_data(self);
  return dptr ? dptr->d_age : 0;
  /* DO-NOT-DELETE splicer.end(objarg.Employee.getAge) */
#line 216 "objarg_Employee_Impl.c"
}

/*
 * Set an employee's salary.
 */

#undef __FUNC__
#define __FUNC__ "impl_objarg_Employee_setSalary"

void
impl_objarg_Employee_setSalary(
  /* in */ objarg_Employee self,
  /* in */ float salary)
{
#line 213 "../../../../babel/regression/objarg/libC/objarg_Employee_Impl.c"
  /* DO-NOT-DELETE splicer.begin(objarg.Employee.setSalary) */
  struct objarg_Employee__data *dptr = 
    objarg_Employee__get_data(self);
  if (dptr) {
    dptr->d_salary = salary;
  }
  /* DO-NOT-DELETE splicer.end(objarg.Employee.setSalary) */
#line 239 "objarg_Employee_Impl.c"
}

/*
 * Return an employee's salary.
 */

#undef __FUNC__
#define __FUNC__ "impl_objarg_Employee_getSalary"

float
impl_objarg_Employee_getSalary(
  /* in */ objarg_Employee self)
{
#line 233 "../../../../babel/regression/objarg/libC/objarg_Employee_Impl.c"
  /* DO-NOT-DELETE splicer.begin(objarg.Employee.getSalary) */
  struct objarg_Employee__data *dptr = 
    objarg_Employee__get_data(self);
  return dptr ? dptr->d_salary : 0;
  /* DO-NOT-DELETE splicer.end(objarg.Employee.getSalary) */
#line 259 "objarg_Employee_Impl.c"
}

/*
 * Set an employee's marital status.
 */

#undef __FUNC__
#define __FUNC__ "impl_objarg_Employee_setStatus"

void
impl_objarg_Employee_setStatus(
  /* in */ objarg_Employee self,
  /* in */ char status)
{
#line 252 "../../../../babel/regression/objarg/libC/objarg_Employee_Impl.c"
  /* DO-NOT-DELETE splicer.begin(objarg.Employee.setStatus) */
  struct objarg_Employee__data *dptr = 
    objarg_Employee__get_data(self);
  if (dptr) {
    dptr->d_status = status;
  }
  /* DO-NOT-DELETE splicer.end(objarg.Employee.setStatus) */
#line 282 "objarg_Employee_Impl.c"
}

/*
 * Return an employee's marital status.
 */

#undef __FUNC__
#define __FUNC__ "impl_objarg_Employee_getStatus"

char
impl_objarg_Employee_getStatus(
  /* in */ objarg_Employee self)
{
#line 272 "../../../../babel/regression/objarg/libC/objarg_Employee_Impl.c"
  /* DO-NOT-DELETE splicer.begin(objarg.Employee.getStatus) */
  struct objarg_Employee__data *dptr = 
    objarg_Employee__get_data(self);
  return dptr ? dptr->d_status : '\0';
  /* DO-NOT-DELETE splicer.end(objarg.Employee.getStatus) */
#line 302 "objarg_Employee_Impl.c"
}
