// 
// File:          sort_SortTest_Impl.cc
// Symbol:        sort.SortTest-v0.1
// Symbol Type:   class
// Babel Version: 0.10.2
// Description:   Server-side implementation for sort.SortTest
// 
// WARNING: Automatically generated; only changes within splicers preserved
// 
// babel-version = 0.10.2
// 
#include "sort_SortTest_Impl.hh"

#line 14 "../../../../babel/regression/sort/libCxx/sort_SortTest_Impl.cc"
// DO-NOT-DELETE splicer.begin(sort.SortTest._includes)
#include <stdlib.h>
#include <sstream>
#include "sort_CompInt.hh"
#include "sort_IntegerContainer.hh"
#include "synch_RegOut.hh"

static const int32_t s_testSizes[] = {
  0,
  1,
  2,
  3,
  4,
  7,
  10,
  51,
  100,
  -1
};

static bool
notSorted(sort::Container  &cont,
          sort::Comparator &comp)
{
  const int32_t length = cont.getLength();
  for(int32_t i = 1 ; i < length ; ++i ){
    if (cont.compare(i-1, i, comp) > 0) return true;
  }
  return false;
}

static void
sortAndReport(sort::SortingAlgorithm &alg,
	      sort::Container        &cont,
	      sort::Comparator       &comp, 
	      bool                   &result)
{
  sort::Counter swpCnt;
  sort::Counter cmpCnt;
  alg.reset();
  alg.sort(cont, comp);
  swpCnt = alg.getSwapCounter();
  cmpCnt = alg.getCompareCounter();
  std::ostringstream buf;
  buf << "compares (" << cmpCnt.getCount() << ") swaps ("
	    << swpCnt.getCount() << ")";
  synch::RegOut::getInstance().writeComment(buf.str());
  if (notSorted(cont, comp)) {
    synch::RegOut::getInstance().writeComment("sort failed!!");
    result = false;
  }
}
// DO-NOT-DELETE splicer.end(sort.SortTest._includes)
#line 68 "sort_SortTest_Impl.cc"

// user-defined constructor.
void sort::SortTest_impl::_ctor() {
#line 70 "../../../../babel/regression/sort/libCxx/sort_SortTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.SortTest._ctor)
  // add construction details here
  // DO-NOT-DELETE splicer.end(sort.SortTest._ctor)
#line 76 "sort_SortTest_Impl.cc"
}

// user-defined destructor.
void sort::SortTest_impl::_dtor() {
#line 77 "../../../../babel/regression/sort/libCxx/sort_SortTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.SortTest._dtor)
  // add destruction details here
  // DO-NOT-DELETE splicer.end(sort.SortTest._dtor)
#line 85 "sort_SortTest_Impl.cc"
}

// static class initializer.
void sort::SortTest_impl::_load() {
#line 84 "../../../../babel/regression/sort/libCxx/sort_SortTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.SortTest._load)
  // guaranteed to be called at most once before any other method in this class
  // DO-NOT-DELETE splicer.end(sort.SortTest._load)
#line 94 "sort_SortTest_Impl.cc"
}

// user-defined static methods:
/**
 * Perform the array stress test.
 * 
 * Return true if all the algorithms work okay.
 */
bool
sort::SortTest_impl::stressTest (
  /* in */ ::sidl::array< ::sort::SortingAlgorithm> algs ) 
throw () 
{
#line 100 "../../../../babel/regression/sort/libCxx/sort_SortTest_Impl.cc"
  // DO-NOT-DELETE splicer.begin(sort.SortTest.stressTest)
  bool result = false;
  if (algs._not_nil()) {
    const int32_t lower = algs.lower(0);
    const int32_t upper = algs.upper(0);
    int32_t i,j;
    result = true;
    for(i = lower; i <= upper; ++i) {
      sort::SortingAlgorithm alg = algs.get(i);
      if (alg._not_nil()) {
        sort::IntegerContainer data = sort::IntegerContainer::_create();
        sort::Container cont = data;
	sort::CompInt intcomp = sort::CompInt::_create();
        sort::Comparator comp = intcomp;
        std::string name = alg.getName();
        j = 0;
	std::ostringstream buf;
	buf <<"****ALGORITHM IS " << name << "****";
	synch::RegOut::getInstance().writeComment(buf.str());
        while (s_testSizes[j] >= 0) {
	  synch::RegOut tracker = synch::RegOut::getInstance();
	  std::ostringstream buf2;
	  intcomp.setSortIncreasing(true);
	  buf2 << "DATA SIZE " << s_testSizes[j] << '\n';
	  tracker.writeComment(buf2.str());
	  data.setLength(s_testSizes[j]);
	  sortAndReport(alg, cont, comp, result);
	  tracker.writeComment("pre-sorted list");
	  sortAndReport(alg, cont, comp, result);
	  tracker.writeComment("reverse sorted list");
          intcomp.setSortIncreasing(false);
	  sortAndReport(alg, cont, comp, result);
          ++j;
        }
      }
      else{
        result = false;
      }
    }
  }
  return result;
  // DO-NOT-DELETE splicer.end(sort.SortTest.stressTest)
#line 151 "sort_SortTest_Impl.cc"
}


// user-defined non-static methods: (none)

#line 147 "../../../../babel/regression/sort/libCxx/sort_SortTest_Impl.cc"
// DO-NOT-DELETE splicer.begin(sort.SortTest._misc)
// Put miscellaneous code here
// DO-NOT-DELETE splicer.end(sort.SortTest._misc)
#line 161 "sort_SortTest_Impl.cc"

