import java.io.*;
import java.net.*;
import java.util.*;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * The <code>ExampleStatefulTestCase</code> is an example
 * stateful <code>TestCase</code>. 
 *
 * @author <a href="mailto:mike@clarkware.com">Mike Clark</a>
 * @author <a href="http://www.clarkware.com">Clarkware Consulting, Inc.</a>
 *
 * @see junit.framework.TestCase
 */

public class ExampleStatefulTestCase extends TestCase {

	private boolean _flag; 
	private int _data; 

	/**
	 * Constructs an <code>ExampleStatefulTestCase</code>
	 * with the specified name.
	 *
	 * @param name Test name.
	 */
    public ExampleStatefulTestCase(String name) {
        super(name);
    }

	/**
	 * Sets up the test fixture.
	 */
	protected void setUp() {
		_flag = true;
		_data = 1;
	}

	/**
	 * Tears down the test fixture.
	 */
	protected void tearDown() {
		_flag = false;
		_data = 0;
	}

	public void testState() throws Exception {
		assertEquals(true, _flag);
		Thread.yield();
		assertEquals(1, _data);
	}

	/**
	 * Assembles and returns a test suite for all
	 * the test methods of this class.
	 *
	 * @return A non-null <code>Test</code> instance.
	 */
	public static Test suite() {
		TestSuite suite = new TestSuite(ExampleStatefulTestCase.class);
		return suite;
	}

	/**
	 * Main.
	 */
	public static void main(String args[]) {
		String[] testCaseName = {ExampleStatefulTestCase.class.getName()};
		//junit.textui.TestRunner.main(testCaseName);
		//junit.ui.TestRunner.main(testCaseName);
		junit.swingui.TestRunner.main(testCaseName);
	}
}
