/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.functions.Count;
import com.icl.saxon.om.NodeEnumeration;

public class Sum
extends Function {
    public String getName() {
        return "sum";
    }

    public int getDataType() {
        return 2;
    }

    public Expression simplify() throws XPathException {
        this.checkArgumentCount(1, 1);
        this.argument[0] = this.argument[0].simplify();
        if (this.argument[0] instanceof Value) {
            return this.evaluate(null);
        }
        return this;
    }

    public double evaluateAsNumber(Context context) throws XPathException {
        NodeEnumeration nodeEnumeration = this.argument[0].enumerate(context, false);
        return Sum.total(nodeEnumeration);
    }

    public Value evaluate(Context context) throws XPathException {
        return new NumericValue(this.evaluateAsNumber(context));
    }

    public int getDependencies() {
        return this.argument[0].getDependencies();
    }

    public Expression reduce(int n, Context context) throws XPathException {
        Count count = new Count();
        count.addArgument(this.argument[0].reduce(n, context));
        count.setStaticContext(this.getStaticContext());
        return count.simplify();
    }

    private static double total(NodeEnumeration nodeEnumeration) throws XPathException {
        double d = 0.0;
        while (nodeEnumeration.hasMoreElements()) {
            String string = nodeEnumeration.nextElement().getStringValue();
            d += Value.stringToNumber(string);
        }
        return d;
    }
}

