/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.sql;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.sql.SQLColumn;
import com.icl.saxon.style.StyleElement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

public class SQLInsert
extends StyleElement {
    String table;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainTemplateBody() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        this.table = this.getAttribute("table");
        if (this.table == null) {
            this.reportAbsence("table");
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
    }

    public void process(Context context) throws TransformerException {
        DocumentInfo documentInfo;
        Controller controller = context.getController();
        Connection connection = (Connection)controller.getUserData(documentInfo = context.getCurrentNodeInfo().getDocumentRoot(), "sql:connection");
        if (connection == null) {
            throw this.styleError("No SQL connection has been established");
        }
        PreparedStatement preparedStatement = (PreparedStatement)controller.getUserData(this, "sql:statement");
        try {
            Object object;
            if (preparedStatement == null) {
                object = new StringBuffer();
                ((StringBuffer)object).append("INSERT INTO " + this.table + " (");
                Node node = this.getFirstChild();
                int n = 0;
                while (node != null) {
                    if (node instanceof SQLColumn) {
                        if (n++ > 0) {
                            ((StringBuffer)object).append(',');
                        }
                        String string = ((SQLColumn)node).getColumnName();
                        ((StringBuffer)object).append(string);
                    }
                    node = node.getNextSibling();
                }
                ((StringBuffer)object).append(") VALUES (");
                int n2 = 0;
                while (n2 < n) {
                    if (n2 != 0) {
                        ((StringBuffer)object).append(',');
                    }
                    ((StringBuffer)object).append('?');
                    ++n2;
                }
                ((StringBuffer)object).append(')');
                preparedStatement = connection.prepareStatement(((StringBuffer)object).toString());
                controller.setUserData(this, "sql:statement", preparedStatement);
            }
            object = this.getFirstChild();
            int n = 1;
            while (object != null) {
                if (object instanceof SQLColumn) {
                    Value value = ((SQLColumn)object).getColumnValue(context);
                    String string = value.asString();
                    if (string.length() == 1) {
                        string = string + " ";
                    }
                    preparedStatement.setObject(n++, string);
                }
                object = object.getNextSibling();
            }
            int n3 = preparedStatement.executeUpdate();
            connection.commit();
        }
        catch (SQLException sQLException) {
            throw this.styleError("(SQL) " + sQLException.getMessage());
        }
    }
}

