<?xml version="1.0"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text" indent="yes" media-type="text/plain"/>
<xsl:strip-space elements="*"/>

  <xsl:template match="/">
    <xsl:apply-templates select="s1/s2"/>
  </xsl:template>
  
  <xsl:template match="s2"><xsl:text>
--</xsl:text><xsl:value-of select="normalize-space(@title)"/><xsl:text>--
    </xsl:text>
  <xsl:apply-templates select="s3|s3/s4"/> 
  </xsl:template>
  
  <xsl:template match="s3|s4"><xsl:text>
--</xsl:text><xsl:value-of select="normalize-space(@title)"/><xsl:text>--
    </xsl:text>
    <xsl:apply-templates select="p/text()[position()=1 and not(parent::code)]|ul/li/text()[position()=1 and not(parent::link)]|ol/li/text()[1]"/>  
  </xsl:template> 
  
  <xsl:template match="p/text()">
    <xsl:if test="contains(., '. ')"><xsl:text>
</xsl:text><xsl:value-of select="normalize-space(concat(substring-before(., '. '),'.'))"/><xsl:text>
    </xsl:text></xsl:if>
    <xsl:if test="not(contains(., '. '))"><xsl:text>
</xsl:text><xsl:value-of select="normalize-space(.)"/><xsl:text>
    </xsl:text></xsl:if>
  </xsl:template>
  
  <xsl:template match="li/text()">
    <xsl:if test="contains(., '. ')"><xsl:text>
* </xsl:text><xsl:value-of select="normalize-space(concat(substring-before(., '. '),'.'))"/><xsl:text>
    </xsl:text></xsl:if>
    <xsl:if test="not(contains(., '. '))"><xsl:text>
* </xsl:text><xsl:value-of select="normalize-space(.)"/><xsl:text>
    </xsl:text></xsl:if>
  </xsl:template>  
 
</xsl:stylesheet>