/* 
 *   Creation Date: <1998-10-17 22:21:08 samuel>
 *   Time-stamp: <2001/04/19 23:56:20 samuel>
 *   
 *	<main.c>
 *	
 *	Utility to decrease the use count of the MOL 
 *	kernel module (if MOL has crashed etc. and
 *	we wan't to install a newer MOL-module)
 *   
 *   Copyright (C) 1998-2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>

#include "kernel_vars.h"
#include "mac_registers.h"
#define fast_multiplexer multiplexer
#include "wrapper.h"

_syscall5( int, multiplexer, int, selector, int, arg1, int, arg2, int, arg3, int, arg4 );

int g_session_id = 0;		/* FIXME */


/**************************************************************
*  main
*    
**************************************************************/

int 
main( int argc, char **argv)
{
	ulong 			*p, base;
	int 			fd, i;
	struct kernel_vars	kvars;
	
	
	if( getuid()!=0 ){
		fprintf( stderr,"Must be run as root!\n");
		exit(1);
	}
	base = (ulong)_get_kvarbase();
	if( base >= 0xc0000000 )		/* -> phys */
		base -= 0xc0000000;
	_kernel_cleanup();
	return 0;
}

