#define FS	11025
#define FSPACE	1000
#define FMARK	1850
#define DR	42

#define BAUD_LIST {42,50,75,120,150,240,300,480,600,960,1200,0}

typedef struct {
        int phs;      	/* bit phase / sample (2_PI = 65536) */
        int nbit;       /* Nmero de bits de datos (5,7,8) */
        int nstop;	/* Nmero de bits de stop 1,2 (serial.c)  */
	int nstop05;	/* 0.5 extra STOP bits */
        int parity;	/* Bit de paridad 0=nada 1=Par 2=Impar */
        float spacef;	/* Space Frequency */
        float markf;	/* Mark Frequency */
        int dr;		/* Data Rate */
} fsk_data;

extern fsk_data *fskdp;

#define NDBUF 16384

typedef struct {
	int mode;		/* Display mode */
	int inp;		/* Input buffer pointer */
	int outp;		/* Output buffer pointer */
	float in[NDBUF];	/* Buffers */
	float out[NDBUF];
} disp_data;

extern disp_data *disdp;

/*----------- audio.c ----------*/

void init_audio();
float get_audio_sample();

/*----------- dsp.c ------------*/

void set_filters(float f0, float f1, float dr);
int demodulator();

/*----------- serie.c --------*/

int serie();

/*----------- dpll.c ---------*/

int get_bit_raw();
extern unsigned short bit_phase;

/*---------- baudot.c ----------*/

int baudot(unsigned char data);

/*---------- FORMS ------------*/

void form_main();

/*---------- GRAPH ------------*/

void graph_main();
extern int redisp;

