#ifndef __UNODE_H__
#define __UNODE_H__

/* --- unode information --- */

#include <netinet/in.h>

/* this structure is attached to each existing entry of the berkeley database */
typedef struct
{
   time_t resolv_creation_date;     /* each resolved named has a date of solving allowing dynamic host IP to be refreshed */
   struct sockaddr_in dest_addr;    /* it is a ready to use address, including port and addresse type */
   unsigned char entry_enabled;     /* ==0, this entry is disabled, ==1, entry enabled */
   unsigned char dynamic_ip;        /* ==0, this entry is a static hostname/hostip association, ==1, the ip of this host is dynamic */
   char comment[93];                /* a comment (C-string format) */
} UNODE_DATA;

#define MAX_IP_VALIDITY (15*60)     /* 15 minutes */
 
#endif
