/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * ls_cache_clist.c: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: ls_cache_clist.c,v 1.6 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <dirent.h>
#include <gnome.h>

#include "gtkcellrenderertextx.h"
#include "misc_gtk.h"
#include "ls_cache_clist.h"
#include "main.h"
#include "gui_define.h"
#include "macro.h"
#include "init_fnc.h"
#include "ls_cache.h"
#include "global_user.h"

/****************************************************************************************/
/* load the 'cached_user_list_clist' with the content of the directory ~/.dctc/ls_cache */
/******************************************************************************************/
/* input: if the flag is set to FALSE and the list already contains line, nothing is done */
/******************************************************************************************/
void reload_ls_cache_clist(int even_when_not_empty)
{
	GtkWidget *w;
	GtkTreeModel *gtm;
	GtkListStore *gls;
	GtkTreeIter iter;
	gchar *ls_path;
	DIR *dir;

	w=get_widget_by_widget_name(main_window,"cached_user_list_clist");
	if(w==NULL)
		return;

	gls=GTK_LIST_STORE(gtm=gtk_tree_view_get_model(GTK_TREE_VIEW(w)));

	if((even_when_not_empty==FALSE)&&(gtk_tree_model_is_not_empty(gtm)))
		return;

	gu_unref_model(gtm);
	gtk_list_store_clear(gls);

	ls_path=g_strconcat(dctc_main_dir->str,"/ls_cache",NULL);
	dir=opendir(ls_path);
	if(dir!=NULL)
	{
		GString *full_path;
		struct dirent *obj;
		LS_CACHE_HEADER lsch;

		full_path=g_string_new("");
		while((obj=readdir(dir))!=NULL)
		{
			if(obj->d_name[0]=='.')
				continue;

			g_string_sprintf(full_path,"%s/%s",ls_path,obj->d_name);

			if(get_ls_file_header(full_path->str,&lsch)==0)
			{
				char buf[128];
				char dl_time[256];
				GLOB_USER *gu;

				strftime(dl_time,sizeof(dl_time)-1,"%c",localtime(&(lsch.retrieve_time)));
#ifndef NO_PRINTF_LOCALE
				sprintf(buf,"%'llu", lsch.share_size);		/* NO_PRINTF_LOCAL support added */
#else
				sprintf(buf,"%llu", lsch.share_size);
#endif
				gu=gu_add_user(obj->d_name,TRUE,NULL);
				gtk_list_store_append (gls, &iter);
				gu_ref_from_iter(gu,gtm,&iter);

				gtk_list_store_set(gls,&iter, CULC_SIZE_COL,buf,
														CULC_DATE_COL, dl_time,
														CULC_SIZE_AS_VAL,(guint64)lsch.share_size,
														CULC_USER_POINTER,gu,
														CULC_DL_DATE,(guint64)lsch.retrieve_time,
														-1);
			}
		}
		g_string_free(full_path,TRUE);
		closedir(dir);
	}
	g_free(ls_path);
}

/* ------------------------------------------------------------------------------------------------------------- */
/************************************************/
/* update user information using GLOB_USER data */
/************************************************/
static void cached_user_list_clist_user_info_update_row(GtkTreeModel *gtm, GtkTreePath *gtp, GtkTreeIter *gti, gpointer user_data)
{
	GLOB_USER *gu;

	/* get GLOB_USER entry to use */
	gtk_tree_model_get(gtm,gti,CULC_USER_POINTER,&gu,-1);

	/* block the update signal on this function */
	g_signal_handlers_block_matched (G_OBJECT(gtm),G_SIGNAL_MATCH_FUNC,0,0,NULL,cached_user_list_clist_user_info_update_row,NULL);

	/* update user info */
	gtk_list_store_set(GTK_LIST_STORE(gtm),gti,
												CULC_NICK_COL,gu->fmt_nick,
												CULC_LINE_BACKGROUND,gu->back_color,
												CULC_LINE_FOREGROUND,gu->front_color,
												-1);

	/* unblock the update signal on this function */
	g_signal_handlers_unblock_matched (G_OBJECT(gtm),G_SIGNAL_MATCH_FUNC,0,0,NULL,cached_user_list_clist_user_info_update_row,NULL);
}

/********************************************************/
/* build modele and view for the cached user list clist */
/********************************************************/
void bmav4_cached_user_list_clist(void)
{
	GtkListStore *model;
	GtkWidget *view;
	GtkCellRenderer *rend;
	GtkTreeSelection *slc;

	model=gtk_list_store_new(NB_CULC_COL,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,
													G_TYPE_STRING,G_TYPE_STRING,
													G_TYPE_UINT64,G_TYPE_POINTER,G_TYPE_UINT64);
	g_signal_connect_after(G_OBJECT(model),"row-changed",G_CALLBACK(cached_user_list_clist_user_info_update_row),NULL);

	view=get_widget_by_widget_name(main_window,"cached_user_list_clist");

	gtk_tree_view_set_model(GTK_TREE_VIEW(view),GTK_TREE_MODEL(model));
	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(view),TRUE);

	slc=gtk_tree_view_get_selection(GTK_TREE_VIEW(view));
	gtk_tree_selection_set_mode(slc,GTK_SELECTION_MULTIPLE);
	
	/* the first column of the view display the first column of the model, and so on. The 4th entry of the model is not displayed */
	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),CULC_NICK_COL,_("Nick"),rend,"text",CULC_NICK_COL,"background",CULC_LINE_BACKGROUND,"foreground",CULC_LINE_FOREGROUND,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	g_object_set(rend,"xalign",(gfloat)1.0,NULL);
	MY_RS2_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),CULC_SIZE_COL,CULC_SIZE_AS_VAL,_("Share size"),rend,"text",CULC_SIZE_COL,"background",CULC_LINE_BACKGROUND,"foreground",CULC_LINE_FOREGROUND,NULL);

	rend=gtk_cell_renderer_textx_new();
	g_object_set(rend,"rowspacing",TRUE,NULL);
	MY_RS2_gtk_tree_view_insert_column_with_attributes(GTK_TREE_VIEW(view),CULC_DATE_COL,CULC_DL_DATE,_("Download date"),rend,"text",CULC_DATE_COL,"background",CULC_LINE_BACKGROUND,"foreground",CULC_LINE_FOREGROUND,NULL);

	/* The view now holds a reference.  We can get rid of our own
	 * reference */
	g_object_unref (G_OBJECT (model));
}

