/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * xpm_draw.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: xpm_draw.h,v 1.7 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifndef __XPM_DRAW_H__
#define __XPM_DRAW_H__

/* the following functions perform drawing on a XPM image */

/********************************************/
/* clear the given XPM with the given color */
/********************************************/
void fill_xpm(char *xpm[], unsigned int xpm_width, unsigned int xpm_height, int array_offset_to_pix, int color_char);

/**************************/
/* draw a horizontal line */
/**************************/
void hline_xpm(char *xpm[], unsigned int xpm_width, unsigned int xpm_height, int array_offset_to_pix, int color_char, int y, int x1, int x2);

/************************/
/* draw a vertical line */
/************************/
void vline_xpm(char *xpm[], unsigned int xpm_width, unsigned int xpm_height, int array_offset_to_pix, int color_char, int x, int y1, int y2);

/**************/
/* draw a box */
/**************/
void box_xpm(char **xpm, unsigned int xpm_width, unsigned int xpm_height, int array_offset_to_pix, int color_char, int x1, int x2, int y1, int y2);

/*********************/
/* draw a cyclic box */
/*********************/
void cyclic_box_xpm(char **xpm, unsigned int xpm_width, unsigned int xpm_height, int array_offset_to_pix, int color_char, float min_range, float max_range, int x1,int x2, int y1, int y2);


#endif
