#!/bin/bash

set -e
set -v
set -x

	tar -jxvf ../debian-tutorial.tar.bz2
	cp debian-tutorial.tex debian-tutorial.tex.save

	patch < ../patch-update

	latex debian-tutorial.tex
	latex debian-tutorial.tex
	latex debian-tutorial.tex
	makeindex debian-tutorial.idx
	latex debian-tutorial.tex
	latex debian-tutorial.tex
	latex debian-tutorial.tex
	dvips -o debian-guide.ps debian-tutorial.dvi

	patch < ../patch-html

# Now rerun latex to get the aux files right
	latex debian-tutorial.tex
	latex debian-tutorial.tex


#-show_section_numbers

	latex2html -html_version 4.0,table,frame -split 4 \
		-t 'Debian GNU/Linux: Guide to Installation and Usage' \
		-toc_stars -local_icons \
		-address "John Goerzen / Ossama Othman" \
		debian-tutorial.tex

set +e
	rm debian-tutorial/{*.pl,*.tex,*.log,WARNINGS}
	rmdir ../$DOCROOT/html/frames
set -e
	mv debian-tutorial ../$DOCROOT/html/frames

	latex2html -html_version 4.0,table -split 4 \
		-t 'Debian GNU/Linux: Guide to Installation and Usage' \
		-toc_stars -local_icons \
		-address "John Goerzen / Ossama Othman" \
		debian-tutorial.tex

set +e
	rm debian-tutorial/{*.pl,*.tex,*.log,WARNINGS}; true
	rmdir ../$DOCROOT/html/noframes
set -e
	mv debian-tutorial ../$DOCROOT/html/noframes
