/**
 * Parses input using a context-free grammar.
 * @author Shaun Jackman <sdj@sfu.ca>
 * @copyright Copyright 2004 Shaun Jackman
 */


#include <stdio.h>
#include "cfg.h"
#include "parsetree.h"
#include "pda.h"
#include "util.h"


/** Name of this program. */
const char* program = "parse";


/** Parses standard input using the context-free grammar specified on
 * the command line. */
int
main( int argc, char* argv[])
{
	PDA pda;
	assumex( argc > 2, "missing file argument");
	read_cfg( &pda.g, open_file( argv[1]));
	read_pda( &pda, open_file( argv[2]));
	if( argc > 3)
		read_precedence( &pda.g, open_file( argv[3]));
	print_parse_tree( parse( &pda, stdin), &pda.g.symbols);
	putchar( '\n');
	return 0;
}
