/* staffops.c
 * functions dealing with whole staffs

 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999, 2000, 2001 Matthew Hiller */

#include "chordops.h"
#include "contexts.h"
#include "datastructures.h"
#include "dialogs.h"
#include "measureops.h"
#include "moveviewport.h"
#include "objops.h"
#include "processstaffname.h"
#include "staffops.h"
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

objnode *
firstobjnode (measurenode * mnode)
{
  return mnode->data;
}

objnode *
lastobjnode (measurenode * mnode)
{
  return g_list_last (mnode->data);
}

measurenode *
firstmeasurenode (staffnode * thestaff)
{
  return ((staff *) thestaff->data)->measures;
}

measurenode *
nth_measure_node_in_staff (staffnode * thestaff, gint n)
{
  return g_list_nth (((staff *) thestaff->data)->measures, n);
}

objnode *
firstobjnodeinstaff (staffnode * thestaff)
{
  return firstobjnode (firstmeasurenode (thestaff));
}

/* Reset si->currentprimarystaff based on current value of
 * si->currentstaff */

void
setcurrentprimarystaff (struct scoreinfo *si)
{
  for (si->currentprimarystaff = si->currentstaff;
       ((staff *) si->currentprimarystaff->data)->voicenumber != 1;
       si->currentprimarystaff = si->currentprimarystaff->prev)
    ;
}

static void
copy_staff_bits (staff * src, staff * dest)
{
  dest->sclef = src->sclef;
  dest->skey = src->skey;
  dest->skey_isminor = src->skey_isminor;
  memcpy (dest->skeyaccs, src->skeyaccs, SEVENGINTS);
  dest->stime1 = src->stime1;
  dest->stime2 = src->stime2;
  dest->no_of_lines = 5;
  dest->transposition = 0;
  dest->pos_in_half_lines = 0;
  dest->space_above = 0;
  dest->space_below = 0;
}

void
newstaff (gpointer callback_data, guint callback_action, GtkWidget * widget)
{
  struct scoreinfo *si = callback_data;
  staff *thestaffstruct = g_malloc (sizeof (staff));	/* What gets added */
  measurenode *themeasures = NULL;	/* Initial set of measures in staff */
  gint numstaffs = g_list_length (si->thescore);
  gint i, n, addat=1;

  if (numstaffs == 0)
    callback_action = INITIAL;
  if (callback_action == INITIAL)
    {
      n = 1;

      thestaffstruct->sclef = TREBLE;
      thestaffstruct->skey = 0;
      thestaffstruct->skey_isminor = FALSE;
      memset (thestaffstruct->skeyaccs, 0, SEVENGINTS);
      thestaffstruct->stime1 = 4;
      thestaffstruct->stime2 = 4;

      thestaffstruct->no_of_lines = 5;
      thestaffstruct->transposition = 0;
      thestaffstruct->pos_in_half_lines = 0;
      thestaffstruct->space_above = 0;
      thestaffstruct->space_below = 0;

      si->measurewidths = g_list_append (si->measurewidths,
					 GINT_TO_POINTER (si->measurewidth));
    }
  else
    {
      n = g_list_length (firstmeasurenode (si->currentstaff));
      copy_staff_bits (si->currentstaff->data, thestaffstruct);
    }

  if (callback_action == NEWVOICE)
    {
      thestaffstruct->voicenumber = 2;
    }
  else
    {
      thestaffstruct->voicenumber = 1;
    }

  for (i = 0; i < n; i++)
    themeasures = g_list_append (themeasures, NULL);

  if (callback_action == INITIAL || callback_action == ADDFROMLOAD)
    {
      si->currentmeasure = themeasures;
    }

  /* Now fix the stuff that shouldn't be directly copied from
   * the current staff, if this staff was non-initial and that
   * was done to begin with */

  thestaffstruct->measures = themeasures;
  thestaffstruct->denemo_name = g_string_new (NULL);
  thestaffstruct->lily_name = g_string_new (NULL);
  if (callback_action == NEWVOICE)
    /* Fix me to something more reasonable and less prone to collision
     * with other staff names */
    g_string_sprintf (thestaffstruct->denemo_name, _("non primary voice"));
  else
    g_string_sprintf (thestaffstruct->denemo_name, _("staff %d"),
		      numstaffs + 1);
  set_lily_name (thestaffstruct->denemo_name, thestaffstruct->lily_name);

  thestaffstruct->midi_instrument = g_string_new ("acoustic grand");

  /* In what position should the scrollbar be added?  */
  switch (callback_action)
    {
    case INITIAL:
    case LAST:
    case ADDFROMLOAD:
      addat = numstaffs + 1;
      break;
    case BEFORE:
      addat = si->currentstaffnum;
      si->currentstaffnum++;
      break;
    case AFTER:
    case NEWVOICE:
      addat = si->currentstaffnum + 1;
      break;
    case FIRST:
      addat = 1;
      si->currentstaffnum++;
      break;
    }

  si->thescore = g_list_insert (si->thescore, thestaffstruct, addat - 1);
  si->currentstaff = g_list_nth (si->thescore, si->currentstaffnum - 1);
  setcurrentprimarystaff (si);
  find_leftmost_staffcontext (thestaffstruct, si);

  if (callback_action != INITIAL && callback_action != ADDFROMLOAD)
    {
      staff_properties_change (si, addat, NULL);
      set_bottom_staff (si);
      if (callback_action == BEFORE || callback_action == FIRST)
	move_viewport_down (si);
      else
	update_vscrollbar (si);
      gtk_widget_draw (si->scorearea, NULL);
    }
}

gboolean removestaff (struct scoreinfo *si, gint pos, gint numstaffs)
{
  /* The second and third parameters are mostly ignored in this version
   * of the function */
  staff *curstaffstruct = si->currentstaff->data;
  gboolean isprimary = (curstaffstruct->voicenumber == 1);

  g_list_foreach (curstaffstruct->measures, freeobjlist, NULL);
  g_list_free (curstaffstruct->measures);
  g_string_free (curstaffstruct->denemo_name, FALSE);
  g_string_free (curstaffstruct->lily_name, FALSE);
  g_string_free (curstaffstruct->midi_instrument, FALSE);
  g_free (curstaffstruct);
  si->thescore = g_list_remove_link (si->thescore, si->currentstaff);
  g_list_free_1 (si->currentstaff);
  if (pos == g_list_length (si->thescore))
    si->currentstaffnum--;
  si->currentstaff = g_list_nth (si->thescore, si->currentstaffnum - 1);

  /* Give an appropriate return value */

  if (si->currentstaff)
    {
      /* O.K.; set si->currentprimarystaff correctly */
      if (isprimary)
	{
	  ((staff *) si->currentstaff->data)->voicenumber = 1;
	  si->currentprimarystaff = si->currentstaff;
	}
      else
	setcurrentprimarystaff (si);
      return TRUE;
    }
  else
    {
      si->currentprimarystaff = NULL;
      return FALSE;
    }
}

void
beamsandstemdirswholestaff (staff * thestaff)
{
  measurenode *curmeasure;
  gint clef, time1, time2, stem_directive;

  clef = thestaff->sclef;
  time1 = thestaff->stime1;
  time2 = thestaff->stime2;
  stem_directive = STEMBOTH;

  for (curmeasure = thestaff->measures; curmeasure;
       curmeasure = curmeasure->next)
    {
      calculatebeamsandstemdirs (curmeasure->data, &clef, &time1,
				 &time2, &stem_directive);
    }
}

void
showwhichaccidentalswholestaff (staff * thestaff)
{
  gint feed[7];
  gint feednum;
  measurenode *curmeasure;

  memcpy (feed, thestaff->skeyaccs, SEVENGINTS);
  feednum = thestaff->skey;
  for (curmeasure = thestaff->measures; curmeasure;
       curmeasure = curmeasure->next)
    feednum = showwhichaccidentals (curmeasure->data, feednum, feed);
}

void
fixnoteheights (staff * thestaff)
{
  gint clef = thestaff->sclef;
  gint time1 = thestaff->stime1;
  gint time2 = thestaff->stime2;
  gint initialclef;
  measurenode *curmeasure;
  objnode *curobj;
  mudelaobject *theobj;

  for (curmeasure = thestaff->measures; curmeasure;
       curmeasure = curmeasure->next)
    {
      initialclef = clef;
      for (curobj = curmeasure->data; curobj; curobj = curobj->next)
	{
	  theobj = curobj->data;
	  switch (theobj->type)
	    {
	    case CHORD:
	      newclefify (theobj, clef);
	      break;
	    case TIMESIG:
	      time1 = theobj->u.timeval.time1;
	      time2 = theobj->u.timeval.time2;
	      break;
	    case CLEF:
	      clef = theobj->u.clefval.type;
	      break;
	    default:
	      break;
	    }
	}			/* End for */
    }				/* End for */
  beamsandstemdirswholestaff (thestaff);
}
