/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/unittest/test_system/test_data_source.ts.hpp
 *
 * @brief [LEVEL: beta] compliance test for @ref
 * diagnostics::unittest::Test_Data_Source
 *
 * $Id: test_data_source.ts.hpp,v 1.5 2005/06/23 09:54:26 esdentem Exp $
 * 
 * @author Christian Schallhart
 */

#include <diagnostics/frame/namespace.hpp>
#include <diagnostics/unittest/namespace.hpp>
#include <diagnostics/unittest/testing_namespaces.hpp>


DIAGNOSTICS_NAMESPACE_BEGIN;
UNITTEST_NAMESPACE_BEGIN;

// used in the interface by reference
// diagnostics/unittest/test_system/test_data_source.hpp
class Test_Data_Source;

// used in the interface by reference
// diagnostics/unittest/test_data.hpp
class Test_Data;

TEST_NAMESPACE_BEGIN;

/**
 * @brief Compliance test for @ref Test_Data_Source 
 */
class Test_Data_Source_Compliance
{
private:
    typedef Test_Data_Source_Compliance Self;
public:
    /**
     * @brief does not take ownership of @a source
     *
     * @pre @a source.is_initialized()==false
     * @pre @a source_init.is_initialized()==true
     * @pre forall A @a source_init.exists_entry(A)==false
     */
    Test_Data_Source_Compliance(Test_Data_Source * const source_init,
				Test_Data_Source * const source);

    Test_Data_Source_Compliance(Self const &);
    Self & operator=(Self const &);

    void operator()(Test_Data & test_data) const;
private:
    Test_Data_Source * m_source_init;
    Test_Data_Source * m_source;
};


TEST_NAMESPACE_END;
UNITTEST_NAMESPACE_END;
DIAGNOSTICS_NAMESPACE_END;
// vim:ts=4:sw=4
