/*
 * Diagnostics - a unified framework for code annotation, logging,
 * program monitoring, and unit-testing.
 *
 * Copyright (C) 2002-2005 Christian Schallhart
 *               2006-2007 model.in.tum.de group
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * @file diagnostics/util/preprocessor.hpp
 *
 * $Id: util.hpp,v 1.5 2005/06/23 09:54:23 esdentem Exp $
 *
 * @author Christian Schallhart
 *
 * @brief [LEVEL: beta] @ref DIAGNOSTICS_BASE_CONCAT and @ref
 * DIAGNOSTICS_BASE_STRINGIZE
 *
 * @test none
 */
#ifndef DIAGNOSTICS__UTIL__PREPROCESSOR__INCLUDE_GUARD
#define DIAGNOSTICS__UTIL__PREPROCESSOR__INCLUDE_GUARD

#define DIAGNOSTICS_INTERNAL_BASE_CONCAT(A,B) A ## B
/**
 * @brief evaluabes @a A and @a B and concats the respective results
 */ 
#define DIAGNOSTICS_BASE_CONCAT(A,B) DIAGNOSTICS_INTERNAL_BASE_CONCAT(A,B)

#define DIAGNOSTICS_INTERNAL_BASE_STRINGIZE(A) #A
/**
 * @brief evaluates @a A and transforms the result into a string
 */ 
#define DIAGNOSTICS_BASE_STRINGIZE(A) DIAGNOSTICS_INTERNAL_BASE_STRINGIZE(A)

#endif

// vim:ts=4:sw=4
