#!/bin/sh

unset ZONE KTAG ALGO DTYPE DIGEST

TTL=172800

export IFS="="
xml2 | while read KEY VAL; do
    case "$KEY" in
	"/TrustAnchor/Zone") ZONE="$VAL";;
	"/TrustAnchor/KeyDigest/KeyTag") KTAG="$VAL";;
	"/TrustAnchor/KeyDigest/Algorithm") ALGO="$VAL";;
	"/TrustAnchor/KeyDigest/DigestType") DTYPE="$VAL";;
	"/TrustAnchor/KeyDigest/Digest")
	    DIGEST="$(echo "$VAL" | tr "[A-Z]" "[a-z]")"
	    if [ -z "$ZONE" -o -z "$KTAG" -o -z "$ALGO" -o -z "$DTYPE" ]; then
		echo "Missing some KeyDigest parameter"
		exit 1
	    fi
	    echo "$ZONE\t$TTL\tIN\tDS\t$KTAG $ALGO $DTYPE $DIGEST"
	    unset KTAG ALGO DTYPE DIGEST
	    ;;
    esac
done
exit 0
