#!/usr/bin/perl -w


$now = localtime;

sub print_header() {
	print INDEX <<EOF;
<html>
<head>
<title>Debian GNU/Linux Italian HOWTO Document Index</title>
</head>

<body BGCOLOR="#FFFFFF">
<center>
<h1>Debian GNU/Linux Italian HOWTO Document Index</h1>
<h1>Indice dei documenti HOWTO in italiano per Debian GNU/Linux</h1>
</center>
<hr>

EOF
}

sub print_footer() {
	print INDEX <<EOF;
<hr>
<address>
<small>
Please send comments to <a href="mailto:borto\@pluto.linux.it">Giovanni Bortolozzo</a>.<br>
This page was created automatically at $now by the script crea-index.
</small>
</address>
</body>
EOF
}


# MAIN
open INDEX,">index.html" || die "Non posso aprire il file\n";
print_header;

opendir DIR,"." || die "Non posso aprire la directory\n";
@files = readdir DIR;

shift(@files); # tolgo il file .
shift(@files); # tolgo il file ..
@files = sort @files;

print INDEX "<table><tr>\n";
print INDEX "<td valign=top><dl>\n";
print INDEX "<h2>Linux HOWTO</h2>\n";
while ($file = shift @files) {
	if ( ($name = $file) =~ s/\.gz//) {
		$name =~ s/-/\ /g;
#		print $file.$name."\n";
		print INDEX "<a href=\"$file\">$name</a><br>\n";
	}
}
print INDEX "</tr></table>\n";
close DIR;

#mini HOWTO
opendir DIR,"./mini" || die "Non posso aprire la directory\n";
@files = readdir DIR;

shift(@files); # tolgo il file .
shift(@files); # tolgo il file ..
@files = sort @files;


print INDEX "<hr>\n<table><tr>\n";
print INDEX "<td valign=top><dl>\n";
print INDEX "<h2>Linux mini-HOWTO</h2>\n";
while ($file = shift @files) {
	if ( ($name = $file) =~ s/\.gz//) {
		$name =~ s/-/\ /g;
#		print $file.$name."\n";
		print INDEX "<a href=\"mini/$file\">$name</a><br>\n";
	}
}
print INDEX "</tr></table>\n";
close DIR;

print_footer;

close INDEX;







