void import_cif (char input[100], int in_line, int Quick, int * Block, int frame_no)

/* routine to extract structural information from a CIF */
{
  FILE *impin;
  char string[100], filename[256], tstring[100];
  int U_pos[6], X_pos[3], Id_pos=0, O_pos=0, Label_pos = 0;
  int i, j, sg;
  int n_items, items;
  static int numblocks = 0;
  static char save_filename[40] = "";

  g_Quick = Quick;
  memset(U_pos, 0, sizeof(U_pos));
  memset(X_pos, 0, sizeof(X_pos));
  if (in_line) {
      Error_Box("Cannot read inline CIF data. Please use the import instruction");
      return;
  }
  (void)sscanf (input, "%s %s", filename, filename);     /* get file name */

  if (!(impin = fopen (filename, "r"))) {
      Error_Box("Cannot Open CIF Import File, Run aborted.");
      return;
  }

  if (strcmp(filename, save_filename)) {
      numblocks = 0;
      strcpy(save_filename, filename);
  }
  
  memset(string,0,100);
  memset(tstring,0,100);

  if (*Block)
      numblocks = *Block;

  if (!numblocks) {
      char dataname[2040] = "";
      for (;;) {
          if (!get_next_token(string, 100, impin))
              break;               /* out on EOF */
          if (!strncmp(string,"data_",5)) {
              char tmp[40],tmp2[10];
              sscanf(string,"%s",tmp);
              sprintf(tmp2," %d. ", ++numblocks);
              strcat(dataname,tmp2);
              strcat(dataname,tmp);
              strcat(dataname,"\n");
          }
      }
      if (numblocks > 1) {
          sprintf(tstring,"This CIF has %d data blocks with labels\n%s.\nPlease enter the number"
              " of the one to use:", numblocks, dataname);
          const char *which = fl_input(tstring ,"1");
          if (!which) return; // Cancel button was pressed 
          strcpy(string,which);	  
          (void)sscanf(string,"%d",&numblocks);
          *Block = numblocks;                    /* return to caller */
      } else {
          *Block = 1;
      }
  }
  if (position_cif(numblocks, impin, "_cell_length_a", string, 1)) {
      Error_Box("Error finding cell (a) in CIF Import File, Run aborted.");
      return;
  }
  get_next_token(string,100,impin);
  (void)sscanf (string, "%f", &drvui->lat_con[0]);
  if (position_cif(numblocks, impin, "_cell_length_b", string, 1)) {
      Error_Box("Error finding cell (b) in CIF Import File, Run aborted.");
      return;
  }
  get_next_token(string,100,impin);
  (void)sscanf (string, "%f", &drvui->lat_con[1]);
  if (position_cif(numblocks, impin, "_cell_length_c", string, 1)) {
      Error_Box("Error finding cell (c) in CIF Import File, Run aborted.");
      return;
  }
  get_next_token(string,100,impin);
  (void)sscanf (string, "%f", &drvui->lat_con[2]);
  if (position_cif(numblocks, impin, "_cell_angle_al", string, 1)) {
      Error_Box("Error finding cell (alpha) in CIF Import File, Run aborted.");
      return;
  }
  get_next_token(string,100,impin);
  (void)sscanf (string, "%f", &drvui->lat_con[3]);
  if (position_cif(numblocks, impin, "_cell_angle_be", string, 1)) {
      Error_Box("Error finding cell (beta) in CIF Import File, Run aborted.");
      return;
  }
  get_next_token(string,100,impin);
  (void)sscanf (string, "%f", &drvui->lat_con[4]);
  if (position_cif(numblocks, impin, "_cell_angle_ga", string, 1)) {
      Error_Box("Error finding cell (gamma) in CIF Import File, Run aborted.");
      return;
  }
  get_next_token(string,100,impin);
  (void)sscanf (string, "%f", &drvui->lat_con[5]);
  if (!Quick) {
    fprintf (drvui->flout,
         "******      Cell     %8.5f %8.5f %8.5f %8.3f %8.3f %8.3f\n",
         drvui->lat_con[0], drvui->lat_con[1], drvui->lat_con[2], drvui->lat_con[3], drvui->lat_con[4],
         drvui->lat_con[5]);
    if (fabs(drvui->lat_con[5] - 54.27) < 0.1
      &&fabs(drvui->lat_con[4] - 54.27) < 0.1
      && fabs(drvui->lat_con[3] - 54.27) <0.1) {
      fprintf( drvui->flout,"***** Warning - rhombohedral settings are not supported.\n");
      fprintf( drvui->flout,"***** Please transform to standard hexagonal setting.\n");
      Error_Box("Rhombohedral cells are not supported\n"
                "Please transform to standard hexagonal setting first\n");
    }
  }
  i = -1;
  if (position_cif(numblocks, impin, "_space_group_ssg_name", string, 0))
      i = 0;                     /* indicate not found */
  if (!position_cif(numblocks, impin, "_space_group_symop_ssg_id", string, 0))
      i = -1;
  j = 1;
  sg = 0;
  if (position_cif(numblocks, impin, "_symmetry_space", string, 0)) {
      j = 0;                     /* indicate not found */
  }

  if (i == -1 && drvui->modulated != -1) {
    if (!Quick) {
      fprintf (drvui->flout, "******      this CIF describes a modulated structure -- \n");
      fprintf (drvui->flout, "******      use the 'average' keyword to display average structure only\n");
    }
    drvui->modulated = 1;
    j = 1;
  }

  if (j != 0) {
    fgets(string,100,impin);
    tstring[0] = 's';
    tstring[1] = 'p';
    tstring[2] = 'g';
    tstring[3] = 'r';
    tstring[4] = ' ';
    if (string[0] != '?' && strchr(string,(char)39) ) {
      for (i = 0; i < 60; i++)
        if (string[i] == (char) 39)
          break;
     if (strchr(string,':') ) { // WJJ notation has reference sg between colons
        for (i++;i<60;i++)
          if (string[i] == ':')
            break;
      }
     for (i++, j = 5; i < 60; i++)
        if (string[i] == (char) 39 || string[i] == (char) 40 || string[i] == ':')
          break;
        else
          tstring[j++] = string[i];
        tstring[j] = '\0';
        for (i = 0; i < 60; i++) {
          if (tstring[i] == 'H')
            tstring[i] = ' ';             /* remove any H from rhomb. spgrps */
          if (tstring[i] == 'S')
            tstring[i] = ' ';             /* remove any S from monoclinic spgrps */
        }

        if  (tstring[6] != ' ') { /* no space after lattice symbol, need to dissect line first */
          int k,k3,k4,l;
          char spstring[60];
     /* separate class symbol from other symmetry elements */
          spstring[0] = 's';
          spstring[1] = 'p';
          spstring[2] = 'g';
          spstring[3] = 'r';
          spstring[4] = ' ';
          spstring[5] = tstring[5];
          spstring[6] = ' ';
          j = 6;
          k = 0;
          k3 = 0;
          k4 = 0;
          l = (int) strlen (tstring);
          for (i = 6; i <= l; i++) {
            switch (tstring[i]) {
            case ' ':
              break;
            case '/':
              spstring[++j] = tstring[i];
              break;
            default:
              j++;
    /* do we have to collate this symbol (for screw axes or mirror planes) ? */
              if (tstring[i] > '0' && tstring[i] <= '9') { /* it is a number */
                if (tstring[0] == 'R' ||             /* no screw axes in R */
                l == 4 ||                 /* no screw axes in four letter names */
                k != 0 ||                 /* have just appended to a number */
                k3 != 0 ||                 /* cannot have further screw axes after 3_x */
                (k4 != 0 && spstring[j - 1] == '3')) {    /* cannot have 3_x after a 4_x */
                  spstring[j] = ' ';             /* so separate it */
                  k = 0;                 /* and reset the collation flag */
                  j++;
                } else if (spstring[j - 1] != '-' && (spstring[j - 1] <= string[i]
                            || spstring[j - 1] >= 'a')) {
     /* neither a minus sign nor a higher number precedes it */
                  spstring[j] = ' ';             /* so separate it */
                  k = 0;                 /* and reset the collation flag */
                  j++;
                } else {
                  k++;                     /* set flag for collation */
                  if (spstring[j - 1] == '3')
                    k3 = 1;                 /* if 3_x screw, prohibit further screw axes */
                  if (spstring[j - 1] == '4')
                    k4 = 1;                 /* if 4_x screw, prohibit 3_x screw axes */
                }
              } else {                     /* not a number */
                if (spstring[j - 1] != '/') {         /*but not a mirror plane either */
                  spstring[j] = ' ';             /* separate it */
                  j++;
                }
              } 
              spstring[j] = tstring[i];             /* now add the symbol */
              break;
            }                         /*switch */
          }                         /*for i */
          spstring[j + 1] = '\0';

      /* Space group 90, P 4 21 2, is not correctly identified by this code. 
         It accounts for only 14 of the 175000 entries in the CSD (and not all 
         of them have coordinates), so this quick and dirty fix is all it can
         expect from us. Does this spacegroup really exist ? :-) */
         if (!strcmp (tstring, "P4212"))
           strcpy (spstring, "P 4 21 2");

         if(!Quick)fprintf (drvui->flout, "******  %s\n", spstring);
         symop (spstring);
      } else {
        if (!Quick)
          fprintf (drvui->flout, "******  %s\n", tstring);
        symop (tstring);
      }
      sg = 1;
    } else {
      if (!Quick)
        fprintf (drvui->flout, "******      this CIF does not contain a space group name\n");
    }
  } else {
    if (!Quick)
      fprintf (drvui->flout, "******      this CIF does not contain a space group record\n");
  }
    
  if (sg == 0 && drvui->sys == 0) {
    j = 1;
    if (position_cif(numblocks, impin, "_symmetry_equiv_pos_as_xyz", string, 0))
      j = 0;                     /* indicate not found, but no error */
    if ( j == 0) {
      if (!Quick)
        fprintf (drvui->flout, "******      this CIF contains neither a space group nor a list of symmetry operations\n");
    } else {
      char *p,*pp;
      int k;
      drvui->acentric=1;
    /* initialize symmetry arrays */
      for (i = 0; i <= 23; ++i) {
        for (j = 0; j <= 2; ++j) {
          drvui->ts[i][j] = 0.0;
          for (k = 0; k <= 2; ++k)
            drvui->ss[i][j][k] = 0;
        }
      }
      for (i = 0; i <= 2; ++i) {
        drvui->lat_pos[0][i] = 0.0;
        drvui->ss[0][i][i] = 1;
        for (j = 0; j <= 3; ++j)
          drvui->spg[i][j] = ' ';
      }
      drvui->ng=0;


        fgets(string,100,impin);

      while (strlen(string)>2) {
        fgets(string,100,impin);
        for (j=0;j<(int)strlen(string);j++)
            if (string[j]==(unsigned char)39) string[j]=' ';  /* 39 == single quote */
//       Token_Strip(string,2); 
       Blank_Strip (string);
        if (strlen(string)<3) 
            break;
        if (strstr(string,"-x, -y, -z")) {
            drvui->acentric=0;
            break;
        }
        drvui->ng++;
        p = strstr(string,",");
        *p='\0';
        getsym(string,drvui->ng-1,0);
        *p=' ';
        p++;
        pp = strstr(p,",");
        *pp='\0';
        getsym(p,drvui->ng-1,1);
        pp++;
        getsym(pp,drvui->ng-1,2);
      }
      findsys();
      find_lattice_type();
    }
  }

  if (drvui->modulated >= 1) { // parse all symmetry lines to preserve superspace symmetry
    j = 1;
    if (position_cif(numblocks, impin, "_space_group_symop_ssg_operation_algebraic", string, 0))
      j = 0;                     /* indicate not found, but no error */
    if ( j == 0) {
      if (!Quick)
        fprintf (drvui->flout, "******      this CIF does not contain superspace symmetry operations\n");
    } else {
      char *p,*pp;
      int k;
      drvui->acentric=1;
    /* initialize symmetry arrays */
      for (i = 0; i <= 23; ++i) {
        for (j = 0; j <= 2; ++j) {
          drvui->ts[i][j] = 0.0;
          drvui->ts_m[i][j]=0.0;
          for (k = 0; k <= 2; ++k) {
            drvui->ss[i][j][k] = 0;
            drvui->ss_m[i][j][k]=0;
          }
        }
      }
      for (i = 0; i <= 2; ++i) {
        drvui->lat_pos[0][i] = 0.0;
        drvui->ss[0][i][i] = 1;
        drvui->ss_m[0][i][i] = 1;
        for (j = 0; j <= 3; ++j)
          drvui->spg[i][j] = ' ';
      }
      for (i = 0;i < 3; ++i) {
        drvui->cell_vec[0][i] = 0.0;
        drvui->cell_vec[1][i] = 0.0;
        drvui->cell_vec[2][i] = 0.0;
      }
      drvui->ng=0;

      fgets(string,100,impin);

      while (strlen(string)>2) {
        int kk;
        char temp_string[100];
        fgets(string,100,impin);
//        Token_Strip(string, 2);
        for (j=0;j<(int)strlen(string);j++) 
          if (string[j]==(unsigned char)39) string[j]=' ';
//        trim_string(string,100);
//        if (!strncmp(string,"White",5))
//          break;
        Blank_Strip (string);
        if (strlen(string)<3 || string[0]=='_') 
          break;
        if (!drvui->ng) {
          if (strstr(string,"x5"))     /* get the order of the modulation */
            drvui->modulated = 2;
          if (strstr(string,"x6"))
            drvui->modulated = 3;
        }
        if (drvui->modulated < 3)       /* fill in parts of ss_m not included in input line */
            drvui->ss_m[drvui->ng][2][2] = 1; 
        if (drvui->modulated < 2)
            drvui->ss_m[drvui->ng][1][1] = 1; 
        drvui->ng++;
        strcpy(temp_string, string);
        strcat(temp_string,",");
        p = temp_string;
        for (kk=0; kk<6; kk++) {
          pp = strstr(p,",");
          *pp='\0';
          getsym(p,drvui->ng-1,kk);
          p=++pp;
          if (strlen(p) < 2) kk=6;
        }
      }
      findsys();
      find_lattice_type();
    }
  } 

/* skip through file to atom_site */
  if (position_cif(numblocks, impin, "_atom_site_", string, 1)) {
      Error_Box("Error finding _atom_site_ in CIF Import File, Run aborted.");
      return;
  }

 /* first _atom_site_ line in string need to find position of label, x, y, and z */
  j = 0;
  while (!strncmp (string, "_atom_site_", 11)) {
    if (!strncmp (string, "_atom_site_label", 16))
      Label_pos = j;
    if (!strncmp (string, "_atom_site_fract_x", 18))
      X_pos[0] = j;
    if (!strncmp (string, "_atom_site_fract_y", 18))
      X_pos[1] = j;
    if (!strncmp (string, "_atom_site_fract_z", 18))
      X_pos[2] = j;
    if (!strncmp (string, "_atom_site_occupancy", 20))
      O_pos = j;
    j++;
    if (!get_next_token (string, 100, impin)) {         /* search for next item */
        Error_Box("Error reading CIF Import File, Run aborted.");
        (void)fclose(impin);
        return;
    }
  }
  n_items = j;
  for (;;) {
    if (!strncmp (string, "loop_", 5) || !strncmp(string, "data_", 5) || !strncmp(string,"_",1))
      break;
    for (items=0; items<n_items; items++) {
      if (items == Label_pos) {
        j = 0;
        drvui->atom_n[natom] = 0;
        strcpy(drvui->atom_l[natom],"    ");
        for (i=0; i<(int)strlen(string); i++) {
          if (string[i] >= '0' && string[i] <= '9') {
            drvui->atom_n[natom] = 10 * drvui->atom_n[natom] + (int) string[i] - 48;
          } else {
            drvui->atom_l[natom][j++] = string[i];
            if (j > 3 )
              j=3;
          }
        }
      } else if (items == X_pos[0]) {
        (void)sscanf (string, "%f", &drvui->atom_xyz[natom][0]);
      } else if (items == X_pos[1]) {
        (void)sscanf (string, "%f", &drvui->atom_xyz[natom][1]);
      } else if (items == X_pos[2]) {
        (void)sscanf (string, "%f", &drvui->atom_xyz[natom][2]);
      } else if (items == O_pos) {
        (void)sscanf (string, "%f", &drvui->occupancy[natom]);
      }
      if (!get_next_token (string, 100, impin) || !strlen(string)) {
//        Error_Box("End of File while reading atoms in CIF Import File. loop_ added.");
        strcpy(string,"loop_");
      }
    }
    if (!Quick) {
      fprintf (drvui->flout,
           "******      Atom %c%c%c%c%3d %8.5f %8.5f %8.5f\n", drvui->atom_l[natom][0],
           drvui->atom_l[natom][1], drvui->atom_l[natom][2], drvui->atom_l[natom][3],
           drvui->atom_n[natom], drvui->atom_xyz[natom][0], drvui->atom_xyz[natom][1],
           drvui->atom_xyz[natom][2]);
      fflush(drvui->flout);
    }
    drvui->atom_fn[natom] = frame_no;
    drvui->sv_atom_n[natom] = drvui->atom_n[natom];
    drvui->atom_ismod[natom] = 0;
    drvui->occ_ismod[natom] = 0;
    drvui->min_occ[natom] = 0.;
    if (++natom >= MAX_ATOM) {
        Error_Box("Too many atoms in asymmetric unit - increase MAX_ATOM.");
        (void)fclose(impin);
        return;
    }
  }
  j = 1;
/* skip through file to atom_site_aniso */
  if (position_cif(numblocks, impin, "_atom_site_aniso", string, 0)) {
      j = 0; // indicate not found, but no error
  }

  if ( j == 1) { // only do if there are anisotropic temperature factors
/* first _atom_site_aniso line in string
   need to find position of label, U11, etc */
    j = 0;
    while (!strncmp (string, "_atom_site_aniso", 16)) {
      if (!strncmp (string, "_atom_site_aniso_label", 22))
        Label_pos = j;
      if (!strncmp (string, "_atom_site_aniso_U_11", 21))
        U_pos[0] = j;
      if (!strncmp (string, "_atom_site_aniso_U_22", 21))
        U_pos[1] = j;
      if (!strncmp (string, "_atom_site_aniso_U_33", 21))
        U_pos[2] = j;
      if (!strncmp (string, "_atom_site_aniso_U_12", 21))
        U_pos[3] = j;
      if (!strncmp (string, "_atom_site_aniso_U_13", 21))
        U_pos[4] = j;
      if (!strncmp (string, "_atom_site_aniso_U_23", 21))
        U_pos[5] = j;
      j++;
      if (!get_next_token (string, 100, impin)) {         /* search for next item */
//        Error_Box("End of File while reading Uij in CIF Import File, Run aborted.");
          (void)fclose(impin);
          return;
      }
    }
    n_items = j;
    for (;;) {
      if (!strncmp (string, "_", 1) || strstr(string,"loop_") )
        break;
      for (items=0; items<=n_items-1; items++) {
        if (Label_pos == items) {
          drvui->ellips_n[drvui->n_ellips] = 0;
          strcpy(drvui->ellips_l[drvui->n_ellips], "    ");    /* initialize ellipsoid name */
          j=0;
          for (i=0; i<(int)strlen(string); i++) {
            if (string[i] >= '0' && string[i] <= '9') {
              drvui->ellips_n[drvui->n_ellips] = 10 * drvui->ellips_n[drvui->n_ellips]
                + (int) string[i] - 48;
            } else {
              drvui->ellips_l[drvui->n_ellips][j++] = string[i];
              if (j > 3)
                j = 3;
            }
          }
        }
        drvui->save_el_number[drvui->n_ellips] = drvui->ellips_n[drvui->n_ellips];
        drvui->do_ellipsoids = 1;
        if (U_pos[0] == items)
          (void)sscanf (string, "%f", &drvui->ellips[drvui->n_ellips][0]);
        if (U_pos[1] == items) 
          (void)sscanf (string, "%f", &drvui->ellips[drvui->n_ellips][1]);
        if (U_pos[2] == items)
          (void)sscanf (string, "%f", &drvui->ellips[drvui->n_ellips][2]);
        if (U_pos[3] == items)
          (void)sscanf (string, "%f", &drvui->ellips[drvui->n_ellips][3]);
        if (U_pos[4] == items)
          (void)sscanf (string, "%f", &drvui->ellips[drvui->n_ellips][4]);
        if (U_pos[5] == items)
          (void)sscanf (string, "%f", &drvui->ellips[drvui->n_ellips][5]);
        if (drvui->auto_ellipse==1) {
          drvui->ell_type[drvui->n_ellips] = 1001;         // Uij with ellipcolor
          memset(drvui->ellips_col[drvui->n_ellips],0,40);
          strcpy(drvui->ellips_col[drvui->n_ellips],"Gray30");
        } else {
          drvui->ell_type[drvui->n_ellips] = 1;            // Uij
        }
        if (items <n_items-1) get_next_token(string, 100, impin);
      }
      if(!Quick)fprintf (drvui->flout,
           "******      Uij  %c%c%c%c%3d %8.5f %8.5f %8.5f %8.5f %8.5f %8.5f\n",
           drvui->ellips_l[drvui->n_ellips][0], drvui->ellips_l[drvui->n_ellips][1],
           drvui->ellips_l[drvui->n_ellips][2], drvui->ellips_l[drvui->n_ellips][3],
           drvui->ellips_n[drvui->n_ellips], drvui->ellips[drvui->n_ellips][0], drvui->ellips[drvui->n_ellips][1], 
           drvui->ellips[drvui->n_ellips][2], drvui->ellips[drvui->n_ellips][3], drvui->ellips[drvui->n_ellips][4],
           drvui->ellips[drvui->n_ellips][5]);
      drvui->ellips_ismod[drvui->n_ellips] = 0;
      if (++drvui->n_ellips >= MAX_EL) {
          Error_Box("Too many ellipsoid types specified - increase MAX_EL.");
          return;
      }
      if (!get_next_token (string, 100, impin)) {
//        Error_Box("Error reading CIF Import File, Run aborted.");
          (void)fclose(impin);
          return;
      }
    }
    drvui->auto_ellipse = 0;
  }

  if (drvui->modulated >= 1) {
    int axis=0;
    int elem=0;
    int theatom=0;
    drvui->no_mod_vectors = 0;

/* unit cell wave vectors */

/* skip through file to cell_wave_vector_seq_id line */

  if (position_cif(numblocks, impin, "_cell_wave_vector_seq_id", string, 1)) {
      Error_Box("Error finding _cell_wave_vector in CIF Import File, Run aborted.");
      return;
  }
  j = 0;
  if (!Quick)
    fprintf(drvui->flout, "******\n******  Cell Modulation Vector(s)\n****** No.             Components\n******\n");
  while (!strncmp (string, "_cell_wave_vector", 17)) {
    if (!strncmp (string, "_cell_wave_vector_x", 19))
      X_pos[0] = j;
    if (!strncmp (string, "_cell_wave_vector_y", 19))
      X_pos[1] = j;
    if (!strncmp (string, "_cell_wave_vector_z", 19))
      X_pos[2] = j;
    j++;
    if (!get_next_token (string, 100, impin)) {         /* search for next item */
        Error_Box("Error reading CIF Import File, Run aborted.");
        (void)fclose(impin);
        return;
    }
  }
  n_items = j;
  drvui->no_cell_vec = 0;
  for (;;) {
    if (!strncmp (string, "loop_", 5) || !strncmp(string, "data_", 5) || !strncmp(string,"_",1))
      break;
    for (items=0; items<n_items; items++) {
      if (items == X_pos[0]) {
        (void)sscanf (string, "%f", &drvui->cell_vec[drvui->no_cell_vec][0]);
      } else if (items == X_pos[1]) {
        (void)sscanf (string, "%f", &drvui->cell_vec[drvui->no_cell_vec][1]);
      } else if (items == X_pos[2]) {
        (void)sscanf (string, "%f", &drvui->cell_vec[drvui->no_cell_vec][2]);
      }
      if (!get_next_token (string, 100, impin) || !strlen(string)) {
//        Error_Box("End of File while reading atoms in CIF Import File. loop_ added.");
        strcpy(string,"loop_");
      }
    }
    if (!Quick) {
      fprintf (drvui->flout,
           "****** %2d     %8.5f %8.5f %8.5f\n", drvui->no_cell_vec+1,
           drvui->cell_vec[drvui->no_cell_vec][0], drvui->cell_vec[drvui->no_cell_vec][1],
           drvui->cell_vec[drvui->no_cell_vec][2]);
      fflush(drvui->flout);
    }
    drvui->no_cell_vec++;
  }
  if (drvui->no_cell_vec && !Quick)
    fprintf(drvui->flout, "******\n");

  /* modulation wave vector(s) */

  /* skip through file to atom_site_Fourier */
    if (position_cif(numblocks, impin, "_atom_site_Fourier_", string, 1)) {
        Error_Box("Error reading modulation wave vector in CIF Import File, Run aborted.");
        return;
    }
  /* first _atom_site_ line in string need to find position of label, x, y, and z */
    j = 0;
    X_pos[0]=X_pos[1]=X_pos[2]=Label_pos=-1;
    if (!Quick)
      fprintf(drvui->flout, "******\n******  Atom Site Modulation Vector(s)\n******  No.     Components         Cell Wave Components\n******\n");
    while (!strncmp (string, "_atom_site_Fourier_", 19)) {
      if (!strncmp (string, "_atom_site_Fourier_wave_vector_seq_id", 37))
        Label_pos = j;
      if (!strncmp (string, "_atom_site_Fourier_wave_vector_x", 32))
        X_pos[0] = j;
      if (!strncmp (string, "_atom_site_Fourier_wave_vector_y", 32))
        X_pos[1] = j;
      if (!strncmp (string, "_atom_site_Fourier_wave_vector_z", 32))
        X_pos[2] = j;
      j++;
      if (!get_next_token (string, 100, impin)) {         /* search for next item */
        Error_Box("Error reading CIF Import File, Run aborted.");
        (void)fclose(impin);
        return;
      }
    }
    n_items = j;
    for (;;) {
      int no_z, max_z = 5;
      int no_y, max_y = 5;
      int no_x, max_x = 5;

      if (drvui->no_cell_vec < 3) max_z = 0;
      if (drvui->no_cell_vec < 2) max_y = 0;
      if (!strncmp (string, "loop_", 5) || !strncmp(string, "data_", 5)) 
        break;
      j = drvui->no_mod_vectors;
      drvui->modvector[j][0]=0.;
      drvui->modvector[j][1]=0.;
      drvui->modvector[j][2]=0.;
      for (items=0; items<=n_items-1; items++) {
        if (X_pos[0] == items)
          (void)sscanf (string, "%f", &drvui->modvector[j][0]);
        if (X_pos[1] == items) 
          (void)sscanf (string, "%f", &drvui->modvector[j][1]);
        if (X_pos[2] == items) 
          (void)sscanf (string, "%f", &drvui->modvector[j][2]);
        if (items <n_items) get_next_token(string, 100, impin);
      }
      for (no_z=-max_z; no_z<=max_z; no_z++) {
        for (no_y=-max_y; no_y<=max_y; no_y++) {
          for (no_x=-max_x; no_x<=max_x; no_x++) {
            if(vec_dif(no_x, drvui->cell_vec[0], no_y, drvui->cell_vec[1], no_z, drvui->cell_vec[2],
                       drvui->modvector[j])) {
              drvui->vector_mult[j][0] = no_x;    /* have components of modvector */
              drvui->vector_mult[j][1] = no_y;
              drvui->vector_mult[j][2] = no_z;
              goto done;
            }
          }
        }
      }
      Error_Box("Unable to decombine modulation wave vector into cell vector parts.");
done:
      if(!Quick) {
         fprintf (drvui->flout,"****** %2d %8.5f %8.5f %8.5f  %3d %3d %3d\n",
                  j+1,drvui->modvector[j][0],drvui->modvector[j][1],drvui->modvector[j][2],
                  drvui->vector_mult[j][0], drvui->vector_mult[j][1], drvui->vector_mult[j][2]);
      }
      drvui->no_mod_vectors++;
    }

  /* displacement modulation - fourier series */

  /* skip through file to atom_site_displace_Fourier */
    (void) position_cif(numblocks, impin, "_atom_site_displace_Fourier_", string, 0);
  /* first _atom_site_ line in string need to find position of label and parameters */
    j = 0;
    while (!strncmp (string, "_atom_site_displace_Fourier_", 28)) {
      if (!strncmp (string, "_atom_site_displace_Fourier_atom_site_label", 43))
        Label_pos = j;
      if (!strncmp (string, "_atom_site_displace_Fourier_wave_vector_seq_id", 46))
        Id_pos = j;
      if (!strncmp (string, "_atom_site_displace_Fourier_axis", 32))
        X_pos[0] = j;
      if (!strncmp (string, "_atom_site_displace_Fourier_param_cos", 37))
        X_pos[1] = j;
      if (!strncmp (string, "_atom_site_displace_Fourier_param_sin", 37))
        X_pos[2] = j;
      j++;
      if (!get_next_token (string, 100, impin)) {         /* search for next item */
        Error_Box("Error reading CIF Import File, Run aborted.");
        (void)fclose(impin); // we saw the header, so there should be data
        return;
      }
    }
    if (j >0) {
      if (!Quick)
          fprintf(drvui->flout, "******\n****** Atom Site Fourier Displacement Items\n****** \n"
                  "****** Atom  axis ID      cos      sin\n******\n");
      n_items = j;
      drvui->no_site_displace = 0;
      for (;;) {
        if (!strncmp (string, "_", 1) || strstr(string,"loop_") || !strlen(string) )
          break;
        for (items=0; items<=n_items-1; items++) {
          if (Label_pos == items) {
            int modnum = 0;
            char modl[5];
            strcpy(modl, "    ");    /* initialize name */
            j=0;
            for (i=0; i<(int)strlen(string); i++) {
              if (string[i] >= '0' && string[i] <= '9') {
                modnum = 10 * modnum
                         + (int) string[i] - 48;
              } else {
                modl[j++] = string[i];
                if (j > 3)
                  j = 3;
              }
            }
          for (j=0;j< natom;j++) 
            if (check_atom_name(modl,drvui->atom_l[j]) && modnum == drvui->atom_n[j] ) {
	      theatom=j;
              drvui->atom_ismod[j] |= 1;
              drvui->occ_ismod[j] = 0;
              break;
            }
          }
          if (X_pos[0] == items)  {
	    axis = 0;
	    if (!strncmp(string,"y",1)) 
              axis =1;
	    else if (!strncmp(string,"z",1))
              axis =2;
	  }
          drvui->atom_modpar_axis[drvui->no_site_displace] = axis;
          drvui->atom_modpar_atom[drvui->no_site_displace] = theatom;
          if (Id_pos == items)  
	    (void) sscanf(string,"%d",&drvui->atom_modpar_id[drvui->no_site_displace]);
          if (X_pos[1] == items)  
	    (void) sscanf(string,"%f",&drvui->atom_modpar[drvui->no_site_displace][0]);
          if (X_pos[2] == items)  
	    (void) sscanf(string,"%f",&drvui->atom_modpar[drvui->no_site_displace][1]);
        
          if (items <n_items) 
            if (!get_next_token(string, 100, impin))
              strcpy(string,"_loop");

        }
        if (!Quick) {
            char caxis[3][2] = {"X","Y","Z"};
            char axis2[2];
            strcpy(axis2,caxis[drvui->atom_modpar_axis[drvui->no_site_displace]]);
            fprintf(drvui->flout,"****** %4s%2d   %s%3d   %8.5f %8.5f\n", drvui->atom_l[theatom],
                    drvui->atom_n[theatom], axis2,
//                    caxis[drvui->atom_modpar_axis[drvui->no_site_displace]][0],
                    drvui->atom_modpar_id[drvui->no_site_displace],
                    drvui->atom_modpar[drvui->no_site_displace][0],
                    drvui->atom_modpar[drvui->no_site_displace][1]);
        }
        drvui->no_site_displace++;
      }
    }

  /* displacement modulation - sawtooth function */

  /* skip through file to atom_site_displace_special */
    (void) position_cif(numblocks, impin, "_atom_site_displace_special_", string, 0);
  /* first _atom_site_ line in string need to find position of label and parameters */
    j = 0;
    Label_pos=U_pos[0]=U_pos[1]=U_pos[2]=U_pos[3]=U_pos[4]=0;
    while (!strncmp (string, "_atom_site_displace_special_", 28)) {
      if (!strncmp (string, "_atom_site_displace_special_func_atom_site_label", 48))
        Label_pos = j;
      if (!strncmp (string, "_atom_site_displace_special_func_sawtooth_ax", 44))
        U_pos[0] = j;
      if (!strncmp (string, "_atom_site_displace_special_func_sawtooth_ay", 44))
        U_pos[1] = j;
      if (!strncmp (string, "_atom_site_displace_special_func_sawtooth_az", 44))
        U_pos[2] = j;
      if (!strncmp (string, "_atom_site_displace_special_func_sawtooth_c", 43))
        U_pos[3] = j;
      if (!strncmp (string, "_atom_site_displace_special_func_sawtooth_w", 43))
        U_pos[4] = j;
      j++;
      if (!get_next_token (string, 100, impin)) {         /* search for next item */
        Error_Box("Error reading CIF Import File, Run aborted.");
        (void)fclose(impin); // we saw the header, so there should be data
        return;
      }
    }
    if (j >0) {
      if (!Quick)
          fprintf(drvui->flout, "******\n****** Atom Site Sawtooth Displacement Items\n****** \n"
                  "****** Atom         ax       ay       az     center   width\n******\n");
      n_items = j;
      for (;;) {
        if (!strncmp (string, "_", 1) || strstr(string,"loop_") || !strlen(string) )
          break;
        for (items=0; items<=n_items-1; items++) {
          if (Label_pos == items) {
            int modnum = 0;
            char modl[5];
            strcpy(modl, "    ");    /* initialize name */
            j=0;
            for (i=0; i<(int)strlen(string); i++) {
              if (string[i] >= '0' && string[i] <= '9') {
                modnum = 10 * modnum
                         + (int) string[i] - 48;
              } else {
                modl[j++] = string[i];
                if (j > 3)
                  j = 3;
              }
            }
          for (j=0;j< natom;j++) 
            if (check_atom_name(modl,drvui->atom_l[j]) && modnum == drvui->atom_n[j] ) {
	      theatom=j;
              drvui->atom_ismod[j] |= 2;
              drvui->occ_ismod[j] = 0;
              break;
            }
          }
          if (U_pos[0] == items)  
	    (void) sscanf(string,"%f",&drvui->atom_mod_sawtooth[theatom][0]);
          if (U_pos[1] == items)  
	    (void) sscanf(string,"%f",&drvui->atom_mod_sawtooth[theatom][1]);
          if (U_pos[2] == items)  
	    (void) sscanf(string,"%f",&drvui->atom_mod_sawtooth[theatom][2]);
          if (U_pos[3] == items)  
	    (void) sscanf(string,"%f",&drvui->atom_mod_sawtooth[theatom][3]);
          if (U_pos[4] == items)  
	    (void) sscanf(string,"%f",&drvui->atom_mod_sawtooth[theatom][4]);
        
          if (items <n_items) 
            if (!get_next_token(string, 100, impin))
              strcpy(string,"_loop");

        }
        if (!Quick) {
            fprintf(drvui->flout,"****** %4s%2d   %8.5f %8.5f %8.5f %8.5f %8.5f\n", drvui->atom_l[theatom],
                    drvui->atom_n[theatom], 
                    drvui->atom_mod_sawtooth[theatom][0],
                    drvui->atom_mod_sawtooth[theatom][1],
                    drvui->atom_mod_sawtooth[theatom][2],
                    drvui->atom_mod_sawtooth[theatom][3],
                    drvui->atom_mod_sawtooth[theatom][4]);
        }
      }
    }

  /* occupancy modulation - fourier series */

  /* skip through file to atom_site_occ_Fourier */
    (void) position_cif(numblocks, impin, "_atom_site_occ_Fourier_", string, 0);
  /* first _atom_site_ line in string need to find position of label, x, y, and z */
    j = 0;
    while (!strncmp (string, "_atom_site_occ_Fourier_", 23)) {
      if (!strncmp (string, "_atom_site_occ_Fourier_atom_site_label", 38))
        Label_pos = j;
      if (!strncmp (string, "_atom_site_occ_Fourier_wave_vector_seq_id", 41))
        Id_pos = j;
      if (!strncmp (string, "_atom_site_occ_Fourier_param_cos", 32))
        X_pos[1] = j;
      if (!strncmp (string, "_atom_site_occ_Fourier_param_sin", 32))
        X_pos[2] = j;
      j++;
      if (!get_next_token (string, 100, impin)) {         /* search for next item */
        Error_Box("Error reading CIF Import File, Run aborted.");
        (void)fclose(impin);
        return;
      }
    }
    if (j>0) {
      if (!Quick)
          fprintf(drvui->flout, "******\n****** Atom Site Fourier Occupancy Items\n******\n"
                  "******  Atom  axis    cos      sin\n******\n");
      n_items = j;
      drvui->no_site_occ = 0;
      for (;;) {
        if (!strncmp (string, "_", 1) || strstr(string,"loop_") || !strlen(string) )
          break;
        for (items=0; items<=n_items-1; items++) {
          if (Label_pos == items) {
            int modnum = 0;
            char modl[5];
            strcpy(modl, "    ");    /* initialize name */
            j=0;
            for (i=0; i<(int)strlen(string); i++) {
              if (string[i] >= '0' && string[i] <= '9') {
                modnum = 10 * modnum
                         + (int) string[i] - 48;
              } else {
                modl[j++] = string[i];
                if (j > 3)
                  j = 3;
              }
            }
            for (j=0;j< natom;j++) 
              if (check_atom_name(modl,drvui->atom_l[j]) && modnum == drvui->atom_n[j] ) {
	        theatom=j;
                drvui->occ_ismod[j] |= 1;
                break;
              }
          }
          drvui->atom_occpar_atom[drvui->no_site_occ] = theatom;

          if (Id_pos == items)  
            (void) sscanf(string,"%d",&drvui->atom_occpar_id[drvui->no_site_occ]);

          if (X_pos[1] == items)  
            (void) sscanf(string,"%f",&drvui->atom_occpar[drvui->no_site_occ][0]);

          if (X_pos[2] == items)  
            (void) sscanf(string,"%f",&drvui->atom_occpar[drvui->no_site_occ][1]);

          if (items <n_items) 
            if (!get_next_token(string, 100, impin))strcpy(string,"_loop");

        }
        if (!Quick) {
            fprintf(drvui->flout,"****** %4s%d %5d %8.5f %8.5f\n", drvui->atom_l[theatom],
                    drvui->atom_n[theatom], drvui->atom_occpar_id[drvui->no_site_occ],
                    drvui->atom_occpar[drvui->no_site_occ][0],
                    drvui->atom_occpar[drvui->no_site_occ][1]);
        }
        drvui->no_site_occ++;
      }
    }

  /* occupancy modulation : crenel function */

  /* skip through file to atom_site_occ_special */
    (void) position_cif(numblocks, impin, "_atom_site_occ_special_", string, 0);
  /* first _atom_site_ line in string need to find position of label, x, y, and z */
    j = 0;
    while (!strncmp (string, "_atom_site_occ_special_", 23)) {
      if (!strncmp (string, "_atom_site_occ_special_func_atom_site_label", 43))
        Label_pos = j;
      if (!strncmp (string, "_atom_site_occ_special_func_crenel_c", 36))
        X_pos[1] = j;
      if (!strncmp (string, "_atom_site_occ_special_func_crenel_w", 36))
        X_pos[2] = j;
      j++;
      if (!get_next_token (string, 100, impin)) {         /* search for next item */
        Error_Box("Error reading CIF Import File, Run aborted.");
        (void)fclose(impin);
        return;
      }
    }
    if (j >0 ) {
      n_items = j;
      for (;;) {
        if (!strncmp (string, "_", 1) || !strncmp(string,"loop_",5) || !strlen(string) )
          break;
        for (items=0; items<=n_items-1; items++) {
          if (Label_pos == items) {
            int modnum = 0;
            char modl[5];
            strcpy(modl, "    ");    /* initialize name */
            j=0;
            for (i=0; i<(int)strlen(string); i++) {
              if (string[i] >= '0' && string[i] <= '9') {
                modnum = 10 * modnum
                         + (int) string[i] - 48;
              } else {
                modl[j++] = string[i];
                if (j > 3)
                  j = 3;
              }
            }
            for (j=0;j< natom;j++) 
              if (check_atom_name(modl,drvui->atom_l[j]) && modnum == drvui->atom_n[j] ) {
	        theatom=j;
                drvui->occ_ismod[j] |= 2;
                break;
              }
            }

            if (X_pos[1] == items)  
              (void) sscanf(string,"%f",&drvui->atom_occ_crenel[theatom][0]);
            if (X_pos[2] == items)  
	      (void) sscanf(string,"%f",&drvui->atom_occ_crenel[theatom][1]);
            if (items <n_items) 
              if (!get_next_token(string, 100, impin))strcpy(string,"_loop");

        }
      }
      for (j=0;j<natom;j++) 
        if (drvui->occ_ismod[j] == 2) { // convert crenel parameters to min/max values 
          if (!Quick) {
            fprintf(drvui->flout,"*** Occupational modulation parameters for %s%d:\n",
                    drvui->atom_l[j],drvui->atom_n[j]);
            fprintf(drvui->flout,"*** \t crenel offset %7.5f width %7.5f\n",
                    drvui->atom_occ_crenel[j][0],drvui->atom_occ_crenel[j][1]);
          }
          float w=drvui->atom_occ_crenel[j][1]/2.0f;
          drvui->atom_occ_crenel[j][1] = drvui->atom_occ_crenel[j][0] +w;
          drvui->atom_occ_crenel[j][0] -= w;
      }
    }
  
  /* modulation of thermal parameters - fourier series */

  /* skip through file to atom_site_U_Fourier */
    (void) position_cif(numblocks, impin, "_atom_site_U_Fourier_", string, 0);
  /* first _atom_site_ line in string need to find position of label and parameters */
    j = 0;
    while (!strncmp (string, "_atom_site_U_Fourier_", 21)) {
      if (!strncmp (string, "_atom_site_U_Fourier_atom_site_label", 36))
        Label_pos = j;
      if (!strncmp (string, "_atom_site_U_Fourier_tens_elem", 30))
        X_pos[0] = j;
      if (!strncmp (string, "_atom_site_U_Fourier_wave_vector_seq_id", 39))
        Id_pos = j;
      if (!strncmp (string, "_atom_site_U_Fourier_param_cos", 30))
        X_pos[1] = j;
      if (!strncmp (string, "_atom_site_U_Fourier_param_sin", 30))
        X_pos[2] = j;
      j++;
      if (!get_next_token (string, 100, impin)) {         /* search for next item */
        Error_Box("Error reading CIF Import File, Run aborted.");
        (void)fclose(impin); // we saw the header, so there should be data
        return;
      }
    }
    if (j >0) {
      n_items = j;
      drvui->no_site_U_terms = 0;
      for (;;) {
        if (!strncmp (string, "_", 1) || strstr(string,"loop_") || !strlen(string) )
          break;
        for (items=0; items<=n_items-1; items++) {
          if (Label_pos == items) {
            int modnum = 0;
            char modl[5];
            strcpy(modl, "    ");    /* initialize name */
            j=0;
            for (i=0; i<(int)strlen(string); i++) {
              if (string[i] >= '0' && string[i] <= '9') {
                modnum = 10 * modnum
                         + (int) string[i] - 48;
              } else {
                modl[j++] = string[i];
                if (j > 3)
                  j = 3;
              }
            }
            for (j=0;j< natom;j++) 
              if (check_atom_name(modl,drvui->atom_l[j]) && modnum == drvui->atom_n[j] ) {
	        theatom=j;
              drvui->ellips_ismod[j]=1;
              break;
            }
            drvui->ellips_modpar_atom[drvui->no_site_U_terms] = theatom;
          }
          if (X_pos[0] == items)  {
            elem = 0; // U11
            if (!strncmp(string,"U22",3)) 
              elem =1;
	    else if (!strncmp(string,"U33",3))
              elem =2;
	    else if (!strncmp(string,"U12",3)) 
              elem =3;
	    else if (!strncmp(string,"U13",3)) 
              elem =4;
	    else if (!strncmp(string,"U23",3))
              elem =5;
            drvui->ellips_modpar_term[drvui->no_site_U_terms] = elem;
	  }
          if (Id_pos == items)  
	    (void) sscanf(string,"%d",&drvui->ellips_modpar_id[drvui->no_site_U_terms]);
          if (X_pos[1] == items)  
	    (void) sscanf(string,"%f",&drvui->ellips_modpar[drvui->no_site_U_terms][0]);
          if (X_pos[2] == items)  
	    (void) sscanf(string,"%f",&drvui->ellips_modpar[drvui->no_site_U_terms][1]);
        
          if (items <n_items) 
            if (!get_next_token(string, 100, impin))
              strcpy(string,"_loop");

        }
        drvui->no_site_U_terms++;
      }
      if (!Quick) {
        char Terms[6][4] = {"U11","U22","U33","U12","U13","U23"};
        char out_term[4];
        int id, term;
        fprintf(drvui->flout, "******\n****** Uij Fourier Modulation terms\n******\n"
                "****** Atom    ID  Term      cos      sin\n******\n");
        for (j=0;j<drvui->no_site_U_terms;j++) {
            theatom = drvui->ellips_modpar_atom[j];
            id = drvui->ellips_modpar_id[j];
            term = drvui->ellips_modpar_term[j];
            strcpy(out_term, Terms[term]);
            fprintf(drvui->flout,"****** %4s%d   %2d   %3s %10.5f%9.5f\n",drvui->atom_l[theatom],
                                 drvui->atom_n[theatom], id, out_term, drvui->ellips_modpar[j][0],
                                 drvui->ellips_modpar[j][1]);
        }
        fprintf(drvui->flout, "******\n");
      }
    }
  }

/* get subsystem information for composite crystals */

  if (!position_cif(numblocks, impin, "_cell_subsystems_number", string, 0)) { /* no error if not found */
      float e[6] = {0,0,0,0,0,0}; /* the (3 + d)D reciprocal basis vectors */
      float mat[6][6];          /* the matrix describing the relations between e and ep */
      int kk;
      float ast = drvui->rec_lat_con[0];
      float bst = drvui->rec_lat_con[1];
      float cst = drvui->rec_lat_con[2];
      float csal = drvui->rec_lat_con[3];
      float csbe = drvui->rec_lat_con[4];
      float csga = drvui->rec_lat_con[5];
      float snalp, snbep, sngap, vol;
      float ap, bp, cp, csalp, csbep, csgap;
      float a, b, c, alpha, beta, gamma;
      int l, m;

      get_next_token(string, 100, impin);   /* this CIF describes a composite crystal */
      sscanf(string, "%d", &drvui->no_subsys);
      if (!Quick)
          fprintf(drvui->flout, "******\n****** CIF describes a composite crystal "
                  "with %d subsystems\n******\n", drvui->no_subsys);
      fgets(string, 100, impin);
      for (;;) {
          for (j=0; j<6; j++)
              for (kk=0; kk<6; kk++)
                  mat[j][kk] = 0.0f;
          fgets(string, 100, impin);
          if (!strstr(string, "_cell_subsystem"))
              break;                    /* skip through all the W matrix lines - FIXME? */
      }
      for (j=0; j<3; j++)
          e[j] = drvui->rec_lat_con[j];       /* first three elements of e are a*, b* and c* */
      for (j=0; j<drvui->modulated; j++)      /* remainder are e4*, e5*, and e6* */
          for (kk=0; kk<3; kk++)
              e[j+3] += drvui->cell_vec[j][kk] * drvui->rec_lat_con[kk];
      for (j=0; j<drvui->no_subsys; j++) {
          for (i=0; i<3+drvui->modulated; i++) {
              for (kk=0; kk<3+drvui->modulated; kk++) {
                  get_next_token(string, 100, impin);
                  sscanf(string, "%f", &mat[i][kk]);   /* read the appropriate matrix element */
              }
          }
          fgets(string, 100, impin);    /* skip the line with ? */
          for (l=0; l<3; l++)
              for (m=0; m<3; m++)
                  drvui->subsys_fact[j][l][m] = mat[l][m] + mat[l][3] * drvui->cell_vec[0][m]
                     + mat[l][4] * drvui->cell_vec[1][m] + mat[l][5] * drvui->cell_vec[2][m];
/* this is really ugly code, but I don't know how to make it pretty */
          ap = (float) sqrt(ast * ast * drvui->subsys_fact[j][0][0] * drvui->subsys_fact[j][0][0]
             + bst * bst * drvui->subsys_fact[j][0][1] * drvui->subsys_fact[j][0][1]
             + cst * cst * drvui->subsys_fact[j][0][2] * drvui->subsys_fact[j][0][2]
             + 2.0f * ast * bst * csga * drvui->subsys_fact[j][0][0] * drvui->subsys_fact[j][0][1]
             + 2.0f * ast * cst * csbe * drvui->subsys_fact[j][0][0] * drvui->subsys_fact[j][0][2]
             + 2.0f * bst * cst * csal * drvui->subsys_fact[j][0][1] * drvui->subsys_fact[j][0][2]);
          bp = (float) sqrt(ast * ast * drvui->subsys_fact[j][1][0] * drvui->subsys_fact[j][1][0]
             + bst * bst * drvui->subsys_fact[j][1][1] * drvui->subsys_fact[j][1][1]
             + cst * cst * drvui->subsys_fact[j][1][2] * drvui->subsys_fact[j][1][2]
             + 2.0f * ast * bst * csga * drvui->subsys_fact[j][1][0] * drvui->subsys_fact[j][1][1]
             + 2.0f * ast * cst * csbe * drvui->subsys_fact[j][1][0] * drvui->subsys_fact[j][1][2]
             + 2.0f * bst * cst * csal * drvui->subsys_fact[j][1][1] * drvui->subsys_fact[j][1][2]);
          cp = (float) sqrt(ast * ast * drvui->subsys_fact[j][2][0] * drvui->subsys_fact[j][2][0]
             + bst * bst * drvui->subsys_fact[j][2][1] * drvui->subsys_fact[j][2][1]
             + cst * cst * drvui->subsys_fact[j][2][2] * drvui->subsys_fact[j][2][2]
             + 2.0f * ast * bst * csga * drvui->subsys_fact[j][2][0] * drvui->subsys_fact[j][2][1]
             + 2.0f * ast * cst * csbe * drvui->subsys_fact[j][2][0] * drvui->subsys_fact[j][2][2]
             + 2.0f * bst * cst * csal * drvui->subsys_fact[j][2][1] * drvui->subsys_fact[j][2][2]);
          csgap = (drvui->subsys_fact[j][0][0] * drvui->subsys_fact[j][1][0] * ap * ap
                + drvui->subsys_fact[j][0][1] * drvui->subsys_fact[j][1][1] * bp * bp
                + drvui->subsys_fact[j][0][2] * drvui->subsys_fact[j][1][2] * cp * cp
                + ast * bst * csga * (drvui->subsys_fact[j][0][0] * drvui->subsys_fact[j][1][1]
                +                     drvui->subsys_fact[j][0][1] * drvui->subsys_fact[j][1][0])
                + ast * cst * csbe * (drvui->subsys_fact[j][0][0] * drvui->subsys_fact[j][1][2]
                +                     drvui->subsys_fact[j][0][2] * drvui->subsys_fact[j][1][0])
                + bst * cst * csal * (drvui->subsys_fact[j][0][1] * drvui->subsys_fact[j][1][2]
                +                     drvui->subsys_fact[j][0][2] * drvui->subsys_fact[j][1][1]))
                /(ap * bp);
          sngap = (float) sqrt(1.0 - csgap * csgap);
          csbep = (drvui->subsys_fact[j][0][0] * drvui->subsys_fact[j][2][0] * ap * ap
                + drvui->subsys_fact[j][0][1] * drvui->subsys_fact[j][2][1] * bp * bp
                + drvui->subsys_fact[j][0][2] * drvui->subsys_fact[j][2][2] * cp * cp
                + ast * bst * csga * (drvui->subsys_fact[j][0][0] * drvui->subsys_fact[j][2][1]
                +                     drvui->subsys_fact[j][0][1] * drvui->subsys_fact[j][2][0])
                + ast * cst * csbe * (drvui->subsys_fact[j][0][0] * drvui->subsys_fact[j][2][2]
                +                     drvui->subsys_fact[j][0][2] * drvui->subsys_fact[j][2][0])
                + bst * cst * csal * (drvui->subsys_fact[j][0][1] * drvui->subsys_fact[j][2][2]
                +                     drvui->subsys_fact[j][0][2] * drvui->subsys_fact[j][2][1]))
                /(ap * cp);
          snbep = (float) sqrt(1.0 - csbep * csbep);
          csalp = (drvui->subsys_fact[j][1][0] * drvui->subsys_fact[j][2][0] * ap * ap
                + drvui->subsys_fact[j][1][1] * drvui->subsys_fact[j][2][1] * bp * bp
                + drvui->subsys_fact[j][1][2] * drvui->subsys_fact[j][2][2] * cp * cp
                + ast * bst * csga * (drvui->subsys_fact[j][1][0] * drvui->subsys_fact[j][2][1]
                +                     drvui->subsys_fact[j][1][1] * drvui->subsys_fact[j][2][0])
                + ast * cst * csbe * (drvui->subsys_fact[j][1][0] * drvui->subsys_fact[j][2][2]
                +                     drvui->subsys_fact[j][1][2] * drvui->subsys_fact[j][2][0])
                + bst * cst * csal * (drvui->subsys_fact[j][1][1] * drvui->subsys_fact[j][2][2]
                +                     drvui->subsys_fact[j][1][2] * drvui->subsys_fact[j][2][1]))
                /(bp * cp);
          snalp = (float) sqrt(1.0 - csalp * csalp);
          vol = ap * bp * cp * (float) sqrt(1.0 - csalp * csalp - csbep * csbep - csgap * csgap
              - csalp * csbep * csgap);
          a = bp * cp * snalp / vol;
          b = ap * cp * snbep / vol;
          c = ap * bp * sngap / vol;
          alpha = (float)(180.0 / PI * acos((csbep * csgap - csalp) / (snbep * sngap)));
          beta  = (float)(180.0 / PI * acos((csalp * csgap - csbep) / (snalp * sngap)));
          gamma = (float)(180.0 / PI * acos((csalp * csbep - csgap) / (snalp * snbep)));
          drvui->subsys_vol[j] = vol;     /* save reciprocal volume */
              
          if (!Quick)
              fprintf(drvui->flout, "****** The cell for subsystem %d is:\n"
                   "******  a = %8.5f, b = %8.5f, c = %8.5f, Vol = %9.3f\n"
                   "******  alpha = %8.3f, beta = %8.3f,"
                   " gamma = %8.3f\n******\n", j+1 , a, b, c, 1.0f/vol, alpha, beta, gamma);
      }
  }

  (void)fclose (impin);
}

/* ************************************************************** */
/* ************************************************************** */

