#!/usr/local/bin/ruby

require 'drb/drb'

class Conn
  include DRb::DRbProtocol

  def initialize
    @buf = read_buf
  end
  attr_reader :buf

  def there
    ENV['HTTP_DRB_SERVER']
  end

  def here
    ENV['HTTP_DRB_HERE']
  end

  def size
    ENV['CONTENT_LENGTH'].to_i
    #FIXME size_check!!!
  end

  private
  def read_buf
    $stdin.read(size)
  end
end

c = Conn.new
host, port, = c.parse_uri(c.there)

soc = TCPSocket.open(host, port)
soc.write(c.buf)
buf = soc.read

print "Content-Length: #{buf.size}\r\n"
print "Content-type: application/octet-stream;\r\n\r\n"
print buf
