/* Drip - a transcoder for Unix
 * Copyright (C) 2001-2003 Jarl van Katwijk
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "../src/drip.h"
#include <gmodule.h>

#define MAX_FILTERS 256
#define VALUES 512
#define UNSET -9999999



typedef enum module_type_e {SPU,AUDIO,VIDEO,UNKNOWNT} MODULE_TYPE_E;
// SPU   : Subpictures
// AUDIO : Audio channels
// VIDEO : Video frames


typedef enum module_phase_e {PRE,NORMAL,POST,UNKNOWNP} MODULE_PHASE_E;
// When to apply this filter -:-
// -------+-----+-----------------------------+--------------------------------+----------------------------
// PHASE  | SEQ | SPU                         | AUDIO                          | VIDEO                       
// -------+-----+-----------------------------+--------------------------------+----------------------------
// PRE    |  1  | Filter gets raw SPU data    | Filter gets raw undecoded data | Filter gets unzoomed frames 
// NORMAL |  2  | Filter receives spu bitmaps | Filter gets decoded PCM audio  | Filter gets zoomed frames   
// POST   |  3  | >-----------------------------Filters gets data after phase 2----------------------------< 
// -------+-----+-----------------------------+--------------------------------+----------------------------


typedef struct _filter filter;
struct _filter {
    GModule* module;
    GString* module_name;
    gchar* module_filename;
    guint8** (*module_apply_function)(guint8** src, glong size,gulong SCR,gulong PTS);
    GtkWidget* (*module_gui_function)(void);
    gpointer (*module_default_function)(void);
    gpointer (*module_init_function)(gint,gint,gint,gint,gint,gint,gdouble);
    gpointer (*module_values_function_set)(gdouble*);
    gpointer (*module_destruct_function)(void);
    MODULE_TYPE_E (*module_type_function)(void);
    MODULE_PHASE_E (*module_phase_function)(void);
    void (*module_values_function_get)(gdouble*);
    gboolean loaded;
    gboolean active;
    enum module_type_e module_type;
    enum module_phase_e module_phase;
    GtkWidget *module_GUI;
};

extern filter filters[MAX_FILTERS]; // list of filters
extern gint filters_index; // index to filters array

#ifdef __cplusplus
extern "C" {
#endif
gboolean load_plugin(gchar* plugin,gchar* directory);
gboolean init_plugins(void);
void /*gboolean*/ close_plugins(void);
#ifdef __cplusplus
}
#endif


