#ifndef __ABOOK_H__
#define __ABOOK_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/

#include "rstring.h"

/****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

extern void abook_init (void);
extern void abook_free_resources (void);
extern void abook_put_loaded (void);
extern void abook_load (void);
extern void abook_save (void);

extern void abook_new_prepare (void);
extern void abook_new_drop (void);
extern void abook_new_store (void);
extern int  abook_new_field (const char *field);
extern void abook_new_value (const char *value);

extern void abook_refresh (void);
extern void abook_redraw (void);
extern void abook_set_focus (void);
extern void abook_unset_focus (void);

extern void abook_add_refresh (void);
extern void abook_add_redraw (void);
extern void abook_add_set_focus (void);
extern void abook_add_unset_focus (void);

/** open address book window */
extern void abook_show (void);
/** close this window */
extern void abook_hide (void);
/** sort address book */
extern void abook_sort (void);
/** move bar to the next position */
extern void abook_next (void);
/** move bar to the previous position */
extern void abook_prev (void);
/** move on to the next page */
extern void abook_next_page (void);
/** move to the previous page */
extern void abook_prev_page (void);
/** move bar to the first position */
extern void abook_first (void);
/** move bar to the last position */
extern void abook_last (void);
/** select / unselect this address */
extern void abook_hit (void);
/** revert selection */
extern void abook_hit_all (void);
/** select this address */
extern void abook_set (void);
/** unselect this address */
extern void abook_unset (void);
/** select all */
extern void abook_set_all (void);
/** unselect all */
extern void abook_unset_all (void);
/** change name */
extern void abook_change_name (void);
/** change email */
extern void abook_change_email (void);
/** change groups */
extern void abook_change_groups (void);
/** change sex */
extern void abook_change_sex (void);
/** change official flag */
extern void abook_change_official (void);
/** change foreign flag */
extern void abook_change_foreign (void);
/** delete address(es) */
extern void abook_remove (void);
/** insert new address */
extern void abook_insert (void);
/** compose new message */
extern void abook_compose (void);
/** search forward */
extern void abook_search_forward (void);
/** search backward */
extern void abook_search_backward (void);

/** open address list */
extern void abook_add_show (void);
/** close this window */
extern void abook_add_hide (void);
/** move on to the next position */
extern void abook_add_next (void);
/** move to the previous position */
extern void abook_add_prev (void);
/** move on to the next page */
extern void abook_add_next_page (void);
/** move to the previous page */
extern void abook_add_prev_page (void);
/** move to the first position */
extern void abook_add_first (void);
/** move to the last position */
extern void abook_add_last (void);
/** add this address to addressbook */
extern void abook_add_hit (void);

extern rstring_t *abook_strings (const char *prefix);

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER abook.h
 *
 ****************************************************************************/
#endif
