#ifndef __ATTACH_H__
#define __ATTACH_H__ 1
/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003, 2004 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/
/****************************************************************************
 *    INTERFACE REQUIRED HEADERS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DATA DECLARATIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTION PROTOTYPES
 ****************************************************************************/

extern void attach_init (void);
extern void attach_free_resources (void);

/** show attachments */
extern void attach_show (void);
/** close this window */
extern void attach_hide (void);

/** refresh this window */
extern void attach_refresh (void);
/*+
  If there is a handler defined for this kind of attachment,
  then the handler is executed.  If elmo is a handler, then
  attachment content is shown in elmo window.
  +*/
/** display this attachment */
extern void attach_hit (void);
/** move on to the next position */
extern void attach_next (void);
/** move to the previous position */
extern void attach_prev (void);
/** move on to the next page */
extern void attach_next_page (void);
/** move to the previous page */
extern void attach_prev_page (void);
/** move to the first position */
extern void attach_first (void);
/** move to the last position */
extern void attach_last (void);
/** save attachment to file */
extern void attach_save (void);
/** save all attachments in specified directory */
extern void attach_save_all (void);

/****************************************************************************
 *    INTERFACE OBJECT CLASS DEFINITIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE TRAILING HEADERS
 ****************************************************************************/
/****************************************************************************
 *
 *    END HEADER attach.h
 *
 ****************************************************************************/
#endif
