/* 
   elmo - ELectronic Mail Operator

   Copyright (C) 2003 rzyjontko

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; version 2.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

   ----------------------------------------------------------------------

   
   
*/
/****************************************************************************
 *    IMPLEMENTATION HEADERS
 ****************************************************************************/

#include <string.h>

#include "xmalloc.h"
#include "rarray.h"

/****************************************************************************
 *    IMPLEMENTATION PRIVATE DEFINITIONS / ENUMERATIONS / SIMPLE TYPEDEFS
 ****************************************************************************/

#define INITIAL_ARRAY_SIZE 10

/****************************************************************************
 *    IMPLEMENTATION PRIVATE CLASS PROTOTYPES / EXTERNAL CLASS REFERENCES
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE STRUCTURES / UTILITY CLASSES
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION REQUIRED EXTERNAL REFERENCES (AVOID)
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE DATA
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE DATA
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE FUNCTION PROTOTYPES
 ****************************************************************************/
/****************************************************************************
 *    IMPLEMENTATION PRIVATE FUNCTIONS
 ****************************************************************************/
/****************************************************************************
 *    INTERFACE FUNCTIONS
 ****************************************************************************/

rarray_t *
rarray_create_size (size_t size)
{
        rarray_t *result;

        if (size == 0)
                return NULL;
  
        result           = xmalloc (sizeof (rarray_t));
        result->flags    = 0;
        result->count    = 0;
        result->size     = size;
        result->array    = xcalloc (size, sizeof (void *));
        result->array[0] = NULL;
        return result;
}


rarray_t *
rarray_create (void)
{
        return rarray_create_size (INITIAL_ARRAY_SIZE);
}



void
rarray_destroy (rarray_t *ptr)
{
        xfree (ptr->array);
        xfree (ptr);
}



void
rarray_add (rarray_t *ptr, void *p)
{
        if (ptr->count >= ptr->size - 1){
                ptr->size  = (ptr->size + 1) * 2;
                ptr->array = xrealloc (ptr->array,
                                       ptr->size * sizeof (void *));
        }

        if (p == NULL)
                return;
  
        ptr->array[ptr->count]     = p;
        ptr->array[ptr->count + 1] = NULL;
        ptr->count++;
}



void
rarray_remove (rarray_t *ptr, unsigned index)
{
        if (index >= ptr->count || index < 0)
                return;

        memmove (ptr->array + index, ptr->array + index + 1,
                 (ptr->count - index) * sizeof (void *));

        ptr->count--;
}



void
rarray_shrink (rarray_t *ptr)
{
        ptr->size  = ptr->count + 1;
        ptr->array = xrealloc (ptr->array, ptr->size * sizeof (void *));
}



rarray_t *
rarray_join (rarray_t *x, rarray_t *y)
{
        rarray_t *result;

        if (x == NULL)
                return y;

        if (y == NULL)
                return x;
  
        result = rarray_create_size (x->count + y->count +1);

        memcpy (result->array, x->array, x->count * sizeof (void *));
        memcpy (result->array + x->count, y->array,
                y->count * sizeof (void *));

        result->count                = x->count + y->count;
        result->array[result->count] = NULL;

        rarray_destroy (x);
        rarray_destroy (y);
        return result;
}


void
rarray_add_array (rarray_t *x, rarray_t *y, int (*pred)(void *))
{
        void **ptr;

        for (ptr = y->array; *ptr; ptr++)
                if (pred (*ptr))
                        rarray_add (x, *ptr);
}


/****************************************************************************
 *    INTERFACE CLASS BODIES
 ****************************************************************************/
/****************************************************************************
 *
 *    END MODULE rarray.c
 *
 ****************************************************************************/
