/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.emboss.jemboss.Jemboss;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.AdvancedOptions;
import org.emboss.jemboss.gui.ScrollPanel;
import org.emboss.jemboss.gui.ShowResultSet;
import org.emboss.jemboss.gui.TabListCellRenderer;
import org.emboss.jemboss.programs.JembossProcess;
import org.emboss.jemboss.programs.ResultList;
import org.emboss.jemboss.programs.ResultsUpdateTimer;
import org.emboss.jemboss.soap.AuthPopup;
import org.emboss.jemboss.soap.JembossSoapException;
import org.emboss.jemboss.soap.PendingResults;

public class ShowSavedResults
extends JFrame {
    private Cursor cbusy = new Cursor(3);
    private Cursor cdone = new Cursor(0);
    private DefaultListModel datasets = new DefaultListModel();
    private ScrollPanel sp = new ScrollPanel();
    private JTextArea aboutRes;
    private JScrollPane aboutScroll;
    private JScrollPane ss;
    private JPanel resButtonStatus;
    private JTextField statusField;
    private JMenuBar resMenu = new JMenuBar();
    private ImageIcon rfii;

    public ShowSavedResults(String frameName) {
        super(frameName);
        this.aboutRes = new JTextArea("Select a result set from\nthose listed and details\nof that analysis will be\nshown here. Then you can\neither delete or view those\nresults using the buttons below.");
        this.aboutScroll = new JScrollPane(this.aboutRes);
        this.ss = new JScrollPane(this.sp);
        this.ss.getViewport().setBackground(Color.white);
        ClassLoader cl = this.getClass().getClassLoader();
        this.rfii = new ImageIcon(cl.getResource("images/Refresh_button.gif"));
        this.resButtonStatus = new JPanel(new BorderLayout());
        Border loweredbevel = BorderFactory.createLoweredBevelBorder();
        Border raisedbevel = BorderFactory.createRaisedBevelBorder();
        CompoundBorder compound = BorderFactory.createCompoundBorder(raisedbevel, loweredbevel);
        this.statusField = new JTextField();
        this.statusField.setBorder(compound);
        this.statusField.setEditable(false);
    }

    public ShowSavedResults(final JembossParams mysettings, final JFrame f) {
        this("Saved results list" + (Jemboss.withSoap ? " on server" : ""));
        Dimension d = new Dimension(270, 270);
        this.ss.setPreferredSize(d);
        try {
            final ResultList reslist = new ResultList(mysettings);
            JMenu resFileMenu = new JMenu("File");
            this.resMenu.add(resFileMenu);
            final JCheckBoxMenuItem listByProgram = new JCheckBoxMenuItem("List by program");
            listByProgram.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ShowSavedResults.this.listByProgramName();
                }
            });
            resFileMenu.add(listByProgram);
            JCheckBoxMenuItem listByDate = new JCheckBoxMenuItem("List by date", true);
            listByDate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ShowSavedResults.this.listByDateRun(reslist, false);
                }
            });
            resFileMenu.add(listByDate);
            ButtonGroup group = new ButtonGroup();
            group.add(listByProgram);
            group.add(listByDate);
            JButton refresh = new JButton(this.rfii);
            refresh.setMargin(new Insets(0, 1, 0, 1));
            refresh.setToolTipText("Refresh");
            this.resMenu.add(refresh);
            refresh.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        ShowSavedResults.this.setCursor(ShowSavedResults.this.cbusy);
                        ResultList newlist = new ResultList(mysettings);
                        ShowSavedResults.this.setCursor(ShowSavedResults.this.cdone);
                        if (newlist.getStatus().equals("0")) {
                            reslist.updateRes(newlist.hash());
                            ShowSavedResults.this.datasets.removeAllElements();
                            StringTokenizer tok = new StringTokenizer((String)reslist.get("list"), "\n");
                            while (tok.hasMoreTokens()) {
                                ShowSavedResults.this.datasets.addElement(ShowSavedResults.convertToPretty(tok.nextToken()));
                            }
                            if (listByProgram.isSelected()) {
                                ShowSavedResults.this.listByProgramName();
                            } else {
                                ShowSavedResults.this.listByDateRun(reslist, false);
                            }
                        } else {
                            JOptionPane.showMessageDialog(null, newlist.getStatusMsg(), "Soap Error", 0);
                        }
                    }
                    catch (JembossSoapException eae) {
                        AuthPopup ap = new AuthPopup(mysettings, f);
                        ap.setBottomPanel();
                        ap.setSize(380, 170);
                        ap.pack();
                        ap.setVisible(true);
                    }
                }
            });
            resFileMenu.addSeparator();
            JMenuItem resFileMenuExit = new JMenuItem("Close");
            resFileMenuExit.setAccelerator(KeyStroke.getKeyStroke(69, 2));
            resFileMenuExit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ShowSavedResults.this.dispose();
                }
            });
            resFileMenu.add(resFileMenuExit);
            this.setJMenuBar(this.resMenu);
            this.listByDateRun(reslist, true);
            final JList st = new JList(this.datasets);
            st.setCellRenderer(new TabListCellRenderer());
            st.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    JList theList = (JList)e.getSource();
                    if (theList.isSelectionEmpty()) {
                        System.out.println("Empty selection");
                    } else {
                        int index = theList.getSelectedIndex();
                        String thisdata = ShowSavedResults.this.convertToOriginal(ShowSavedResults.this.datasets.elementAt(index));
                        ShowSavedResults.this.aboutRes.setText((String)reslist.get(thisdata));
                        ShowSavedResults.this.aboutRes.setCaretPosition(0);
                    }
                }
            });
            st.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        try {
                            ShowSavedResults.this.setCursor(ShowSavedResults.this.cbusy);
                            String project = ShowSavedResults.this.convertToOriginal(st.getSelectedValue());
                            ResultList thisres = new ResultList(mysettings, project, "show_saved_results");
                            new ShowResultSet(thisres.hash(), project, mysettings);
                            ShowSavedResults.this.setCursor(ShowSavedResults.this.cdone);
                        }
                        catch (JembossSoapException eae) {
                            AuthPopup ap = new AuthPopup(mysettings, f);
                            ap.setBottomPanel();
                            ap.setSize(380, 170);
                            ap.pack();
                            ap.setVisible(true);
                        }
                    }
                }
            });
            this.sp.add(st);
            JPanel resButtonPanel = new JPanel();
            JButton showResButton = new JButton("Display");
            showResButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String sel = ShowSavedResults.this.convertToOriginal(st.getSelectedValue());
                    if (sel != null) {
                        try {
                            ShowSavedResults.this.setCursor(ShowSavedResults.this.cbusy);
                            ResultList thisres = new ResultList(mysettings, sel, "show_saved_results");
                            new ShowResultSet(thisres.hash(), sel, mysettings);
                            ShowSavedResults.this.setCursor(ShowSavedResults.this.cdone);
                        }
                        catch (JembossSoapException eae) {
                            AuthPopup ap = new AuthPopup(mysettings, f);
                            ap.setBottomPanel();
                            ap.setSize(380, 170);
                            ap.pack();
                            ap.setVisible(true);
                        }
                    } else {
                        ShowSavedResults.this.statusField.setText("Nothing selected to be displayed.");
                    }
                }
            });
            JButton addNoteButton = new JButton("Edit Notes");
            addNoteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String sel = ShowSavedResults.this.convertToOriginal(st.getSelectedValue());
                    if (sel != null) {
                        try {
                            ShowSavedResults.this.setCursor(ShowSavedResults.this.cbusy);
                            ResultList thisres = new ResultList(mysettings, sel, "Notes", "show_saved_results");
                            new ShowResultSet(thisres.hash(), sel, mysettings);
                            ShowSavedResults.this.setCursor(ShowSavedResults.this.cdone);
                        }
                        catch (JembossSoapException eae) {
                            AuthPopup ap = new AuthPopup(mysettings, f);
                            ap.setBottomPanel();
                            ap.setSize(380, 170);
                            ap.pack();
                            ap.setVisible(true);
                        }
                    } else {
                        ShowSavedResults.this.statusField.setText("Selected a project!");
                    }
                }
            });
            JButton delResButton = new JButton("Delete");
            delResButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Object[] sel = st.getSelectedValues();
                    if (sel != null) {
                        String selList = new String("");
                        JTextPane delList = new JTextPane();
                        FontMetrics fm = delList.getFontMetrics(delList.getFont());
                        int maxWidth = 0;
                        for (int i = 0; i < sel.length; ++i) {
                            selList = i == sel.length - 1 ? selList.concat((String)sel[i]) : selList.concat(sel[i] + "\n");
                            int width = fm.stringWidth((String)sel[i]);
                            if (width <= maxWidth) continue;
                            maxWidth = width;
                        }
                        int ok = 0;
                        if (sel.length > 1) {
                            JScrollPane scrollDel = new JScrollPane(delList);
                            delList.setText(selList);
                            delList.setEditable(false);
                            delList.setCaretPosition(0);
                            Dimension d1 = delList.getPreferredSize();
                            int maxHeight = (int)d1.getHeight() + 5;
                            if (maxHeight > 350) {
                                maxHeight = 350;
                            } else if (maxHeight < 50) {
                                maxHeight = 50;
                            }
                            scrollDel.setPreferredSize(new Dimension(maxWidth + 30, maxHeight));
                            ok = JOptionPane.showConfirmDialog(null, scrollDel, "Confirm Deletion", 0);
                        }
                        if (ok == 0) {
                            try {
                                ShowSavedResults.this.setCursor(ShowSavedResults.this.cbusy);
                                selList = ShowSavedResults.this.convertToOriginal(selList);
                                new ResultList(mysettings, selList, "delete_saved_results");
                                ShowSavedResults.this.setCursor(ShowSavedResults.this.cdone);
                                for (int i = 0; i < sel.length; ++i) {
                                    ShowSavedResults.this.datasets.removeElement(sel[i]);
                                }
                                ShowSavedResults.this.statusField.setText("Deleted " + sel.length + "  result(s)");
                                ShowSavedResults.this.aboutRes.setText("");
                                st.setSelectedIndex(-1);
                            }
                            catch (JembossSoapException eae) {
                                AuthPopup ap = new AuthPopup(mysettings, f);
                                ap.setBottomPanel();
                                ap.setSize(380, 170);
                                ap.pack();
                                ap.setVisible(true);
                            }
                        }
                    } else {
                        ShowSavedResults.this.statusField.setText("Nothing selected for deletion.");
                    }
                }
            });
            resButtonPanel.add(delResButton);
            resButtonPanel.add(addNoteButton);
            resButtonPanel.add(showResButton);
            this.resButtonStatus.add((Component)resButtonPanel, "Center");
            this.resButtonStatus.add((Component)this.statusField, "South");
            Container c = this.getContentPane();
            c.add((Component)this.ss, "West");
            c.add((Component)this.aboutScroll, "Center");
            c.add((Component)this.resButtonStatus, "South");
            this.pack();
            this.setVisible(true);
        }
        catch (JembossSoapException eae) {
            AuthPopup ap = new AuthPopup(mysettings, f);
            ap.setBottomPanel();
            ap.setSize(380, 170);
            ap.pack();
            ap.setVisible(true);
        }
    }

    public ShowSavedResults(final JembossParams mysettings, final PendingResults epr) throws JembossSoapException {
        this("Current Sessions Results");
        Dimension d = new Dimension(270, 100);
        this.ss.setPreferredSize(d);
        JMenu resFileMenu = new JMenu("File");
        this.resMenu.add(resFileMenu);
        JButton refresh = new JButton(this.rfii);
        refresh.setMargin(new Insets(0, 1, 0, 1));
        refresh.setToolTipText("Refresh");
        this.resMenu.add(refresh);
        refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ShowSavedResults.this.setCursor(ShowSavedResults.this.cbusy);
                epr.updateStatus();
                ShowSavedResults.this.setCursor(ShowSavedResults.this.cdone);
                ShowSavedResults.this.datasets.removeAllElements();
                Enumeration enumer = epr.descriptionHash().keys();
                while (enumer.hasMoreElements()) {
                    String image = ShowSavedResults.convertToPretty((String)enumer.nextElement());
                    ShowSavedResults.this.datasets.addElement(image);
                }
            }
        });
        JMenuItem resFileMenuExit = new JMenuItem("Close");
        resFileMenuExit.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        resFileMenuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ShowSavedResults.this.dispose();
            }
        });
        resFileMenu.add(resFileMenuExit);
        this.setJMenuBar(this.resMenu);
        Enumeration enumer = epr.descriptionHash().keys();
        while (enumer.hasMoreElements()) {
            this.datasets.addElement(ShowSavedResults.convertToPretty((String)enumer.nextElement()));
        }
        final JList st = new JList(this.datasets);
        st.setCellRenderer(new TabListCellRenderer());
        st.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                JList theList = (JList)e.getSource();
                if (!theList.isSelectionEmpty()) {
                    int index = theList.getSelectedIndex();
                    String thisdata = ShowSavedResults.this.convertToOriginal(ShowSavedResults.this.datasets.elementAt(index));
                    ShowSavedResults.this.aboutRes.setText((String)epr.descriptionHash().get(thisdata));
                    ShowSavedResults.this.aboutRes.setCaretPosition(0);
                    ShowSavedResults.this.aboutRes.setEditable(false);
                }
            }
        });
        st.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    try {
                        ShowSavedResults.this.setCursor(ShowSavedResults.this.cbusy);
                        String project = ShowSavedResults.this.convertToOriginal(st.getSelectedValue());
                        ResultList thisres = new ResultList(mysettings, project, "show_saved_results");
                        ShowSavedResults.this.setCursor(ShowSavedResults.this.cdone);
                        if (thisres.getStatus().equals("0")) {
                            new ShowResultSet(thisres.hash(), project, mysettings);
                        } else {
                            JOptionPane.showMessageDialog(null, thisres.getStatusMsg(), "Soap Error", 0);
                        }
                    }
                    catch (JembossSoapException eae) {
                        AuthPopup ap = new AuthPopup(mysettings, null);
                        ap.setBottomPanel();
                        ap.setSize(380, 170);
                        ap.pack();
                        ap.setVisible(true);
                    }
                }
            }
        });
        this.sp.add(st);
        JPanel resButtonPanel = new JPanel();
        JButton showResButton = new JButton("Display");
        showResButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (st.getSelectedValue() != null) {
                    try {
                        ShowSavedResults.this.setCursor(ShowSavedResults.this.cbusy);
                        String project = ShowSavedResults.this.convertToOriginal(st.getSelectedValue());
                        ResultList thisres = new ResultList(mysettings, project, "show_saved_results");
                        ShowSavedResults.this.setCursor(ShowSavedResults.this.cdone);
                        if (thisres.getStatus().equals("0")) {
                            new ShowResultSet(thisres.hash(), project, mysettings);
                        } else {
                            JOptionPane.showMessageDialog(null, thisres.getStatusMsg(), "Soap Error", 0);
                        }
                    }
                    catch (JembossSoapException eae) {
                        ShowSavedResults.this.setCursor(ShowSavedResults.this.cdone);
                        AuthPopup ap = new AuthPopup(mysettings, null);
                        ap.setBottomPanel();
                        ap.setSize(380, 170);
                        ap.pack();
                        ap.setVisible(true);
                    }
                }
            }
        });
        JButton delResButton = new JButton("Delete");
        delResButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object[] sel = st.getSelectedValues();
                if (sel != null) {
                    String selList = new String("");
                    for (int i = 0; i < sel.length; ++i) {
                        selList = selList.concat(sel[i] + "\n");
                    }
                    int ok = 0;
                    if (sel.length > 1) {
                        ok = JOptionPane.showConfirmDialog(null, "Delete the following results:\n" + selList, "Confirm Deletion", 0);
                    }
                    if (ok == 0) {
                        try {
                            ShowSavedResults.this.setCursor(ShowSavedResults.this.cbusy);
                            selList = ShowSavedResults.this.convertToOriginal(selList);
                            new ResultList(mysettings, selList, "delete_saved_results");
                            ShowSavedResults.this.setCursor(ShowSavedResults.this.cdone);
                            for (int i = 0; i < sel.length; ++i) {
                                JembossProcess jp = epr.getResult(ShowSavedResults.this.convertToOriginal(sel[i]));
                                epr.removeResult(jp);
                                ShowSavedResults.this.datasets.removeElement(sel[i]);
                            }
                            ShowSavedResults.this.statusField.setText("Deleted " + sel.length + "  result(s)");
                            ShowSavedResults.this.aboutRes.setText("");
                            st.setSelectedIndex(-1);
                        }
                        catch (JembossSoapException eae) {
                            AuthPopup ap = new AuthPopup(mysettings, null);
                            ap.setBottomPanel();
                            ap.setSize(380, 170);
                            ap.pack();
                            ap.setVisible(true);
                        }
                    }
                }
            }
        });
        resButtonPanel.add(delResButton);
        resButtonPanel.add(showResButton);
        this.resButtonStatus.add((Component)resButtonPanel, "Center");
        this.resButtonStatus.add((Component)this.statusField, "South");
        Container c = this.getContentPane();
        c.add((Component)this.ss, "West");
        c.add((Component)this.aboutScroll, "Center");
        c.add((Component)this.resButtonStatus, "South");
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setVisible(true);
        String freq = (String)AdvancedOptions.jobMgr.getSelectedItem();
        int ind = freq.indexOf(" ");
        new ResultsUpdateTimer(Integer.parseInt(freq.substring(0, ind)), this.datasets, this);
        this.statusField.setText("Window refresh rate " + freq);
    }

    private void listByDateRun(ResultList reslist, boolean ldisp) {
        StringTokenizer tokenizer = new StringTokenizer((String)reslist.get("list"), "\n");
        Vector<String> vdata = new Vector<String>();
        while (tokenizer.hasMoreTokens()) {
            String data = ShowSavedResults.convertToPretty(tokenizer.nextToken());
            if (!this.datasets.contains(data) && !ldisp) continue;
            vdata.add(data);
        }
        this.datasets.removeAllElements();
        Enumeration en = vdata.elements();
        while (en.hasMoreElements()) {
            this.datasets.addElement(en.nextElement());
        }
    }

    private void listByProgramName() {
        int i;
        int nresult = this.datasets.size();
        Object[] res = new String[nresult];
        for (i = 0; i < nresult; ++i) {
            res[i] = (String)this.datasets.getElementAt(i);
        }
        Arrays.sort(res);
        this.datasets.removeAllElements();
        for (i = 0; i < nresult; ++i) {
            this.datasets.addElement(res[i]);
        }
    }

    public static String convertToPretty(String sorig) {
        return sorig.replace('_', ' ');
    }

    private String convertToOriginal(Object sorig) {
        String s = ((String)sorig).replace('\t', '_');
        return s.replace(' ', '_');
    }
}

