#!/usr/bin/env entity

<object name="enview">
  <system-args name="args" />

  <perl>
    <![CDATA[
		my $node = enode("system-args.args");

		my $working_dir = $node->attrib("startup-directory") . "/";

		my $obj = enode("object.enview");

		my @children = $node->children();

        my $found_image = "false";

		foreach my $child (@children)
		{
		  my $name = $child->attrib("name");
          chomp($name);

          if (! -e $name)
		  {
			$name = $working_dir . $name;
          }

          if ( (-e $name) && 
             ($name =~ /.gif/i||$name =~ /.jpg/i||$name =~ /.png/i||$name =~ /.xpm/i))
          {
            my $newimage=qq!
            <window name="image" ondelete="entity:exit">
             <valign expand="true">
               <scrollwindow expand="true">
                 <valign>
		   <image name="image" src="$name"/>
		 </valign>
               </scrollwindow>
             </valign>
            </window>!;
            $obj->append_xml("$newimage");
			$found_image = "true";
		    print "opening file: $name\n";
			last;
          }
		}

		if ($found_image eq "true")
		{
			my $image = enode("image.image");
			my $window = enode("window.image");
			my $width = int($image->attrib("width")) + 15;
			my $height = int($image->attrib("height")) + 15;

			if ($width > 800)
			{
				$width = 800;
			}
			if ($height > 600)
			{
				$height = 600;
			}
			$window->attrib("width" => "$width" );
			$window->attrib("height" => "$height" );	
		}
		else
		{
			# Print usage and die.
			print "error processing command line options\n\n";
			print "usage: enview image_name.[jpg | gif | png | xpm ]\n";
			exit;
		}
	]]>
  </perl>
</object>
