#!/usr/bin/env entity

<object default-lang="tcl">
  <?tcl proc quit {node args} { if {"q" == [lindex $args 0]} { $node entity:exit } } ?>
  <window onkeypress = "quit" ondelete = "entity:exit" title = "Arc Test (q to quit)" width = "500" height = "400">
    <object expand = "true" fill = "true" default-lang = "tcl">
      <timer interval = "60" action = "motion"/>
      <graph name="graph-arc" expand="true" fill="true">

        <!-- simple disc -->
        <graph-point x="20" y="50" width="20" type = "arc" color="#ff0000"/>

        <!-- green ellipse -->
        <graph-point x="50" y="100" width="80" height="50" size = "7" type = "arc" color="#00ff00" filled = "no"/>

        <!-- big (magenta) rotating pie in the center -->
        <graph-point name = "mag" x="50" y="70" width="120" height="180"
        type = "arc" angle-start = "30" angle-range = "310" color="#ff00ff"
        filled = "1"/>

        <!-- blue pie -->
        <graph-point x="100" y="50" width="60" type = "arc" angle-start="30" angle-range="80" color="#0000ff"/>
      </graph>
      <?tcl
        set fact 5.0
        set calls 0
        proc motion {node args} {
          global fact calls
          set point [enode graph-point.mag]
          # set graph [enode graph]
          # $graph attrib frozen 1

          set angle_start [$point attrib angle-start]
          incr angle_start 5

          set width [$point attrib width]
          if {$width > 250} {
            set fact -5.0
          } elseif {$width < 50} {
            set fact 5.0
          }
          incr calls
          if {$calls > 10} {
            set calls 0
            set filled [$point attrib filled]
            $point attrib filled [expr $filled ? 0 : 1]
          }
          # set filled [$point attrib filled]
          incr width [expr int(rand() * $fact)]
          $point attrib angle-start $angle_start width $width
        }
      ?>
    </object>
  </window>
</object>
