#ifndef __EBUFFER_H__
#define __EBUFFER_H__

#include <glib.h>


typedef enum {
    EBUF_CHUNK_NONE = 0,
    EBUF_CHUNK_SMALL = 1 << 0,
    EBUF_CHUNK_MEDIUM = 1 << 1,
    EBUF_CHUNK_LARGE = 1 << 2
} EBufChunkSize;


typedef struct _EBuf EBuf;
/* An allocated ebuf that needs to be freed. */
typedef struct _EBuf EBufFreeMe;
/* An ebuf that should not be modified. */
typedef struct _EBuf EBufConst;




struct _EBuf {
    gchar *str;
    gint len;
    gint alloc;
    EBufChunkSize type;
};

G_INLINE_FUNC gint ebuf_empty (EBuf * buf);

#ifdef G_CAN_INLINE
G_INLINE_FUNC gint
ebuf_empty (EBuf * buf)
{
    return (!buf || (buf->len == 0));
}
#endif				/* G_CAN_INLINE || __EBUFFER_C__ */

G_INLINE_FUNC gint ebuf_not_empty (EBuf * buf);

#ifdef G_CAN_INLINE
G_INLINE_FUNC gint
ebuf_not_empty (EBuf * buf)
{
    return (buf && (buf->len > 0));
}
#endif				/* G_CAN_INLINE */


EBuf *ebuf_new (void);

EBuf *ebuf_new_sized (guint size);

EBuf *ebuf_new_with_str (gchar * str);

EBuf *ebuf_new_with_int (gint val);

EBuf *ebuf_new_with_data (gchar * str, gint len);

EBuf *ebuf_new_with_ebuf (EBuf * buf);

EBuf *ebuf_new_with_true (void);

EBuf *ebuf_new_with_false (void);

void
 ebuf_free (EBuf * buf);

void
 ebuf_set_to_str (EBuf * buf, gchar * str);

void
 ebuf_set_to_ebuf (EBuf * buf, EBuf * val);

void
 ebuf_set_to_data (EBuf * buf, gchar * str, gint len);

void
 ebuf_append_str (EBuf * buf, gchar * str);

void
 ebuf_append_char (EBuf * buf, gchar c);

void
 ebuf_append_ebuf (EBuf * buf, EBuf * newbuf);

void
 ebuf_append_data (EBuf * buf, gchar * str, gint len);

void
 ebuf_prepend_str (EBuf * buf, gchar * str);

void
 ebuf_prepend_char (EBuf * buf, gchar c);

void
 ebuf_insert_str (EBuf * buf, gint pos, gchar * val);

void
 ebuf_insert_data (EBuf * buf, gint pos, gchar * val, gint len);

void
 ebuf_insert_ebuf (EBuf * buf, gint pos, EBuf * val);

void
 ebuf_erase (EBuf * buf, gint pos, gint len);

void
 ebuf_truncate (EBuf * buf, gint len);

void
 ebuf_sprintf (EBuf * buf, gchar * fmt, ...);

gint ebuf_is_whitespace (EBuf * buf);

gint ebuf_equal_ebuf (EBuf * buf1, EBuf * buf2);

gint ebuf_equal_ebufcase (EBuf * buf1, EBuf * buf2);

gint ebuf_equal_str (EBuf * buf1, gchar * str);

gint ebuf_equal_strcase (EBuf * buf1, gchar * str);

void
 ebuf_down (EBuf * buf);

void
 ebuf_up (EBuf * buf);

guint ebuf_hash (EBuf * buf);

void
 ebuf_stats (void);


#endif				/* __EBUFFER_H__ */


