#include <glib.h>
#include "entity.h"


/* Set a value in a node */
void
enode_set_kv (ENode * node, gchar * key, gpointer value)
{
    ECHECK_RET (node != NULL);
    ECHECK_RET (key != NULL);

    if (!node->entity_data)
	node->entity_data = g_hash_table_new (x31_hash, g_str_equal);

    if (key && value)
	g_hash_table_insert (node->entity_data, key, value);
    else if (key && !value)
	g_hash_table_remove (node->entity_data, key);
}

/* Get a set value */
gpointer enode_get_kv (ENode * node, gchar * key)
{
    gpointer value;

    ECHECK_RETVAL (node != NULL, NULL);

    /* ECHECK_RETVAL (node->entity_data != NULL, NULL); */
    if (!node->entity_data)
	return (NULL);

    value = g_hash_table_lookup (node->entity_data, key);
    return (value);
}


