/***************************************************************************
 *   Copyright (C) 2006, 2007 by Niklas Knutsson                           *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "eqonomize.h"
#include "budget.h"
#include <kuniqueapplication.h>
#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kconfig.h>

QString emptystr = "";;

static const char description[] =  I18N_NOOP("A personal accounting program");

static KCmdLineOptions options[] = {
	{"e", 0, 0},
	{"expenses", I18N_NOOP("Start with expenses list displayed"), 0},
	{"i", 0, 0},
	{"incomes", I18N_NOOP("Start with incomes list displayed"), 0},
	{"t", 0, 0},
	{"transfers", I18N_NOOP("Start with transfers list displayed"), 0},
	{"+[URL]", I18N_NOOP( "Document to open" ), 0},
	KCmdLineLastOption
};

int main(int argc, char **argv) {

	KAboutData about("eqonomize", I18N_NOOP("Eqonomize!"), VERSION, description, KAboutData::License_GPL, "(C) 2006 Niklas Knutsson", 0, "http://eqonomize.sourceforge.net/", "nique769@users.sourceforge.net");
	about.addAuthor("Niklas Knutsson", 0, "nq@altern.org");
	KCmdLineArgs::init(argc, argv, &about);
	KCmdLineArgs::addCmdLineOptions(options);
	KUniqueApplication::addCmdLineOptions();
		
	if(!KUniqueApplication::start()) {
		RESTORE(Eqonomize)
 		return 0;
	}
	KUniqueApplication app;

	if(kapp->isRestored()) {
		RESTORE(Eqonomize)
	} else {
		KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		Eqonomize *win = new Eqonomize();
		kapp->setMainWidget(win);
		if(args->isSet("expenses")) {
			win->showExpenses();
		} else if(args->isSet("incomes")) {
			win->showIncomes();
		} else if(args->isSet("transfers")) {
			win->showTransfers();
		}
		win->show();
		qApp->processEvents();
		kapp->config()->setGroup("General Options");
		QString url = kapp->config()->readPathEntry("lastURL");
		if(args->count() > 0) {
			win->openURL(args->url(0));
		} else if(!url.isEmpty()) {
			win->openURL(KURL(url));
			win->readFileDependentOptions();
		} else {
			if(!win->crashRecovery(KURL())) {
				win->createDefaultBudget();
			}
		}
		args->clear();
	}
	
	return app.exec();

}
