# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Compatibility module to use the KDE Color Dialog instead of the Qt Color Dialog.
"""

import os

import Preferences

try:
    raise ImportError
    # TODO: KDE 4
##    from kdeui import KColorDialog
##    from qt import Qt, QColor
##    
##    def __kdeGetColor(initial = Qt.white, parent = None):
##        """
##        Public function to pop up a modal dialog to select a color.
##        
##        @param initial initial color to select (QColor)
##        @param parent parent widget of the dialog (QWidget)
##        @return the selected color or the invalid color, if the user
##            canceled the dialog (QColor)
##        """
##        col = QColor(initial)
##        res = KColorDialog.getColor(col, parent)
##        if res == KColorDialog.Accepted:
##            return col
##        else:
##            return QColor()
    
except (ImportError, RuntimeError):
    os.environ["e4nokde"] = "1"
    
from PyQt4.QtCore import Qt
from  PyQt4.QtGui import QColorDialog, QColor

__qtGetColor = QColorDialog.getColor

################################################################################

def getColor(initial = QColor(Qt.white), parent = None):
    """
    Public function to pop up a modal dialog to select a color.
    
    @param initial initial color to select (QColor)
    @param parent parent widget of the dialog (QWidget)
    @return the selected color or the invalid color, if the user
        canceled the dialog (QColor)
    """
    if Preferences.getUI("UseKDEDialogs") and not os.getenv("e4nokde"):
        return __kdeGetColor(initial, parent)
    else:
        return __qtGetColor(initial, parent)
