/* scroller-plugin.h */

#ifndef __SCROLLER_PLUGIN_H__
#define __SCROLLER_PLUGIN_H__

#include <glib-object.h>
#include <ethos/ethos.h>
#include <ethos/ethos-ui.h>

G_BEGIN_DECLS

#define SCROLLER_TYPE_PLUGIN            (scroller_plugin_get_type())          
#define SCROLLER_PLUGIN(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCROLLER_TYPE_PLUGIN, ScrollerPlugin))     
#define SCROLLER_PLUGIN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass),  SCROLLER_TYPE_PLUGIN, ScrollerPluginClass))
#define SCROLLER_IS_PLUGIN(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCROLLER_TYPE_PLUGIN))                  
#define SCROLLER_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),  SCROLLER_TYPE_PLUGIN))                  
#define SCROLLER_PLUGIN_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj),  SCROLLER_TYPE_PLUGIN, ScrollerPluginClass))

typedef struct _ScrollerPlugin        ScrollerPlugin;
typedef struct _ScrollerPluginClass   ScrollerPluginClass;
typedef struct _ScrollerPluginPrivate ScrollerPluginPrivate;

struct _ScrollerPlugin
{
	EthosPlugin parent;

	/*< private >*/
	ScrollerPluginPrivate *priv;
};

struct _ScrollerPluginClass
{
	EthosPluginClass parent_class;
};

GType        scroller_plugin_get_type (void);
EthosPlugin* scroller_plugin_new      (void);

G_END_DECLS

#endif /* __SCROLLER_PLUGIN_H__ */


/* scroller-plugin.c */
#include "sample.h"

G_DEFINE_TYPE (ScrollerPlugin, scroller_plugin, ETHOS_TYPE_PLUGIN)

struct _ScrollerPluginPrivate
{
	GtkWidget *scroller;
};

static void
activated (EthosPlugin *plugin)
{
	GtkWidget *scroller;

	SCROLLER_PLUGIN (plugin)->priv->scroller = scroller = gtk_hscale_new (NULL);
	sample_add_widget (scroller);
	gtk_widget_show (scroller);
}

static void
deactivated (EthosPlugin *plugin)
{
	sample_remove_widget (SCROLLER_PLUGIN (plugin)->priv->scroller);
}

static void
scroller_plugin_class_init (ScrollerPluginClass *klass)
{
	EthosPluginClass *plugin_class;

	g_type_class_add_private (klass, sizeof (ScrollerPluginPrivate));

	plugin_class = ETHOS_PLUGIN_CLASS (klass);
	plugin_class->activated = activated;
	plugin_class->deactivated = deactivated;
}

static void
scroller_plugin_init (ScrollerPlugin *plugin)
{
	plugin->priv = G_TYPE_INSTANCE_GET_PRIVATE (plugin,
	                                            SCROLLER_TYPE_PLUGIN,
	                                            ScrollerPluginPrivate);
}

EthosPlugin*
scroller_plugin_new (void)
{
	return g_object_new (SCROLLER_TYPE_PLUGIN, NULL);
}

G_MODULE_EXPORT EthosPlugin*
ethos_plugin_register (void)
{
	return scroller_plugin_new ();
}
