/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: LvmUtils/helpers
 * File: get_regin_handle.c
 */

#ifndef _LVM_HELP_GET_REGION_HANDLE_
#define _LVM_HELP_GET_REGION_HANDLE_ 1

#include "translate_name.c"

/* Function: get_region_handle
 *
 *	Find the Engine handle for the specified LVM region.
 */
int get_region_handle(	char		* name,
			object_handle_t	* handle )
{
	char	region_name[EVMS_VOLUME_NAME_SIZE] = {0};
	int	rc = 0;

	translate_lv_name_to_region_name(name, region_name);

	if ( opts.verbose ) {
		printf("%s -- Searching for region %s\n", cmd, region_name);
	}

	if ( (rc = evms_get_object_handle_for_name(REGION, region_name, handle)) ) {
		printf("%s -- Could not find handle for region %s\n", cmd, region_name);
		*handle = 0;
		return rc;
	}

	if ( opts.verbose ) {
		printf("%s -- Found region %s at handle %u\n", cmd, region_name, *handle);
	}

	return 0;
}

#endif

