/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */ 

typedef void (*populate_func)(void);
typedef enum {
	VOLUME_VIEW = 0,
	OBJECT_VIEW,
	FEATURE_VIEW,
	REGION_VIEW,
	CONTAINER_VIEW,
	SEGMENT_VIEW,
	DISK_VIEW,
	PLUGIN_VIEW,
	MAX_VIEWS
} view_type_t;

#define VOLUME_VIEW_COLUMNS	7
#define OBJECT_VIEW_COLUMNS	6
#define FEATURE_VIEW_COLUMNS	6
#define REGION_VIEW_COLUMNS	7
#define CONTAINER_VIEW_COLUMNS	4
#define SEGMENT_VIEW_COLUMNS	8
#define DISK_VIEW_COLUMNS	7
#define PLUGIN_VIEW_COLUMNS	5

void init_views(void);
void refresh_views(void);
int process_current_view_events(void);
int jump_to_object(object_handle_t handle);
int jump_to_view_by_handle(struct menu_item *item);

